/*
 * Decompiled with CFR 0.152.
 */
package razerdp.basepopup;

import android.app.Activity;
import android.view.View;
import androidx.fragment.app.DialogFragment;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.OnLifecycleEvent;
import java.lang.ref.WeakReference;
import java.util.List;
import razerdp.basepopup.BasePopupSupporter;
import razerdp.basepopup.BasePopupWindow;

public class BasePopupSupporterX
implements BasePopupSupporter {
    public View findDecorView(BasePopupWindow basePopupWindow, Activity activity) {
        View result = null;
        if (activity instanceof FragmentActivity) {
            try {
                FragmentActivity supportAct = (FragmentActivity)activity;
                List fragments = supportAct.getSupportFragmentManager().getFragments();
                for (Fragment fragment : fragments) {
                    DialogFragment d;
                    if (!(fragment instanceof DialogFragment) || (d = (DialogFragment)fragment).getDialog() == null || !d.getDialog().isShowing() || d.isRemoving()) continue;
                    result = d.getView();
                    break;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public BasePopupWindow attachLifeCycle(BasePopupWindow basePopupWindow, Object owner) {
        if (!(owner instanceof LifecycleOwner) || basePopupWindow.lifeCycleObserver != null) {
            return basePopupWindow;
        }
        ((LifecycleOwner)owner).getLifecycle().addObserver((LifecycleObserver)new BasePopupLifeCycleHolder(basePopupWindow));
        return basePopupWindow;
    }

    public BasePopupWindow removeLifeCycle(BasePopupWindow basePopupWindow, Object owner) {
        if (!(owner instanceof LifecycleOwner) || basePopupWindow.lifeCycleObserver == null) {
            return basePopupWindow;
        }
        ((LifecycleOwner)owner).getLifecycle().removeObserver((LifecycleObserver)basePopupWindow.lifeCycleObserver);
        basePopupWindow.lifeCycleObserver = null;
        return basePopupWindow;
    }

    private class BasePopupLifeCycleHolder
    implements LifecycleObserver {
        WeakReference<BasePopupWindow> mBasePopupWindow;

        BasePopupLifeCycleHolder(BasePopupWindow target) {
            this.mBasePopupWindow = new WeakReference<BasePopupWindow>(target);
            target.lifeCycleObserver = this;
        }

        @OnLifecycleEvent(value=Lifecycle.Event.ON_DESTROY)
        protected void onActivityDestroy() {
            BasePopupWindow popupWindow = this.getPopup();
            if (popupWindow == null) {
                return;
            }
            if (popupWindow.isShowing()) {
                popupWindow.forceDismiss();
            }
            if (popupWindow.getContext() instanceof LifecycleOwner) {
                BasePopupSupporterX.this.removeLifeCycle(popupWindow, popupWindow.getContext());
            }
        }

        BasePopupWindow getPopup() {
            if (this.mBasePopupWindow == null) {
                return null;
            }
            return (BasePopupWindow)this.mBasePopupWindow.get();
        }
    }
}

