/*
 * Decompiled with CFR 0.152.
 */
package razerdp.basepopup;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.app.Activity;
import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.Interpolator;
import android.view.animation.ScaleAnimation;
import android.view.animation.TranslateAnimation;
import android.widget.EditText;
import android.widget.PopupWindow;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.Field;
import razerdp.basepopup.BasePopup;
import razerdp.basepopup.InputMethodUtils;
import razerdp.library.R;

public abstract class BasePopupWindow
implements BasePopup,
PopupWindow.OnDismissListener {
    private static final String TAG = "BasePopupWindow";
    private PopupWindow mPopupWindow;
    private View mPopupView;
    private Activity mContext;
    protected View mAnimaView;
    protected View mDismissView;
    private boolean autoShowInputMethod = false;
    private OnDismissListener mOnDismissListener;
    private Animation mShowAnimation;
    private Animator mShowAnimator;
    private Animation mExitAnimation;
    private Animator mExitAnimator;
    private boolean isExitAnimaPlaying = false;
    private boolean needPopupFadeAnima = true;
    private int popupGravity = 0;
    private int offsetX;
    private int offsetY;
    private int popupViewWidth;
    private int popupViewHeight;
    private int popupRelativePivot;
    private int[] mAnchorViewLocation;
    private boolean relativeToAnchorView;
    private boolean isAutoLocatePopup;
    private boolean showAtDown;
    private boolean dismissWhenTouchOuside;
    private Animator.AnimatorListener mAnimatorListener = new Animator.AnimatorListener(){

        public void onAnimationStart(Animator animation) {
        }

        public void onAnimationEnd(Animator animation) {
            BasePopupWindow.this.mPopupWindow.dismiss();
            BasePopupWindow.this.isExitAnimaPlaying = false;
        }

        public void onAnimationCancel(Animator animation) {
            BasePopupWindow.this.isExitAnimaPlaying = false;
        }

        public void onAnimationRepeat(Animator animation) {
        }
    };
    private Animation.AnimationListener mAnimationListener = new Animation.AnimationListener(){

        public void onAnimationStart(Animation animation) {
        }

        public void onAnimationEnd(Animation animation) {
            BasePopupWindow.this.mPopupWindow.dismiss();
            BasePopupWindow.this.isExitAnimaPlaying = false;
        }

        public void onAnimationRepeat(Animation animation) {
        }
    };

    public BasePopupWindow(Activity context) {
        this.initView(context, -1, -1);
    }

    public BasePopupWindow(Activity context, int w, int h) {
        this.initView(context, w, h);
    }

    private void initView(Activity context, int w, int h) {
        this.mContext = context;
        this.mPopupView = this.onCreatePopupView();
        if (this.mPopupView != null) {
            this.mPopupView.measure(w, h);
            this.popupViewWidth = this.mPopupView.getMeasuredWidth();
            this.popupViewHeight = this.mPopupView.getMeasuredHeight();
            this.mPopupView.setFocusableInTouchMode(true);
        }
        this.mPopupWindow = new PopupWindow(this.mPopupView, w, h);
        this.setDismissWhenTouchOuside(true);
        this.setNeedPopupFade(Build.VERSION.SDK_INT <= 22);
        this.mPopupWindow.setOnDismissListener((PopupWindow.OnDismissListener)this);
        this.mAnimaView = this.initAnimaView();
        this.mDismissView = this.getClickToDismissView();
        if (this.mDismissView != null) {
            this.mDismissView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    BasePopupWindow.this.dismiss();
                }
            });
        }
        if (this.mAnimaView != null) {
            this.mAnimaView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                }
            });
        }
        this.mShowAnimation = this.initShowAnimation();
        this.mShowAnimator = this.initShowAnimator();
        this.mExitAnimation = this.initExitAnimation();
        this.mExitAnimator = this.initExitAnimator();
        this.mAnchorViewLocation = new int[2];
    }

    protected abstract Animation initShowAnimation();

    public abstract View getClickToDismissView();

    protected Animator initShowAnimator() {
        return null;
    }

    public EditText getInputView() {
        return null;
    }

    protected Animation initExitAnimation() {
        return null;
    }

    protected Animator initExitAnimator() {
        return null;
    }

    public void setNeedPopupFade(boolean needPopupFadeAnima) {
        this.needPopupFadeAnima = needPopupFadeAnima;
        this.setPopupAnimaStyle(needPopupFadeAnima ? R.style.PopupAnimaFade : 0);
    }

    public boolean getNeedPopupFade() {
        return this.needPopupFadeAnima;
    }

    public void setPopupAnimaStyle(int animaStyleRes) {
        if (animaStyleRes > 0) {
            this.mPopupWindow.setAnimationStyle(animaStyleRes);
        }
    }

    public void showPopupWindow() {
        try {
            this.tryToShowPopup(0, null);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"show error");
            e.printStackTrace();
        }
    }

    public void showPopupWindow(int res) {
        try {
            this.tryToShowPopup(res, null);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"show error");
            e.printStackTrace();
        }
    }

    public void showPopupWindow(View v) {
        try {
            this.tryToShowPopup(0, v);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"show error");
            e.printStackTrace();
        }
    }

    private void tryToShowPopup(int res, View v) throws Exception {
        int[] offset;
        if (res == 0 && v != null) {
            offset = this.calcuateOffset(v);
            if (this.showAtDown) {
                this.mPopupWindow.showAsDropDown(v, offset[0], offset[1]);
            } else {
                this.mPopupWindow.showAtLocation(v, this.popupGravity, offset[0], offset[1]);
            }
        }
        if (res != 0 && v == null) {
            View anchorView = this.mContext.findViewById(res);
            offset = this.calcuateOffset(anchorView);
            if (this.showAtDown) {
                this.mPopupWindow.showAsDropDown(anchorView, offset[0], offset[1]);
            } else {
                this.mPopupWindow.showAtLocation(anchorView, this.popupGravity, offset[0], offset[1]);
            }
        }
        if (res == 0 && v == null) {
            this.mPopupWindow.showAtLocation(this.mContext.findViewById(0x1020002), this.popupGravity, this.offsetX, this.offsetY);
        }
        if (this.mShowAnimation != null && this.mAnimaView != null) {
            this.mAnimaView.clearAnimation();
            this.mAnimaView.startAnimation(this.mShowAnimation);
        }
        if (this.mShowAnimation == null && this.mShowAnimator != null && this.mAnimaView != null) {
            this.mShowAnimator.start();
        }
        if (this.autoShowInputMethod && this.getInputView() != null) {
            this.getInputView().requestFocus();
            InputMethodUtils.showInputMethod((View)this.getInputView(), 150L);
        }
    }

    private int[] calcuateOffset(View v) {
        int[] result = new int[]{this.offsetX, this.offsetY};
        v.getLocationOnScreen(this.mAnchorViewLocation);
        if (this.relativeToAnchorView) {
            switch (this.popupRelativePivot) {
                case 1: 
                case 3: {
                    result[0] = this.mAnchorViewLocation[0] - result[0];
                    result[1] = result[1] + this.mAnchorViewLocation[1];
                    break;
                }
                case 5: 
                case 7: {
                    result[0] = this.mAnchorViewLocation[0] - result[0] - this.popupViewWidth;
                    result[1] = result[1] + this.mAnchorViewLocation[1];
                    break;
                }
                case 16: 
                case 17: {
                    result[0] = this.mAnchorViewLocation[0] - result[0];
                    result[1] = result[1] + (this.mAnchorViewLocation[1] + this.popupViewHeight);
                    break;
                }
                case 21: {
                    result[0] = this.mAnchorViewLocation[0] - result[0] - this.popupViewWidth;
                    result[1] = result[1] + (this.mAnchorViewLocation[1] + this.popupViewHeight);
                    break;
                }
                case 80: 
                case 83: {
                    result[0] = this.mAnchorViewLocation[0] - result[0] - this.popupViewWidth / 2;
                    result[1] = result[1] + this.mAnchorViewLocation[1];
                    break;
                }
                case 304: 
                case 305: {
                    result[0] = this.mAnchorViewLocation[0] - result[0];
                    result[1] = result[1] + (this.mAnchorViewLocation[1] - this.popupViewHeight / 2);
                    break;
                }
                case 309: {
                    result[0] = this.mAnchorViewLocation[0] - result[0] - this.popupViewWidth;
                    result[1] = result[1] + (this.mAnchorViewLocation[1] - this.popupViewHeight / 2);
                    break;
                }
                case 368: {
                    result[0] = this.mAnchorViewLocation[0] - result[0] - this.popupViewWidth / 2;
                    result[1] = result[1] + (this.mAnchorViewLocation[1] - this.popupViewHeight / 2);
                    break;
                }
                default: {
                    Log.i((String)TAG, (String)"calcuate default");
                }
            }
        }
        if (this.isAutoLocatePopup) {
            boolean onTop;
            boolean bl = onTop = this.getScreenHeight() - result[1] < this.popupViewHeight;
            if (onTop) {
                result[1] = result[1] - this.popupViewHeight - this.offsetY;
                this.showOnTop(this.mPopupView);
            } else {
                this.showOnDown(this.mPopupView);
            }
        }
        return result;
    }

    public void setAdjustInputMethod(boolean needAdjust) {
        if (needAdjust) {
            this.mPopupWindow.setSoftInputMode(16);
        } else {
            this.mPopupWindow.setSoftInputMode(48);
        }
    }

    public void setAutoShowInputMethod(boolean autoShow) {
        this.autoShowInputMethod = autoShow;
        if (autoShow) {
            this.setAdjustInputMethod(true);
        } else {
            this.setAdjustInputMethod(false);
        }
    }

    public void setBackPressEnable(boolean backPressEnable) {
        if (backPressEnable) {
            this.mPopupWindow.setBackgroundDrawable((Drawable)new ColorDrawable());
        } else {
            this.mPopupWindow.setBackgroundDrawable(null);
        }
    }

    public View createPopupById(int resId) {
        if (resId != 0) {
            return LayoutInflater.from((Context)this.mContext).inflate(resId, null);
        }
        return null;
    }

    protected View findViewById(int id2) {
        if (this.mPopupView != null && id2 != 0) {
            return this.mPopupView.findViewById(id2);
        }
        return null;
    }

    public void setPopupWindowFullScreen(boolean needFullScreen) {
        this.fitPopupWindowOverStatusBar(needFullScreen);
    }

    protected void setViewClickListener(View.OnClickListener listener, View ... views) {
        for (View view : views) {
            if (view == null || listener == null) continue;
            view.setOnClickListener(listener);
        }
    }

    private void fitPopupWindowOverStatusBar(boolean needFullScreen) {
        if (Build.VERSION.SDK_INT >= 21) {
            try {
                Field mLayoutInScreen = PopupWindow.class.getDeclaredField("mLayoutInScreen");
                mLayoutInScreen.setAccessible(true);
                mLayoutInScreen.set(this.mPopupWindow, needFullScreen);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean isShowing() {
        return this.mPopupWindow.isShowing();
    }

    public OnDismissListener getOnDismissListener() {
        return this.mOnDismissListener;
    }

    public void setOnDismissListener(OnDismissListener onDismissListener) {
        this.mOnDismissListener = onDismissListener;
    }

    public void setShowAnimation(Animation showAnimation) {
        if (this.mShowAnimation != null && this.mAnimaView != null) {
            this.mAnimaView.clearAnimation();
            this.mShowAnimation.cancel();
        }
        if (showAnimation != null && showAnimation != this.mShowAnimation) {
            this.mShowAnimation = showAnimation;
        }
    }

    public Animation getShowAnimation() {
        return this.mShowAnimation;
    }

    public void setShowAnimator(Animator showAnimator) {
        if (this.mShowAnimator != null) {
            this.mShowAnimator.cancel();
        }
        if (showAnimator != null && showAnimator != this.mShowAnimator) {
            this.mShowAnimator = showAnimator;
        }
    }

    public Animator getShowAnimator() {
        return this.mShowAnimator;
    }

    public void setExitAnimation(Animation exitAnimation) {
        if (this.mExitAnimation != null && this.mAnimaView != null) {
            this.mAnimaView.clearAnimation();
            this.mExitAnimation.cancel();
        }
        if (exitAnimation != null && exitAnimation != this.mExitAnimation) {
            this.mExitAnimation = exitAnimation;
        }
    }

    public Animation getExitAnimation() {
        return this.mExitAnimation;
    }

    public void setExitAnimator(Animator exitAnimator) {
        if (this.mExitAnimator != null) {
            this.mExitAnimator.cancel();
        }
        if (exitAnimator != null && exitAnimator != this.mExitAnimator) {
            this.mExitAnimator = exitAnimator;
        }
    }

    public Animator getExitAnimator() {
        return this.mExitAnimator;
    }

    public Context getContext() {
        return this.mContext;
    }

    public View getPopupWindowView() {
        return this.mPopupView;
    }

    public PopupWindow getPopupWindow() {
        return this.mPopupWindow;
    }

    public int getOffsetX() {
        return this.offsetX;
    }

    public void setOffsetX(int offsetX) {
        this.offsetX = offsetX;
    }

    public int getOffsetY() {
        return this.offsetY;
    }

    public void setOffsetY(int offsetY) {
        this.offsetY = offsetY;
    }

    public int getPopupGravity() {
        return this.popupGravity;
    }

    public void setPopupGravity(int popupGravity) {
        if (this.relativeToAnchorView) {
            popupGravity = 0;
        }
        this.popupGravity = popupGravity;
    }

    public boolean isRelativeToAnchorView() {
        return this.relativeToAnchorView;
    }

    public void setRelativeToAnchorView(boolean relativeToAnchorView) {
        if (relativeToAnchorView) {
            this.popupGravity = 0;
        }
        this.relativeToAnchorView = relativeToAnchorView;
    }

    public boolean isAutoLocatePopup() {
        return this.isAutoLocatePopup;
    }

    public void setAutoLocatePopup(boolean autoLocatePopup) {
        if (autoLocatePopup) {
            this.popupGravity = 51;
        }
        this.isAutoLocatePopup = autoLocatePopup;
    }

    public int getPopupViewWidth() {
        return this.popupViewWidth;
    }

    public int getPopupViewHeight() {
        return this.popupViewHeight;
    }

    public boolean isShowAtDown() {
        return this.showAtDown;
    }

    public void setShowAtDown(boolean showAtDown) {
        this.showAtDown = showAtDown;
    }

    public void setDismissWhenTouchOuside(boolean dismissWhenTouchOuside) {
        this.dismissWhenTouchOuside = dismissWhenTouchOuside;
        if (dismissWhenTouchOuside) {
            this.mPopupWindow.setBackgroundDrawable((Drawable)new ColorDrawable());
            this.mPopupWindow.setFocusable(true);
            this.mPopupWindow.setOutsideTouchable(true);
        } else {
            this.getPopupWindow().setFocusable(false);
            this.getPopupWindow().setBackgroundDrawable(null);
            this.getPopupWindow().setOutsideTouchable(false);
        }
    }

    public void dismiss() {
        try {
            if (this.mExitAnimation != null && this.mAnimaView != null) {
                if (!this.isExitAnimaPlaying) {
                    this.mExitAnimation.setAnimationListener(this.mAnimationListener);
                    this.mAnimaView.clearAnimation();
                    this.mAnimaView.startAnimation(this.mExitAnimation);
                    this.isExitAnimaPlaying = true;
                }
            } else if (this.mExitAnimator != null) {
                if (!this.isExitAnimaPlaying) {
                    this.mExitAnimator.removeListener(this.mAnimatorListener);
                    this.mExitAnimator.addListener(this.mAnimatorListener);
                    this.mExitAnimator.start();
                    this.isExitAnimaPlaying = true;
                }
            } else {
                this.mPopupWindow.dismiss();
            }
        }
        catch (Exception e) {
            Log.d((String)TAG, (String)"dismiss error");
        }
    }

    public void dismissWithOutAnima() {
        try {
            if (this.mExitAnimation != null && this.mAnimaView != null) {
                this.mAnimaView.clearAnimation();
            }
            if (this.mExitAnimator != null) {
                this.mExitAnimator.removeAllListeners();
            }
            this.mPopupWindow.dismiss();
        }
        catch (Exception e) {
            Log.d((String)TAG, (String)"dismiss error");
        }
    }

    public void setRelativePivot(int pivot) {
        this.relativeToAnchorView = true;
        this.popupRelativePivot = pivot;
    }

    protected Animation getTranslateAnimation(int start, int end, int durationMillis) {
        TranslateAnimation translateAnimation = new TranslateAnimation(0.0f, 0.0f, (float)start, (float)end);
        translateAnimation.setDuration((long)durationMillis);
        translateAnimation.setFillEnabled(true);
        translateAnimation.setFillAfter(true);
        return translateAnimation;
    }

    protected Animation getScaleAnimation(float fromX, float toX, float fromY, float toY, int pivotXType, float pivotXValue, int pivotYType, float pivotYValue) {
        ScaleAnimation scaleAnimation = new ScaleAnimation(fromX, toX, fromY, toY, pivotXType, pivotXValue, pivotYType, pivotYValue);
        scaleAnimation.setDuration(300L);
        scaleAnimation.setFillEnabled(true);
        scaleAnimation.setFillAfter(true);
        return scaleAnimation;
    }

    protected Animation getDefaultScaleAnimation() {
        ScaleAnimation scaleAnimation = new ScaleAnimation(0.0f, 1.0f, 0.0f, 1.0f, 1, 0.5f, 1, 0.5f);
        scaleAnimation.setDuration(300L);
        scaleAnimation.setInterpolator((Interpolator)new AccelerateInterpolator());
        scaleAnimation.setFillEnabled(true);
        scaleAnimation.setFillAfter(true);
        return scaleAnimation;
    }

    protected Animation getDefaultAlphaAnimation() {
        AlphaAnimation alphaAnimation = new AlphaAnimation(0.0f, 1.0f);
        alphaAnimation.setDuration(300L);
        alphaAnimation.setInterpolator((Interpolator)new AccelerateInterpolator());
        alphaAnimation.setFillEnabled(true);
        alphaAnimation.setFillAfter(true);
        return alphaAnimation;
    }

    protected AnimatorSet getDefaultSlideFromBottomAnimationSet() {
        AnimatorSet set = null;
        set = new AnimatorSet();
        if (this.mAnimaView != null) {
            set.playTogether(new Animator[]{ObjectAnimator.ofFloat((Object)this.mAnimaView, (String)"translationY", (float[])new float[]{250.0f, 0.0f}).setDuration(400L), ObjectAnimator.ofFloat((Object)this.mAnimaView, (String)"alpha", (float[])new float[]{0.4f, 1.0f}).setDuration(375L)});
        }
        return set;
    }

    public int getScreenHeight() {
        return this.getContext().getResources().getDisplayMetrics().heightPixels;
    }

    public int getScreenWidth() {
        return this.getContext().getResources().getDisplayMetrics().widthPixels;
    }

    protected void showOnTop(View mPopupView) {
    }

    protected void showOnDown(View mPopupView) {
    }

    public void onDismiss() {
        if (this.mOnDismissListener != null) {
            this.mOnDismissListener.onDismiss();
        }
    }

    public static interface OnDismissListener {
        public void onDismiss();
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface RelativePivot {
        public static final int LEFT = 1;
        public static final int TOP = 3;
        public static final int RIGHT = 5;
        public static final int BOTTOM = 16;
        public static final int CENTER_X = 80;
        public static final int CENTER_Y = 304;
    }
}

