/*
 * Decompiled with CFR 0.152.
 */
package razerdp.basepopup;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.app.Activity;
import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.Interpolator;
import android.view.animation.ScaleAnimation;
import android.view.animation.TranslateAnimation;
import android.widget.PopupWindow;
import java.lang.reflect.Field;
import razerdp.basepopup.BasePopup;
import razerdp.basepopup.InputMethodUtils;
import razerdp.library.R;

public abstract class BasePopupWindow
implements BasePopup {
    private static final String TAG = "BasePopupWindow";
    protected PopupWindow mPopupWindow;
    protected View mPopupView;
    protected View mAnimaView;
    protected View mDismissView;
    protected Activity mContext;
    private boolean autoShowInputMethod = false;
    private OnDismissListener mOnDismissListener;
    protected Animation curExitAnima;
    protected Animator curExitAnimator;
    protected Animation curAnima;
    protected Animator curAnimator;
    private boolean isExitAnimaPlaying = false;
    private boolean needPopupFadeAnima = true;
    private Animator.AnimatorListener mAnimatorListener = new Animator.AnimatorListener(){

        public void onAnimationStart(Animator animation) {
        }

        public void onAnimationEnd(Animator animation) {
            BasePopupWindow.this.mPopupWindow.dismiss();
            BasePopupWindow.this.isExitAnimaPlaying = false;
        }

        public void onAnimationCancel(Animator animation) {
            BasePopupWindow.this.isExitAnimaPlaying = false;
        }

        public void onAnimationRepeat(Animator animation) {
        }
    };
    private Animation.AnimationListener mAnimationListener = new Animation.AnimationListener(){

        public void onAnimationStart(Animation animation) {
        }

        public void onAnimationEnd(Animation animation) {
            BasePopupWindow.this.mPopupWindow.dismiss();
            BasePopupWindow.this.isExitAnimaPlaying = false;
        }

        public void onAnimationRepeat(Animation animation) {
        }
    };

    public BasePopupWindow(Activity context) {
        this.initView(context, -1, -1);
    }

    public BasePopupWindow(Activity context, int w, int h) {
        this.initView(context, w, h);
    }

    private void initView(Activity context, int w, int h) {
        this.mContext = context;
        this.mPopupView = this.getPopupView();
        this.mPopupView.setFocusableInTouchMode(true);
        this.mPopupWindow = new PopupWindow(this.mPopupView, w, h);
        this.mPopupWindow.setBackgroundDrawable((Drawable)new ColorDrawable());
        this.mPopupWindow.setFocusable(true);
        this.mPopupWindow.setOutsideTouchable(true);
        this.mPopupWindow.setAnimationStyle(R.style.PopupAnimaFade);
        this.mAnimaView = this.getAnimaView();
        this.mDismissView = this.getClickToDismissView();
        if (this.mDismissView != null) {
            this.mDismissView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    BasePopupWindow.this.dismiss();
                }
            });
            if (this.mAnimaView != null) {
                this.mAnimaView.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                    }
                });
            }
        }
        this.curAnima = this.getShowAnimation();
        this.curAnimator = this.getShowAnimator();
        this.curExitAnima = this.getExitAnimation();
        this.curExitAnimator = this.getExitAnimator();
    }

    protected abstract Animation getShowAnimation();

    protected abstract View getClickToDismissView();

    public Animator getShowAnimator() {
        return null;
    }

    public View getInputView() {
        return null;
    }

    public Animation getExitAnimation() {
        return null;
    }

    public Animator getExitAnimator() {
        return null;
    }

    public void setNeedPopupFade(boolean needPopupFadeAnima) {
        this.needPopupFadeAnima = needPopupFadeAnima;
        this.mPopupWindow.setAnimationStyle(needPopupFadeAnima ? R.style.PopupAnimaFade : 0);
    }

    public boolean getNeedPopupFade() {
        return this.needPopupFadeAnima;
    }

    public void setPopupAnimaStyle(int animaStyleRes) {
        if (animaStyleRes > 0) {
            this.mPopupWindow.setAnimationStyle(animaStyleRes);
        }
    }

    public void showPopupWindow() {
        try {
            this.tryToShowPopup(0, null);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"show error");
            e.printStackTrace();
        }
    }

    public void showPopupWindow(int res) {
        try {
            this.tryToShowPopup(res, null);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"show error");
            e.printStackTrace();
        }
    }

    public void showPopupWindow(View v) {
        try {
            this.tryToShowPopup(0, v);
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"show error");
            e.printStackTrace();
        }
    }

    private void tryToShowPopup(int res, View v) throws Exception {
        if (res == 0 && v != null) {
            this.mPopupWindow.showAtLocation(v, 17, 0, 0);
        }
        if (res != 0 && v == null) {
            this.mPopupWindow.showAtLocation(this.mContext.findViewById(res), 17, 0, 0);
        }
        if (res == 0 && v == null) {
            this.mPopupWindow.showAtLocation(this.mContext.findViewById(0x1020002), 17, 0, 0);
        }
        if (this.curAnima != null && this.mAnimaView != null) {
            this.mAnimaView.clearAnimation();
            this.mAnimaView.startAnimation(this.curAnima);
        }
        if (this.curAnima == null && this.curAnimator != null && this.mAnimaView != null) {
            this.curAnimator.start();
        }
        if (this.autoShowInputMethod && this.getInputView() != null) {
            this.getInputView().requestFocus();
            InputMethodUtils.showInputMethod(this.getInputView(), 150L);
        }
    }

    public void setAdjustInputMethod(boolean needAdjust) {
        if (needAdjust) {
            this.mPopupWindow.setSoftInputMode(16);
        } else {
            this.mPopupWindow.setSoftInputMode(48);
        }
    }

    public void setAutoShowInputMethod(boolean autoShow) {
        this.autoShowInputMethod = autoShow;
        if (autoShow) {
            this.setAdjustInputMethod(true);
        } else {
            this.setAdjustInputMethod(false);
        }
    }

    public void setBackPressEnable(boolean backPressEnable) {
        if (backPressEnable) {
            this.mPopupWindow.setBackgroundDrawable((Drawable)new ColorDrawable());
        } else {
            this.mPopupWindow.setBackgroundDrawable(null);
        }
    }

    public View getPopupViewById(int resId) {
        if (resId != 0) {
            return LayoutInflater.from((Context)this.mContext).inflate(resId, null);
        }
        return null;
    }

    protected View findViewById(int id2) {
        if (this.mPopupView != null && id2 != 0) {
            return this.mPopupView.findViewById(id2);
        }
        return null;
    }

    public void setPopupWindowFullScreen(boolean needFullScreen) {
        this.fitPopupWindowOverStatusBar(needFullScreen);
    }

    protected void setViewClickListener(View.OnClickListener listener, View ... views) {
        for (View view : views) {
            if (view == null || listener == null) continue;
            view.setOnClickListener(listener);
        }
    }

    private void fitPopupWindowOverStatusBar(boolean needFullScreen) {
        if (Build.VERSION.SDK_INT > 21) {
            try {
                Field mLayoutInScreen = PopupWindow.class.getDeclaredField("mLayoutInScreen");
                mLayoutInScreen.setAccessible(true);
                mLayoutInScreen.set(this.mPopupWindow, needFullScreen);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    public boolean isShowing() {
        return this.mPopupWindow.isShowing();
    }

    public OnDismissListener getOnDismissListener() {
        return this.mOnDismissListener;
    }

    public void setOnDismissListener(OnDismissListener onDismissListener) {
        this.mOnDismissListener = onDismissListener;
        if (this.mOnDismissListener != null) {
            this.mPopupWindow.setOnDismissListener(new PopupWindow.OnDismissListener(){

                public void onDismiss() {
                    BasePopupWindow.this.mOnDismissListener.onDismiss();
                }
            });
        }
    }

    public void dismiss() {
        try {
            if (this.curExitAnima != null && this.mAnimaView != null) {
                if (!this.isExitAnimaPlaying) {
                    this.curExitAnima.setAnimationListener(this.mAnimationListener);
                    this.mAnimaView.clearAnimation();
                    this.mAnimaView.startAnimation(this.curExitAnima);
                    this.isExitAnimaPlaying = true;
                }
            } else if (this.curExitAnimator != null) {
                if (!this.isExitAnimaPlaying) {
                    this.curExitAnimator.removeListener(this.mAnimatorListener);
                    this.curExitAnimator.addListener(this.mAnimatorListener);
                    this.curExitAnimator.start();
                    this.isExitAnimaPlaying = true;
                }
            } else {
                this.mPopupWindow.dismiss();
            }
        }
        catch (Exception e) {
            Log.d((String)TAG, (String)"dismiss error");
        }
    }

    public void dismissWithOutAnima() {
        try {
            if (this.curExitAnima != null && this.mAnimaView != null) {
                this.mAnimaView.clearAnimation();
            }
            if (this.curExitAnimator != null) {
                this.curExitAnimator.removeAllListeners();
            }
            this.mPopupWindow.dismiss();
        }
        catch (Exception e) {
            Log.d((String)TAG, (String)"dismiss error");
        }
    }

    protected Animation getTranslateAnimation(int start, int end, int durationMillis) {
        TranslateAnimation translateAnimation = new TranslateAnimation(0.0f, 0.0f, (float)start, (float)end);
        translateAnimation.setDuration((long)durationMillis);
        translateAnimation.setFillEnabled(true);
        translateAnimation.setFillAfter(true);
        return translateAnimation;
    }

    protected Animation getScaleAnimation(float fromX, float toX, float fromY, float toY, int pivotXType, float pivotXValue, int pivotYType, float pivotYValue) {
        ScaleAnimation scaleAnimation = new ScaleAnimation(fromX, toX, fromY, toY, pivotXType, pivotXValue, pivotYType, pivotYValue);
        scaleAnimation.setDuration(300L);
        scaleAnimation.setFillEnabled(true);
        scaleAnimation.setFillAfter(true);
        return scaleAnimation;
    }

    protected Animation getDefaultScaleAnimation() {
        ScaleAnimation scaleAnimation = new ScaleAnimation(0.0f, 1.0f, 0.0f, 1.0f, 1, 0.5f, 1, 0.5f);
        scaleAnimation.setDuration(300L);
        scaleAnimation.setInterpolator((Interpolator)new AccelerateInterpolator());
        scaleAnimation.setFillEnabled(true);
        scaleAnimation.setFillAfter(true);
        return scaleAnimation;
    }

    protected Animation getDefaultAlphaAnimation() {
        AlphaAnimation alphaAnimation = new AlphaAnimation(0.0f, 1.0f);
        alphaAnimation.setDuration(300L);
        alphaAnimation.setInterpolator((Interpolator)new AccelerateInterpolator());
        alphaAnimation.setFillEnabled(true);
        alphaAnimation.setFillAfter(true);
        return alphaAnimation;
    }

    protected AnimatorSet getDefaultSlideFromBottomAnimationSet() {
        AnimatorSet set = null;
        set = new AnimatorSet();
        if (this.mAnimaView != null) {
            set.playTogether(new Animator[]{ObjectAnimator.ofFloat((Object)this.mAnimaView, (String)"translationY", (float[])new float[]{250.0f, 0.0f}).setDuration(400L), ObjectAnimator.ofFloat((Object)this.mAnimaView, (String)"alpha", (float[])new float[]{0.4f, 1.0f}).setDuration(375L)});
        }
        return set;
    }

    public static interface OnDismissListener {
        public void onDismiss();
    }
}

