/*
 * Decompiled with CFR 0.152.
 */
package razerdp.blur.thread;

import android.os.AsyncTask;
import android.os.Build;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ThreadPoolManager {
    private static ExecutorService threadPool = null;

    public static void execute(Runnable runnable) {
        try {
            threadPool.execute(runnable);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static <Params, Progress, Result> void executeOnExecutor(AsyncTask<Params, Progress, Result> task, Params ... params) {
        if (Build.VERSION.SDK_INT >= 11) {
            task.executeOnExecutor((Executor)threadPool, (Object[])params);
        } else {
            task.execute((Object[])params);
        }
    }

    static {
        int processorNum = Runtime.getRuntime().availableProcessors();
        threadPool = new ThreadPoolExecutor(processorNum, processorNum * 2 + 1, 20L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
    }
}

