/*
 * Decompiled with CFR 0.152.
 */
package razerdp.util;

import android.app.Activity;
import android.content.Context;
import android.graphics.Rect;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.inputmethod.InputMethodManager;
import razerdp.basepopup.BasePopupSDK;
import razerdp.util.PopupUiUtils;
import razerdp.util.PopupUtils;

public class KeyboardUtils {
    public static void open(View view) {
        if (view == null) {
            return;
        }
        view.requestFocus();
        InputMethodManager imm = (InputMethodManager)view.getContext().getSystemService("input_method");
        if (imm != null) {
            imm.showSoftInput(view, 1);
        }
    }

    public static void open(Context context) {
        if (context == null) {
            return;
        }
        InputMethodManager imm = (InputMethodManager)context.getSystemService("input_method");
        imm.toggleSoftInput(0, 2);
    }

    public static void open(final View view, long delayMillis) {
        if (view == null) {
            return;
        }
        view.postDelayed(new Runnable(){

            @Override
            public void run() {
                KeyboardUtils.open(view);
            }
        }, delayMillis);
    }

    public static void close(Activity activity) {
        if (activity == null) {
            return;
        }
        View view = activity.getWindow().getDecorView().getRootView();
        try {
            InputMethodManager imm = (InputMethodManager)view.getContext().getSystemService("input_method");
            if (imm != null) {
                imm.hideSoftInputFromWindow(view.getWindowToken(), 2);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void close(View view) {
        try {
            InputMethodManager imm = (InputMethodManager)view.getContext().getSystemService("input_method");
            if (imm != null) {
                imm.hideSoftInputFromWindow(view.getWindowToken(), 0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean isOpen() {
        try {
            InputMethodManager imm = (InputMethodManager)BasePopupSDK.getApplication().getSystemService("input_method");
            if (imm != null) {
                return imm.isActive();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public static boolean isOpen(View view) {
        try {
            InputMethodManager imm = (InputMethodManager)BasePopupSDK.getApplication().getSystemService("input_method");
            if (imm != null) {
                return imm.isActive(view);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public static ViewTreeObserver.OnGlobalLayoutListener observerKeyboardWithView(final View target) {
        if (target == null) {
            return null;
        }
        Activity act = PopupUtils.getActivity(target.getContext());
        if (act == null) {
            return null;
        }
        return KeyboardUtils.observerKeyboardChange(act, new OnKeyboardChangeListener(){
            private int[] location = new int[]{0, 0};

            @Override
            public void onKeyboardChange(Rect keyboardBounds, boolean isVisible) {
                if (isVisible) {
                    target.getLocationOnScreen(this.location);
                    int offset = keyboardBounds.top - (this.location[1] + target.getHeight());
                    target.setTranslationY(target.getTranslationY() + (float)offset);
                } else {
                    target.animate().translationY(0.0f).setDuration(300L).setStartDelay(100L).start();
                }
            }
        });
    }

    public static ViewTreeObserver.OnGlobalLayoutListener observerKeyboardChange(Activity act, final OnKeyboardChangeListener onKeyboardChangeListener) {
        if (act == null || onKeyboardChangeListener == null) {
            return null;
        }
        final View decor = act.getWindow().getDecorView();
        ViewTreeObserver.OnGlobalLayoutListener layoutListener = new ViewTreeObserver.OnGlobalLayoutListener(){
            Rect rect = new Rect();
            Rect keyboardRect = new Rect();
            boolean lastVisible;
            int lastHeight;

            public void onGlobalLayout() {
                boolean isVisible;
                View content = decor.findViewById(0x1020002);
                decor.getWindowVisibleDisplayFrame(this.rect);
                int screenHeight = content == null ? decor.getHeight() : content.getHeight();
                this.keyboardRect.set(this.rect.left, this.rect.bottom, this.rect.right, screenHeight);
                boolean bl = isVisible = this.keyboardRect.height() > screenHeight >> 2 && KeyboardUtils.isOpen();
                if (isVisible == this.lastVisible && this.keyboardRect.height() == this.lastHeight) {
                    return;
                }
                this.lastVisible = isVisible;
                this.lastHeight = this.keyboardRect.height();
                onKeyboardChangeListener.onKeyboardChange(this.keyboardRect, isVisible);
            }
        };
        PopupUiUtils.safeAddGlobalLayoutListener(decor, layoutListener);
        return layoutListener;
    }

    public static interface OnKeyboardChangeListener {
        public void onKeyboardChange(Rect var1, boolean var2);
    }
}

