/*
 * Decompiled with CFR 0.152.
 */
package razerdp.basepopup;

import android.app.Dialog;
import android.content.Context;
import android.util.Pair;
import android.view.View;
import androidx.fragment.app.Fragment;
import razerdp.basepopup.BasePopupWindow;

public abstract class BaseLazyPopupWindow
extends BasePopupWindow {
    private boolean initImmediately = false;
    private Pair<Integer, Integer> sizeCached;

    public BaseLazyPopupWindow(Context context) {
        super(context);
    }

    public BaseLazyPopupWindow(Context context, int width, int height) {
        super(context, width, height);
    }

    public BaseLazyPopupWindow(Fragment fragment) {
        super(fragment);
    }

    public BaseLazyPopupWindow(Fragment fragment, int width, int height) {
        super(fragment, width, height);
    }

    public BaseLazyPopupWindow(Dialog dialog) {
        super(dialog);
    }

    public BaseLazyPopupWindow(Dialog dialog, int width, int height) {
        super(dialog, width, height);
    }

    @Override
    void onCreateConstructor(Object ownerAnchorParent, int width, int height) {
        super.onCreateConstructor(ownerAnchorParent, width, height);
        this.sizeCached = Pair.create((Object)width, (Object)height);
    }

    public final void initImmediately() {
        this.initImmediately = true;
        if (this.sizeCached != null) {
            this.initView((Integer)this.sizeCached.first, (Integer)this.sizeCached.second);
            this.sizeCached = null;
        } else {
            this.initView(0, 0);
        }
    }

    @Override
    void initView(int width, int height) {
        if (!this.initImmediately) {
            return;
        }
        super.initView(width, height);
    }

    @Override
    void tryToShowPopup(View v, boolean positionMode) {
        if (!this.initImmediately) {
            this.initImmediately();
        }
        super.tryToShowPopup(v, positionMode);
    }
}

