/*
 * Decompiled with CFR 0.152.
 */
package razerdp.basepopup;

import android.content.Context;
import android.os.Message;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import razerdp.basepopup.BasePopupEvent;
import razerdp.basepopup.BasePopupHelper;
import razerdp.basepopup.ClearMemoryObject;
import razerdp.basepopup.PopupBackgroundView;
import razerdp.blur.BlurImageView;
import razerdp.util.PopupUiUtils;
import razerdp.util.PopupUtils;

class PopupMaskLayout
extends FrameLayout
implements BasePopupEvent.EventObserver,
ClearMemoryObject {
    BlurImageView mBlurImageView;
    private BackgroundViewHolder mBackgroundViewHolder;
    private BasePopupHelper mPopupHelper;
    private int[] location = null;

    private PopupMaskLayout(Context context) {
        super(context);
    }

    private PopupMaskLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    private PopupMaskLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    PopupMaskLayout(Context context, BasePopupHelper helper) {
        this(context);
        this.init(context, helper);
        this.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (PopupMaskLayout.this.mPopupHelper.isOutSideDismiss()) {
                    PopupMaskLayout.this.mPopupHelper.onOutSideTouch();
                }
            }
        });
    }

    private void init(Context context, BasePopupHelper mHelper) {
        this.mPopupHelper = mHelper;
        this.location = null;
        this.setLayoutAnimation(null);
        if (mHelper == null) {
            this.setBackgroundColor(0);
            return;
        }
        mHelper.observerEvent(this, this);
        if (mHelper.isAllowToBlur()) {
            this.mBlurImageView = new BlurImageView(context);
            this.addViewInLayout((View)this.mBlurImageView, -1, (ViewGroup.LayoutParams)this.generateDefaultLayoutParams());
        }
        if (mHelper.getBackgroundView() != null) {
            this.mBackgroundViewHolder = new BackgroundViewHolder(mHelper.getBackgroundView(), mHelper);
        } else if (!PopupUtils.isBackgroundInvalidated(mHelper.getPopupBackground())) {
            this.mBackgroundViewHolder = new BackgroundViewHolder(PopupBackgroundView.creaete(context, mHelper), mHelper);
        }
        if (this.mBackgroundViewHolder != null) {
            this.mBackgroundViewHolder.addInLayout();
        }
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        if (this.location == null && this.mPopupHelper != null && this.mPopupHelper.isAllowToBlur() && this.mBlurImageView != null) {
            this.location = new int[2];
            this.getLocationOnScreen(this.location);
            this.mBlurImageView.setCutoutX(this.location[0]);
            this.mBlurImageView.setCutoutY(this.location[1]);
            this.mBlurImageView.applyBlurOption(this.mPopupHelper.getBlurOption());
        }
        super.onLayout(changed, left, top, right, bottom);
    }

    public void handleAlignBackground(int gravity, int contentLeft, int contentTop, int contentRight, int contentBottom) {
        int left = this.getLeft();
        int top = this.getTop();
        int right = this.getRight();
        int bottom = this.getBottom();
        switch (gravity & 7) {
            case 3: 
            case 0x800003: {
                left = contentLeft;
                break;
            }
            case 5: 
            case 0x800005: {
                right = contentRight;
                break;
            }
        }
        switch (gravity & 0x70) {
            case 48: {
                top = contentTop;
                break;
            }
            case 80: {
                bottom = contentBottom;
                break;
            }
        }
        if (this.mBackgroundViewHolder != null) {
            this.mBackgroundViewHolder.handleAlignBackground(left, top, right, bottom);
        }
    }

    protected FrameLayout.LayoutParams generateDefaultLayoutParams() {
        return new FrameLayout.LayoutParams(-1, -1);
    }

    public void update() {
        if (this.mBlurImageView != null) {
            this.mBlurImageView.update();
        }
        if (this.mBackgroundViewHolder != null) {
            this.mBackgroundViewHolder.update();
        }
    }

    public void handleStart(long duration) {
        if (this.mBlurImageView != null) {
            this.mBlurImageView.start(duration);
        }
    }

    public void handleDismiss(long duration) {
        if (this.mBlurImageView != null) {
            this.mBlurImageView.dismiss(duration);
        }
        if (this.mBackgroundViewHolder != null) {
            this.mBackgroundViewHolder.dismiss();
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.removeAllViews();
        if (this.mBackgroundViewHolder != null) {
            this.mBackgroundViewHolder.destroy();
            this.mBackgroundViewHolder = null;
        }
        if (this.mBlurImageView != null) {
            this.mBlurImageView.destroy();
            this.mBlurImageView = null;
        }
        if (this.mPopupHelper != null) {
            this.mPopupHelper.removeEventObserver(this);
            this.mPopupHelper = null;
        }
    }

    @Override
    public void onEvent(Message msg) {
        switch (msg.what) {
            case 1: {
                this.handleShow();
                break;
            }
            case 2: {
                this.handleDismiss(msg.arg1 == 1 ? -2L : 0L);
            }
        }
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        if (this.mPopupHelper != null && this.mPopupHelper.isOutSideTouchable()) {
            MotionEvent nEv = MotionEvent.obtain((MotionEvent)ev);
            if (!this.mPopupHelper.isOverlayStatusbar()) {
                nEv.offsetLocation(0.0f, (float)PopupUiUtils.getStatusBarHeight());
            }
            this.mPopupHelper.dispatchOutSideEvent(nEv);
            nEv.recycle();
        }
        return super.dispatchTouchEvent(ev);
    }

    @Override
    public void clear(boolean destroy) {
        if (this.mBlurImageView != null) {
            this.mBlurImageView.destroy();
        }
        if (this.mBackgroundViewHolder != null) {
            this.mBackgroundViewHolder.clear(destroy);
        }
        if (destroy) {
            this.mPopupHelper = null;
            this.mBackgroundViewHolder = null;
            this.mBlurImageView = null;
        }
    }

    public void handleShow() {
        if (this.mBackgroundViewHolder != null) {
            this.mBackgroundViewHolder.handleShow();
        }
    }

    final class BackgroundViewHolder
    implements ClearMemoryObject {
        View mBackgroundView;
        BasePopupHelper mHelper;

        BackgroundViewHolder(View backgroundView, BasePopupHelper helper) {
            this.mBackgroundView = backgroundView;
            this.mHelper = helper;
        }

        void addInLayout() {
            if (this.mBackgroundView != null) {
                PopupMaskLayout.this.addViewInLayout(this.mBackgroundView, -1, (ViewGroup.LayoutParams)PopupMaskLayout.this.generateDefaultLayoutParams());
            }
        }

        void handleAlignBackground(int left, int top, int right, int bottom) {
            if (this.mBackgroundView == null) {
                return;
            }
            this.mBackgroundView.layout(left, top, right, bottom);
        }

        void update() {
            if (this.mBackgroundView instanceof PopupBackgroundView) {
                ((PopupBackgroundView)this.mBackgroundView).update();
            }
        }

        void dismiss() {
            if (this.mHelper != null && this.mHelper.isPopupFadeEnable() && this.mBackgroundView != null && (this.mBackgroundView instanceof PopupBackgroundView || this.mBackgroundView.getAnimation() == null) && this.mHelper.mMaskViewDismissAnimation != null) {
                if (this.mHelper.isSyncMaskAnimationDuration() && this.mHelper.dismissDuration > 0L && this.mHelper.mMaskViewDismissAnimation == this.mHelper.DEFAULT_MASK_DISMISS_ANIMATION) {
                    this.mHelper.mMaskViewDismissAnimation.setDuration(this.mHelper.dismissDuration + 50L);
                }
                this.mBackgroundView.startAnimation(this.mHelper.mMaskViewDismissAnimation);
            }
        }

        void destroy() {
            if (this.mBackgroundView instanceof PopupBackgroundView) {
                ((PopupBackgroundView)this.mBackgroundView).destroy();
                this.mBackgroundView = null;
            } else {
                this.mBackgroundView = null;
            }
        }

        void handleShow() {
            if (this.mHelper != null && this.mHelper.isPopupFadeEnable() && this.mBackgroundView != null && (this.mBackgroundView instanceof PopupBackgroundView || this.mBackgroundView.getAnimation() == null) && this.mHelper.mMaskViewShowAnimation != null) {
                if (this.mHelper.isSyncMaskAnimationDuration() && this.mHelper.showDuration > 0L && this.mHelper.mMaskViewShowAnimation == this.mHelper.DEFAULT_MASK_SHOW_ANIMATION) {
                    this.mHelper.mMaskViewShowAnimation.setDuration(this.mHelper.showDuration + 50L);
                }
                this.mBackgroundView.startAnimation(this.mHelper.mMaskViewShowAnimation);
            }
        }

        @Override
        public void clear(boolean destroy) {
            if (destroy) {
                this.mBackgroundView = null;
                this.mHelper = null;
            }
        }
    }
}

