/*
 * Decompiled with CFR 0.152.
 */
package razerdp.util;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.graphics.Point;
import android.graphics.Rect;
import android.os.Build;
import android.text.TextUtils;
import android.view.Display;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import razerdp.util.PopupUtils;

public class PopupUiUtils {
    private static final int PORTRAIT = 0;
    private static final int LANDSCAPE = 1;
    private static volatile Point[] mRealSizes = new Point[2];
    private static final Point point = new Point();
    private static Rect navigationBarRect = new Rect();
    private static int statusBarHeight;

    public static int getNavigationBarHeight(Context context) {
        if (!PopupUiUtils.checkHasNavigationBar(context)) {
            return 0;
        }
        return PopupUiUtils.getNavigationBarHeightInternal(context);
    }

    private static int getNavigationBarHeightInternal(Context context) {
        Resources resources = context.getResources();
        int resourceId = resources.getIdentifier("navigation_bar_height", "dimen", "android");
        if (resourceId > 0) {
            return resources.getDimensionPixelSize(resourceId);
        }
        return 0;
    }

    @SuppressLint(value={"NewApi"})
    public static boolean checkHasNavigationBar(Context context) {
        navigationBarRect.setEmpty();
        Activity act = PopupUtils.scanForActivity(context, 15);
        if (act == null) {
            return false;
        }
        Configuration conf = context.getResources().getConfiguration();
        if (Build.VERSION.SDK_INT < 21) {
            Window window = act.getWindow();
            if (window == null) {
                return false;
            }
            Display display = window.getWindowManager().getDefaultDisplay();
            display.getRealSize(point);
            View decorView = window.getDecorView();
            if (2 == conf.orientation) {
                boolean result;
                View contentView = decorView.findViewById(0x1020002);
                boolean bl = result = PopupUiUtils.point.x != contentView.getWidth();
                if (result) {
                    if (decorView.getLeft() > 0) {
                        navigationBarRect.set(1, 0, 0, 0);
                    } else {
                        navigationBarRect.set(0, 0, 1, 0);
                    }
                }
                return result;
            }
            decorView.getWindowVisibleDisplayFrame(navigationBarRect);
            boolean result = PopupUiUtils.navigationBarRect.bottom != PopupUiUtils.point.y;
            navigationBarRect.setEmpty();
            if (result) {
                navigationBarRect.set(0, 0, 0, 1);
            }
            return result;
        }
        ViewGroup decorView = (ViewGroup)act.getWindow().getDecorView();
        int childCount = decorView.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            String resourceEntryName;
            View child = decorView.getChildAt(i);
            if (child.getId() == -1) continue;
            try {
                resourceEntryName = act.getResources().getResourceEntryName(child.getId());
            }
            catch (Exception e) {
                continue;
            }
            if (TextUtils.isEmpty((CharSequence)resourceEntryName) || child.getId() == -1 || !child.isShown() || !TextUtils.equals((CharSequence)"navigationbarbackground", (CharSequence)resourceEntryName.toLowerCase()) && !TextUtils.equals((CharSequence)"immersion_navigation_bar_view", (CharSequence)resourceEntryName.toLowerCase())) continue;
            if (conf.orientation == 2) {
                if (child.getWidth() > child.getHeight()) {
                    navigationBarRect.set(0, 0, 0, 1);
                } else if (child.getLeft() == 0) {
                    navigationBarRect.set(1, 0, 0, 0);
                } else {
                    navigationBarRect.set(0, 0, 1, 0);
                }
            } else {
                navigationBarRect.set(0, 0, 0, 1);
            }
            return true;
        }
        return false;
    }

    public static int getScreenHeightCompat(Context context) {
        int orientation;
        int n = orientation = context.getResources().getConfiguration().orientation == 1 ? 0 : 1;
        if (Build.VERSION.SDK_INT < 17) {
            return context.getResources().getDisplayMetrics().heightPixels + (orientation == 0 ? PopupUiUtils.getFixedPortratiNavigationBarHeight(context) : 0);
        }
        if (mRealSizes[orientation] == null) {
            WindowManager windowManager = (WindowManager)context.getSystemService("window");
            if (windowManager == null) {
                return context.getResources().getDisplayMetrics().heightPixels + (orientation == 0 ? PopupUiUtils.getFixedPortratiNavigationBarHeight(context) : 0);
            }
            Display display = windowManager.getDefaultDisplay();
            Point point = new Point();
            display.getRealSize(point);
            PopupUiUtils.mRealSizes[orientation] = point;
        }
        int offset = PopupUiUtils.checkHasNavigationBar(context) ? (PopupUiUtils.navigationBarRect.bottom != 0 ? PopupUiUtils.getNavigationBarHeightInternal(context) : 0) : 0;
        return PopupUiUtils.mRealSizes[orientation].y - offset;
    }

    public static int getScreenWidthCompat(Context context) {
        int orientation;
        int n = orientation = context.getResources().getConfiguration().orientation == 1 ? 0 : 1;
        if (Build.VERSION.SDK_INT < 17) {
            return context.getResources().getDisplayMetrics().widthPixels + (orientation == 1 ? PopupUiUtils.getFixedLandScapeNavigationBarHeight(context) : 0);
        }
        if (mRealSizes[orientation] == null) {
            WindowManager windowManager = (WindowManager)context.getSystemService("window");
            if (windowManager == null) {
                return context.getResources().getDisplayMetrics().widthPixels + (orientation == 1 ? PopupUiUtils.getFixedLandScapeNavigationBarHeight(context) : 0);
            }
            Display display = windowManager.getDefaultDisplay();
            Point point = new Point();
            display.getRealSize(point);
            PopupUiUtils.mRealSizes[orientation] = point;
        }
        int offset = PopupUiUtils.checkHasNavigationBar(context) ? (PopupUiUtils.navigationBarRect.right != 0 ? PopupUiUtils.getNavigationBarHeightInternal(context) : 0) : 0;
        return PopupUiUtils.mRealSizes[orientation].x - offset;
    }

    private static int getFixedPortratiNavigationBarHeight(Context context) {
        if (!PopupUiUtils.checkHasNavigationBar(context) && PopupUiUtils.navigationBarRect.bottom != 0) {
            return PopupUiUtils.getNavigationBarHeightInternal(context);
        }
        return 0;
    }

    private static int getFixedLandScapeNavigationBarHeight(Context context) {
        if (!PopupUiUtils.checkHasNavigationBar(context) && PopupUiUtils.navigationBarRect.right != 0) {
            return PopupUiUtils.getNavigationBarHeightInternal(context);
        }
        return 0;
    }

    public static int getScreenOrientation(Context context) {
        if (context == null) {
            return 1;
        }
        return context.getResources().getConfiguration().orientation;
    }

    public static int getStatusBarHeight(Context context) {
        PopupUiUtils.checkStatusBarHeight(context);
        return statusBarHeight;
    }

    private static void checkStatusBarHeight(Context context) {
        if (statusBarHeight != 0 || context == null) {
            return;
        }
        int result = 0;
        int resourceId = context.getResources().getIdentifier("status_bar_height", "dimen", "android");
        if (resourceId > 0) {
            result = context.getResources().getDimensionPixelSize(resourceId);
        }
        statusBarHeight = result;
    }
}

