/*
 * Decompiled with CFR 0.152.
 */
package razerdp.basepopup;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.content.Context;
import android.graphics.Point;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.PopupWindow;
import java.lang.ref.WeakReference;
import razerdp.basepopup.BasePopupFlag;
import razerdp.basepopup.BasePopupWindow;
import razerdp.basepopup.PopupKeyboardStateChangeListener;
import razerdp.basepopup.PopupTouchController;
import razerdp.basepopup.PopupWindowActionListener;
import razerdp.basepopup.PopupWindowLocationListener;
import razerdp.blur.PopupBlurOption;
import razerdp.interceptor.PopupWindowEventInterceptor;
import razerdp.library.R;

final class BasePopupHelper
implements PopupTouchController,
PopupWindowActionListener,
PopupWindowLocationListener,
PopupKeyboardStateChangeListener,
BasePopupFlag {
    private static final int CONTENT_VIEW_ID = R.id.base_popup_content_root;
    static final int DEFAULT_WIDTH = -2;
    static final int DEFAULT_HEIGHT = -2;
    private ShowMode mShowMode = ShowMode.SCREEN;
    private int contentRootId = CONTENT_VIEW_ID;
    private int flag = 125;
    private static int showCount;
    private Animation mShowAnimation;
    private Animator mShowAnimator;
    private Animation mDismissAnimation;
    private Animator mDismissAnimator;
    private BasePopupWindow.OnDismissListener mOnDismissListener;
    private BasePopupWindow.OnBeforeShowCallback mOnBeforeShowCallback;
    private BasePopupWindow.GravityMode gravityMode = BasePopupWindow.GravityMode.RELATIVE_TO_ANCHOR;
    private int popupGravity = 0;
    private int offsetX;
    private int offsetY;
    private int preMeasureWidth;
    private int preMeasureHeight;
    private int popupViewWidth;
    private int popupViewHeight;
    private int[] mAnchorViewLocation;
    private int mAnchorViewHeight;
    private int mAnchorViewWidth;
    private PopupBlurOption mBlurOption;
    private Drawable mBackgroundDrawable = new ColorDrawable(BasePopupWindow.DEFAULT_BACKGROUND_COLOR);
    private int alignBackgroundGravity = 48;
    private View mBackgroundView;
    private PopupTouchController mTouchControllerDelegate;
    private PopupWindowActionListener mActionListener;
    private PopupWindowLocationListener mLocationListener;
    private PopupKeyboardStateChangeListener mKeyboardStateChangeListener;
    private PopupWindowEventInterceptor mEventInterceptor;
    private int mSoftInputMode = 16;
    private ViewGroup.MarginLayoutParams mParseFromXmlParams;
    private Point mTempOffset = new Point();
    private int maxWidth;
    private int maxHeight;
    private int minWidth;
    private int minHeight;
    private InnerShowInfo mShowInfo;

    BasePopupHelper(PopupTouchController controller) {
        this.mAnchorViewLocation = new int[2];
        this.mTouchControllerDelegate = controller;
    }

    BasePopupHelper registerActionListener(PopupWindowActionListener actionListener) {
        this.mActionListener = actionListener;
        return this;
    }

    BasePopupHelper registerLocationLisener(PopupWindowLocationListener locationListener) {
        this.mLocationListener = locationListener;
        return this;
    }

    BasePopupHelper registerKeyboardStateChangeListener(PopupKeyboardStateChangeListener mKeyboardStateChangeListener) {
        this.mKeyboardStateChangeListener = mKeyboardStateChangeListener;
        return this;
    }

    public View inflate(Context context, int layoutId) {
        try {
            FrameLayout tempLayout = new FrameLayout(context);
            View result = LayoutInflater.from((Context)context).inflate(layoutId, (ViewGroup)tempLayout, false);
            ViewGroup.LayoutParams childParams = result.getLayoutParams();
            if (childParams != null) {
                this.checkAndSetGravity(childParams);
                if (childParams instanceof ViewGroup.MarginLayoutParams) {
                    this.mParseFromXmlParams = new ViewGroup.MarginLayoutParams((ViewGroup.MarginLayoutParams)childParams);
                    if ((this.flag & 0x1000000) != 0) {
                        this.mParseFromXmlParams.width = this.popupViewWidth;
                    }
                    if ((this.flag & 0x2000000) != 0) {
                        this.mParseFromXmlParams.height = this.popupViewHeight;
                    }
                    tempLayout = null;
                    return result;
                }
                this.mParseFromXmlParams = new ViewGroup.MarginLayoutParams(childParams);
                if ((this.flag & 0x1000000) != 0) {
                    this.mParseFromXmlParams.width = this.popupViewWidth;
                }
                if ((this.flag & 0x2000000) != 0) {
                    this.mParseFromXmlParams.height = this.popupViewHeight;
                }
                tempLayout = null;
                return result;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private void checkAndSetGravity(ViewGroup.LayoutParams p) {
        if (p == null) {
            return;
        }
        if (p instanceof LinearLayout.LayoutParams) {
            this.setPopupGravity(this.gravityMode, ((LinearLayout.LayoutParams)p).gravity);
        } else if (p instanceof FrameLayout.LayoutParams) {
            this.setPopupGravity(this.gravityMode, ((FrameLayout.LayoutParams)p).gravity);
        }
    }

    Animation getShowAnimation() {
        return this.mShowAnimation;
    }

    BasePopupHelper setShowAnimation(Animation showAnimation) {
        if (this.mShowAnimation == showAnimation) {
            return this;
        }
        if (this.mShowAnimation != null) {
            this.mShowAnimation.cancel();
        }
        this.mShowAnimation = showAnimation;
        this.applyBlur(this.mBlurOption);
        return this;
    }

    Animator getShowAnimator() {
        return this.mShowAnimator;
    }

    BasePopupHelper setShowAnimator(Animator showAnimator) {
        if (this.mShowAnimator == showAnimator) {
            return this;
        }
        if (this.mShowAnimator != null) {
            this.mShowAnimator.cancel();
        }
        this.mShowAnimator = showAnimator;
        this.applyBlur(this.mBlurOption);
        return this;
    }

    Animation getDismissAnimation() {
        return this.mDismissAnimation;
    }

    BasePopupHelper setDismissAnimation(Animation dismissAnimation) {
        if (this.mDismissAnimation == dismissAnimation) {
            return this;
        }
        if (this.mDismissAnimation != null) {
            this.mDismissAnimation.cancel();
        }
        this.mDismissAnimation = dismissAnimation;
        this.applyBlur(this.mBlurOption);
        return this;
    }

    Animator getDismissAnimator() {
        return this.mDismissAnimator;
    }

    BasePopupHelper setDismissAnimator(Animator dismissAnimator) {
        if (this.mDismissAnimator == dismissAnimator) {
            return this;
        }
        if (this.mDismissAnimator != null) {
            this.mDismissAnimator.cancel();
        }
        this.mDismissAnimator = dismissAnimator;
        this.applyBlur(this.mBlurOption);
        return this;
    }

    boolean isCustomMeasure() {
        return (this.flag & 0x3000000) != 0;
    }

    int getPopupViewWidth() {
        if ((this.flag & 0x1000000) != 0) {
            return this.popupViewWidth;
        }
        if (this.mParseFromXmlParams != null) {
            return this.mParseFromXmlParams.width;
        }
        return this.popupViewWidth;
    }

    BasePopupHelper setPopupViewWidth(int popupViewWidth) {
        this.popupViewWidth = popupViewWidth;
        if (popupViewWidth != -2) {
            this.setFlag(0x1000000, true);
            if (this.mParseFromXmlParams != null) {
                this.mParseFromXmlParams.width = popupViewWidth;
            }
        } else {
            this.setFlag(0x1000000, false);
        }
        return this;
    }

    int getPopupViewHeight() {
        if ((this.flag & 0x2000000) != 0) {
            return this.popupViewHeight;
        }
        if (this.mParseFromXmlParams != null) {
            return this.mParseFromXmlParams.height;
        }
        return this.popupViewHeight;
    }

    BasePopupHelper setPopupViewHeight(int popupViewHeight) {
        this.popupViewHeight = popupViewHeight;
        if (popupViewHeight != -2) {
            this.setFlag(0x2000000, true);
            if (this.mParseFromXmlParams != null) {
                this.mParseFromXmlParams.height = popupViewHeight;
            }
        } else {
            this.setFlag(0x2000000, false);
        }
        return this;
    }

    int getPreMeasureWidth() {
        return this.preMeasureWidth;
    }

    BasePopupHelper setPreMeasureWidth(int preMeasureWidth) {
        this.preMeasureWidth = preMeasureWidth;
        return this;
    }

    int getPreMeasureHeight() {
        return this.preMeasureHeight;
    }

    BasePopupHelper setPreMeasureHeight(int preMeasureHeight) {
        this.preMeasureHeight = preMeasureHeight;
        return this;
    }

    boolean isPopupFadeEnable() {
        return (this.flag & 0x40) != 0;
    }

    BasePopupHelper setPopupFadeEnable(PopupWindow popupWindow, boolean fadeEnable) {
        if (popupWindow == null) {
            return this;
        }
        this.setFlag(64, fadeEnable);
        return this;
    }

    boolean isShowAsDropDown() {
        return (this.flag & 0x100) != 0;
    }

    BasePopupHelper setShowAsDropDown(boolean showAsDropDown) {
        this.setFlag(256, showAsDropDown);
        return this;
    }

    BasePopupHelper setShowLocation(int x, int y) {
        this.mAnchorViewLocation[0] = x;
        this.mAnchorViewLocation[1] = y;
        this.mAnchorViewWidth = 1;
        this.mAnchorViewHeight = 1;
        return this;
    }

    BasePopupWindow.GravityMode getGravityMode() {
        return this.gravityMode;
    }

    int getPopupGravity() {
        return this.popupGravity;
    }

    BasePopupHelper setPopupGravity(BasePopupWindow.GravityMode mode, int popupGravity) {
        if (popupGravity == this.popupGravity && this.gravityMode == mode) {
            return this;
        }
        this.gravityMode = mode;
        this.popupGravity = popupGravity;
        return this;
    }

    public BasePopupHelper setClipChildren(boolean clipChildren) {
        this.setFlag(16, clipChildren);
        return this;
    }

    int getOffsetX() {
        return this.offsetX;
    }

    BasePopupHelper setOffsetX(int offsetX) {
        this.offsetX = offsetX;
        return this;
    }

    int getOffsetY() {
        return this.offsetY;
    }

    BasePopupHelper setOffsetY(int offsetY) {
        this.offsetY = offsetY;
        return this;
    }

    boolean isAutoShowInputMethod() {
        return (this.flag & 0x200) != 0;
    }

    BasePopupHelper autoShowInputMethod(PopupWindow popupWindow, boolean autoShowInputMethod) {
        if (popupWindow == null) {
            return this;
        }
        this.setFlag(512, autoShowInputMethod);
        popupWindow.setSoftInputMode(autoShowInputMethod ? 16 : 1);
        return this;
    }

    BasePopupHelper setSoftInputMode(int inputMethodType) {
        this.mSoftInputMode = inputMethodType;
        return this;
    }

    boolean isAutoLocatePopup() {
        return (this.flag & 0x80) != 0;
    }

    BasePopupHelper autoLocatePopup(boolean autoLocatePopup) {
        this.setFlag(128, autoLocatePopup);
        return this;
    }

    BasePopupWindow.OnDismissListener getOnDismissListener() {
        return this.mOnDismissListener;
    }

    BasePopupHelper setOnDismissListener(BasePopupWindow.OnDismissListener onDismissListener) {
        this.mOnDismissListener = onDismissListener;
        return this;
    }

    BasePopupWindow.OnBeforeShowCallback getOnBeforeShowCallback() {
        return this.mOnBeforeShowCallback;
    }

    BasePopupHelper setOnBeforeShowCallback(BasePopupWindow.OnBeforeShowCallback onBeforeShowCallback) {
        this.mOnBeforeShowCallback = onBeforeShowCallback;
        return this;
    }

    boolean isOutSideDismiss() {
        return (this.flag & 1) != 0;
    }

    BasePopupHelper dismissOutSideTouch(PopupWindow popupWindow, boolean dismissWhenTouchOutside) {
        if (popupWindow == null) {
            return this;
        }
        this.setFlag(1, dismissWhenTouchOutside);
        return this;
    }

    boolean isOutSideTouchable() {
        return (this.flag & 2) != 0;
    }

    BasePopupHelper outSideTouchable(PopupWindow popupWindow, boolean touchAble) {
        if (popupWindow == null) {
            return this;
        }
        this.setFlag(2, touchAble);
        return this;
    }

    BasePopupHelper setClipToScreen(boolean clipToScreen) {
        this.setFlag(32, clipToScreen);
        return this;
    }

    BasePopupHelper setEventInterceptor(PopupWindowEventInterceptor mInterceptor) {
        this.mEventInterceptor = mInterceptor;
        return this;
    }

    BasePopupHelper getAnchorLocation(View v) {
        if (v == null) {
            return this;
        }
        v.getLocationOnScreen(this.mAnchorViewLocation);
        this.mAnchorViewWidth = v.getWidth();
        this.mAnchorViewHeight = v.getHeight();
        return this;
    }

    public Point getTempOffset() {
        return this.mTempOffset;
    }

    public Point getTempOffset(int x, int y) {
        this.mTempOffset.set(x, y);
        return this.mTempOffset;
    }

    int getAnchorWidth() {
        return this.mAnchorViewWidth;
    }

    int getAnchorHeight() {
        return this.mAnchorViewHeight;
    }

    int getAnchorX() {
        return this.mAnchorViewLocation[0];
    }

    int getAnchorY() {
        return this.mAnchorViewLocation[1];
    }

    boolean isBackPressEnable() {
        return (this.flag & 4) != 0;
    }

    boolean isClipToScreen() {
        return (this.flag & 0x20) != 0;
    }

    BasePopupHelper backPressEnable(PopupWindow popupWindow, boolean backPressEnable) {
        if (popupWindow == null) {
            return this;
        }
        this.setFlag(4, backPressEnable);
        return this;
    }

    boolean isFullScreen() {
        return (this.flag & 8) != 0;
    }

    BasePopupHelper fullScreen(boolean fullScreen) {
        this.setFlag(8, fullScreen);
        return this;
    }

    PopupBlurOption getBlurOption() {
        return this.mBlurOption;
    }

    BasePopupHelper applyBlur(PopupBlurOption option) {
        this.mBlurOption = option;
        if (option != null) {
            long duration;
            if (option.getBlurInDuration() <= 0L && (duration = this.getShowAnimationDuration()) > 0L) {
                option.setBlurInDuration(duration);
            }
            if (option.getBlurOutDuration() <= 0L && (duration = this.getDismissAnimationDuration()) > 0L) {
                option.setBlurOutDuration(duration);
            }
        }
        return this;
    }

    long getShowAnimationDuration() {
        long duration = 0L;
        if (this.mShowAnimation != null) {
            duration = this.mShowAnimation.getDuration();
        } else if (this.mShowAnimator != null) {
            duration = this.getDurationFromAnimator(this.mShowAnimator);
        }
        return duration < 0L ? 500L : duration;
    }

    long getDismissAnimationDuration() {
        long duration = 0L;
        if (this.mDismissAnimation != null) {
            duration = this.mDismissAnimation.getDuration();
        } else if (this.mDismissAnimator != null) {
            duration = this.getDurationFromAnimator(this.mDismissAnimator);
        }
        return duration < 0L ? 500L : duration;
    }

    private long getDurationFromAnimator(Animator animator) {
        if (animator == null) {
            return -1L;
        }
        long duration = 0L;
        if (animator instanceof AnimatorSet) {
            AnimatorSet set = (AnimatorSet)animator;
            duration = set.getDuration();
            if (duration < 0L) {
                for (Animator childAnimation : set.getChildAnimations()) {
                    duration = Math.max(duration, childAnimation.getDuration());
                }
            }
        } else {
            duration = animator.getDuration();
        }
        return duration;
    }

    Drawable getPopupBackground() {
        return this.mBackgroundDrawable;
    }

    BasePopupHelper setPopupBackground(Drawable background) {
        this.mBackgroundDrawable = background;
        return this;
    }

    boolean isAlignBackground() {
        return (this.flag & 0x400) != 0;
    }

    BasePopupHelper setAlignBackgound(boolean mAlignBackground) {
        this.setFlag(1024, mAlignBackground);
        if (!mAlignBackground) {
            this.setAlignBackgroundGravity(0);
        }
        return this;
    }

    int getAlignBackgroundGravity() {
        if (this.isAlignBackground() && this.alignBackgroundGravity == 0) {
            this.alignBackgroundGravity = 48;
        }
        return this.alignBackgroundGravity;
    }

    BasePopupHelper setAlignBackgroundGravity(int gravity) {
        this.alignBackgroundGravity = gravity;
        return this;
    }

    boolean isAllowToBlur() {
        return this.mBlurOption != null && this.mBlurOption.isAllowToBlur();
    }

    boolean isClipChildren() {
        return (this.flag & 0x10) != 0;
    }

    ViewGroup.MarginLayoutParams getParaseFromXmlParams() {
        return this.mParseFromXmlParams;
    }

    int getShowCount() {
        return showCount;
    }

    PopupWindowEventInterceptor getEventInterceptor() {
        return this.mEventInterceptor;
    }

    BasePopupHelper setContentRootId(View contentRoot) {
        if (contentRoot == null) {
            return this;
        }
        if (contentRoot.getId() == -1) {
            contentRoot.setId(CONTENT_VIEW_ID);
        }
        this.contentRootId = contentRoot.getId();
        return this;
    }

    int getContentRootId() {
        return this.contentRootId;
    }

    int getSoftInputMode() {
        return this.mSoftInputMode;
    }

    View getBackgroundView() {
        return this.mBackgroundView;
    }

    BasePopupHelper setBackgroundView(View backgroundView) {
        this.mBackgroundView = backgroundView;
        return this;
    }

    int getMaxWidth() {
        return this.maxWidth;
    }

    BasePopupHelper setMaxWidth(int maxWidth) {
        this.maxWidth = maxWidth;
        return this;
    }

    int getMaxHeight() {
        return this.maxHeight;
    }

    BasePopupHelper setMaxHeight(int maxHeight) {
        this.maxHeight = maxHeight;
        return this;
    }

    ShowMode getShowMode() {
        return this.mShowMode;
    }

    BasePopupHelper setShowMode(ShowMode showMode) {
        this.mShowMode = showMode;
        return this;
    }

    int getMinWidth() {
        return this.minWidth;
    }

    BasePopupHelper setMinWidth(int minWidth) {
        this.minWidth = minWidth;
        return this;
    }

    int getMinHeight() {
        return this.minHeight;
    }

    BasePopupHelper setMinHeight(int minHeight) {
        this.minHeight = minHeight;
        return this;
    }

    BasePopupHelper keepSize(boolean keep) {
        this.setFlag(2048, keep);
        return this;
    }

    boolean isKeepSize() {
        return (this.flag & 0x800) != 0;
    }

    void prepare(View v, boolean positionMode) {
        this.mShowInfo = new InnerShowInfo(v, positionMode);
        if (positionMode) {
            this.setShowMode(ShowMode.POSITION);
        } else {
            this.setShowMode(v == null ? ShowMode.SCREEN : ShowMode.RELATIVE_TO_ANCHOR);
        }
        this.getAnchorLocation(v);
    }

    void handleShow() {
        if (Build.VERSION.SDK_INT == 21 || Build.VERSION.SDK_INT == 22) {
            ++showCount;
        }
    }

    void handleDismiss() {
        if (Build.VERSION.SDK_INT == 21 || Build.VERSION.SDK_INT == 22) {
            --showCount;
            showCount = Math.max(0, showCount);
        }
    }

    private void setFlag(int flag, boolean added) {
        if (!added) {
            this.flag &= ~flag;
        } else {
            this.flag |= flag;
            if (flag == 128) {
                this.flag |= 0x100;
            }
        }
    }

    @Override
    public boolean onBeforeDismiss() {
        return this.mTouchControllerDelegate.onBeforeDismiss();
    }

    @Override
    public boolean callDismissAtOnce() {
        return this.mTouchControllerDelegate.callDismissAtOnce();
    }

    @Override
    public boolean onDispatchKeyEvent(KeyEvent event) {
        return this.mTouchControllerDelegate.onDispatchKeyEvent(event);
    }

    @Override
    public boolean onInterceptTouchEvent(MotionEvent event) {
        return this.mTouchControllerDelegate.onInterceptTouchEvent(event);
    }

    @Override
    public boolean onTouchEvent(MotionEvent event) {
        return this.mTouchControllerDelegate.onTouchEvent(event);
    }

    @Override
    public boolean onBackPressed() {
        return this.mTouchControllerDelegate.onBackPressed();
    }

    @Override
    public boolean onOutSideTouch() {
        return this.mTouchControllerDelegate.onOutSideTouch();
    }

    @Override
    public void onShow(boolean hasAnimate) {
        if (this.mActionListener != null) {
            this.mActionListener.onShow(hasAnimate);
        }
    }

    @Override
    public void onDismiss(boolean hasAnimate) {
        if (this.mActionListener != null) {
            this.mActionListener.onDismiss(hasAnimate);
        }
    }

    @Override
    public void onAnchorTop() {
        if (this.mLocationListener != null) {
            this.mLocationListener.onAnchorTop();
        }
    }

    @Override
    public void onAnchorBottom() {
        if (this.mLocationListener != null) {
            this.mLocationListener.onAnchorBottom();
        }
    }

    @Override
    public void onKeyboardChange(int keyboardTop, int keyboardHeight, boolean isVisible, boolean fullScreen) {
        if (this.mKeyboardStateChangeListener != null) {
            this.mKeyboardStateChangeListener.onKeyboardChange(keyboardTop, keyboardHeight, isVisible, fullScreen);
        }
    }

    @Override
    public boolean onUpdate() {
        if (this.mShowInfo != null) {
            this.prepare(this.mShowInfo.mAnchorView == null ? null : (View)this.mShowInfo.mAnchorView.get(), this.mShowInfo.positionMode);
        }
        return false;
    }

    private static class InnerShowInfo {
        WeakReference<View> mAnchorView;
        boolean positionMode;

        InnerShowInfo(View mAnchorView, boolean positionMode) {
            this.mAnchorView = new WeakReference<View>(mAnchorView);
            this.positionMode = positionMode;
        }
    }

    static enum ShowMode {
        RELATIVE_TO_ANCHOR,
        SCREEN,
        POSITION;

    }
}

