/*
 * Decompiled with CFR 0.152.
 */
package razerdp.util.log;

import android.text.TextUtils;
import android.util.Log;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import razerdp.util.log.LogTag;

public class PopupLogUtil {
    private static final boolean[] mIsDebugMode = new boolean[]{false};
    private static final String TAG = "BasePopup";
    private static final int MAX_LOG_MSG_LENGTH = 4000;
    private static final boolean LOG_LONG = true;

    public static void trace(String msg) {
        PopupLogUtil.trace(LogTag.i, msg);
    }

    public static void trace(Throwable throwable) {
        PopupLogUtil.trace(LogTag.i, throwable);
    }

    public static void trace(LogTag method, String msg) {
        PopupLogUtil.trace(method, TAG, msg);
    }

    public static void trace(LogTag method, Throwable throwable) {
        PopupLogUtil.trace(method, TAG, throwable);
    }

    public static void trace(LogTag method, String tag, String msg) {
        PopupLogUtil.trace(method, tag, msg, null);
    }

    public static void trace(LogTag method, String tag, Throwable throwable) {
        PopupLogUtil.trace(method, tag, null, throwable);
    }

    public static void trace(LogTag method, String tag, String msg, Throwable throwable) {
        if (!PopupLogUtil.checkOpenLog()) {
            return;
        }
        PopupLogUtil.traceInternal(method, tag, PopupLogUtil.getLogMsg(msg, throwable));
    }

    private static void traceInternal(LogTag method, String tag, String content) {
        try {
            long length = content.length();
            if (length <= 4000L) {
                PopupLogUtil.logByMethod(method, tag, content);
            } else {
                while (content.length() > 4000) {
                    String logContent = content.substring(0, 4000);
                    content = content.replace(logContent, "");
                    PopupLogUtil.logByMethod(method, tag, logContent);
                }
                PopupLogUtil.logByMethod(method, tag, content);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void logByMethod(LogTag method, String tag, String outPutMsg) {
        switch (method) {
            case i: {
                Log.i((String)tag, (String)outPutMsg);
                break;
            }
            case d: {
                Log.d((String)tag, (String)outPutMsg);
                break;
            }
            case w: {
                Log.w((String)tag, (String)outPutMsg);
                break;
            }
            case e: {
                Log.e((String)tag, (String)outPutMsg);
                break;
            }
            case v: {
                Log.v((String)tag, (String)outPutMsg);
                break;
            }
            default: {
                Log.i((String)tag, (String)outPutMsg);
            }
        }
    }

    private static String getLogMsg(String msg, Throwable throwable) {
        if (!TextUtils.isEmpty((CharSequence)msg)) {
            return PopupLogUtil.wrapLogWithMethodLocation(msg);
        }
        if (throwable != null) {
            return PopupLogUtil.wrapLogWithMethodLocation(PopupLogUtil.getCrashInfo(throwable));
        }
        return "\u6ca1\u6709\u65e5\u5fd7\u54e6";
    }

    private static boolean checkOpenLog() {
        return mIsDebugMode[0];
    }

    public static void setOpenLog(boolean openLog) {
        PopupLogUtil.mIsDebugMode[0] = openLog;
    }

    public static boolean isOpenLog() {
        return mIsDebugMode[0];
    }

    private static String wrapLogWithMethodLocation(String msg) {
        StackTraceElement element = PopupLogUtil.getCurrentStackTrace();
        String className = "unknow";
        String methodName = "unknow";
        int lineNumber = -1;
        if (element != null) {
            className = element.getFileName();
            methodName = element.getMethodName();
            lineNumber = element.getLineNumber();
        }
        StringBuilder sb = new StringBuilder();
        msg = PopupLogUtil.wrapJson(msg);
        sb.append("  (").append(className).append(":").append(lineNumber).append(") #").append(methodName).append("\uff1a").append('\n').append(msg);
        return sb.toString();
    }

    public static String wrapJson(String jsonStr) {
        String message;
        if (TextUtils.isEmpty((CharSequence)jsonStr)) {
            return "json\u4e3a\u7a7a";
        }
        try {
            if (jsonStr.startsWith("{")) {
                JSONObject jsonObject = new JSONObject(jsonStr);
                message = jsonObject.toString(2);
                message = "\n================JSON================\n" + message + '\n' + "================JSON================\n";
            } else if (jsonStr.startsWith("[")) {
                JSONArray jsonArray = new JSONArray(jsonStr);
                message = jsonArray.toString(4);
                message = "\n================JSONARRAY================\n" + message + '\n' + "================JSONARRAY================\n";
            } else {
                message = jsonStr;
            }
        }
        catch (JSONException e) {
            message = jsonStr;
        }
        return message;
    }

    public static String getCrashInfo(Throwable tr) {
        StringWriter writer = new StringWriter();
        PrintWriter printWriter = new PrintWriter(writer);
        tr.printStackTrace(printWriter);
        for (Throwable cause = tr.getCause(); cause != null; cause = cause.getCause()) {
            cause.printStackTrace(printWriter);
        }
        String crashInfo = ((Object)writer).toString();
        printWriter.close();
        return crashInfo;
    }

    private static StackTraceElement getCurrentStackTrace() {
        StackTraceElement[] trace = Thread.currentThread().getStackTrace();
        int stackOffset = PopupLogUtil.getStackOffset(trace, PopupLogUtil.class);
        if (stackOffset == -1 && (stackOffset = PopupLogUtil.getStackOffset(trace, Logger.class)) == -1 && (stackOffset = PopupLogUtil.getStackOffset(trace, Log.class)) == -1) {
            return null;
        }
        return trace[stackOffset];
    }

    private static int getStackOffset(StackTraceElement[] trace, Class cla) {
        int logIndex = -1;
        for (int i = 0; i < trace.length; ++i) {
            StackTraceElement element = trace[i];
            String tClass = element.getClassName();
            if (TextUtils.equals((CharSequence)tClass, (CharSequence)cla.getName())) {
                logIndex = i;
                continue;
            }
            if (logIndex > -1) break;
        }
        if (logIndex != -1 && ++logIndex >= trace.length) {
            logIndex = trace.length - 1;
        }
        return logIndex;
    }

    public static String wrapLocation(Class cla, int lineNumber) {
        return ".(" + cla.getSimpleName() + ".java:" + lineNumber + ")";
    }
}

