/*
 * Decompiled with CFR 0.152.
 */
package razerdp.basepopup;

import android.content.Context;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import razerdp.basepopup.BasePopupHelper;
import razerdp.basepopup.PopupBackgroundView;
import razerdp.basepopup.PopupWindowActionListener;
import razerdp.blur.BlurImageView;
import razerdp.util.PopupUtils;
import razerdp.util.log.PopupLogUtil;

class PopupMaskLayout
extends FrameLayout {
    private PopupBackgroundView mBackgroundView;
    private BlurImageView mBlurImageView;

    private PopupMaskLayout(Context context) {
        this(context, null);
    }

    private PopupMaskLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    private PopupMaskLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public static PopupMaskLayout create(Context context, BasePopupHelper helper) {
        PopupMaskLayout view = new PopupMaskLayout(context);
        view.init(context, helper);
        return view;
    }

    public boolean dispatchKeyEvent(KeyEvent event) {
        boolean dispatch = super.dispatchKeyEvent(event);
        PopupLogUtil.trace("dispatch  >> " + dispatch);
        return dispatch;
    }

    private void init(Context context, BasePopupHelper mHelper) {
        this.setLayoutAnimation(null);
        if (mHelper == null) {
            this.setBackgroundColor(0);
            return;
        }
        if (mHelper.isAllowToBlur()) {
            this.mBlurImageView = new BlurImageView(context);
            this.mBlurImageView.applyBlurOption(mHelper.getBlurOption());
            this.addViewInLayout((View)this.mBlurImageView, -1, (ViewGroup.LayoutParams)this.generateDefaultLayoutParams());
        }
        if (!PopupUtils.isBackgroundInvalidated(mHelper.getPopupBackground())) {
            this.mBackgroundView = PopupBackgroundView.creaete(context, mHelper);
            this.addViewInLayout(this.mBackgroundView, -1, (ViewGroup.LayoutParams)this.generateDefaultLayoutParams());
        }
        mHelper.registerActionListener(new PopupWindowActionListener(){

            @Override
            public void onShow(boolean hasAnimate) {
            }

            @Override
            public void onDismiss(boolean hasAnimate) {
                PopupMaskLayout.this.handleDismiss(hasAnimate ? -2L : 0L);
            }
        });
    }

    public void handleAlignBackground(int gravity, int contentLeft, int contentTop, int contentRight, int contentBottom) {
        int left = this.getLeft();
        int top = this.getTop();
        int right = this.getRight();
        int bottom = this.getBottom();
        switch (gravity & 7) {
            case 3: 
            case 0x800003: {
                left = contentLeft;
                break;
            }
            case 5: 
            case 0x800005: {
                right = contentRight;
                break;
            }
        }
        switch (gravity & 0x70) {
            case 48: {
                top = contentTop;
                break;
            }
            case 80: {
                bottom = contentBottom;
                break;
            }
        }
        this.mBackgroundView.layout(left, top, right, bottom);
    }

    protected FrameLayout.LayoutParams generateDefaultLayoutParams() {
        return new FrameLayout.LayoutParams(-1, -1);
    }

    public void update() {
        if (this.mBlurImageView != null) {
            this.mBlurImageView.update();
        }
    }

    public void handleStart(long duration) {
        if (this.mBlurImageView != null) {
            this.mBlurImageView.start(duration);
        }
    }

    public void handleDismiss(long duration) {
        if (this.mBlurImageView != null) {
            this.mBlurImageView.dismiss(duration);
        }
        if (this.mBackgroundView != null) {
            this.mBackgroundView.handleAnimateDismiss();
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.removeAllViews();
        if (this.mBackgroundView != null) {
            this.mBackgroundView.destroy();
            this.mBackgroundView = null;
        }
        if (this.mBlurImageView != null) {
            this.mBlurImageView.destroy();
            this.mBlurImageView = null;
        }
    }
}

