/*
 * Decompiled with CFR 0.152.
 */
package razerdp.widget;

import android.animation.Animator;
import android.content.Context;
import android.util.Pair;
import android.view.View;
import android.view.animation.Animation;
import java.util.HashMap;
import java.util.Map;
import razerdp.basepopup.BasePopupWindow;
import razerdp.basepopup.QuickPopupConfig;

public class QuickPopup
extends BasePopupWindow {
    private QuickPopupConfig mConfig;
    private View content;

    public QuickPopup(Context context, QuickPopupConfig config, View contentView, int w, int h) {
        super(context, w, h);
        this.mConfig = config;
        if (this.mConfig == null) {
            throw new NullPointerException("QuickPopupConfig must be not null!");
        }
        this.callInitInternal(context, w, h);
        this.applyConfigSetting(this.mConfig);
    }

    protected void applyConfigSetting(QuickPopupConfig config) {
        if (config.getPopupBlurOption() != null) {
            this.setBlurOption(config.getPopupBlurOption());
        } else {
            this.setBlurBackgroundEnable(config.isBlurBackground(), config.getOnBlurOptionInitListener());
        }
        this.setPopupFadeEnable(config.isFadeEnable());
        this.applyClick();
        this.setOffsetX(config.getOffsetX());
        this.setOffsetY(config.getOffsetY());
        this.setClipChildren(config.isClipChildren());
        this.setAllowInterceptTouchEvent(config.isAllowInterceptTouchEvent());
        this.setPopupGravity(config.getGravity());
        this.setAlignBackground(config.isAlignBackground());
        this.setAutoLocatePopup(config.isAutoLocated());
        if (config.getBackground() != null) {
            this.setBackground(config.getBackground());
        }
    }

    private void applyClick() {
        HashMap<Integer, Pair<View.OnClickListener, Boolean>> eventsMap = this.mConfig.getListenersHolderMap();
        if (eventsMap == null || eventsMap.isEmpty()) {
            return;
        }
        for (Map.Entry<Integer, Pair<View.OnClickListener, Boolean>> entry : eventsMap.entrySet()) {
            int viewId = entry.getKey();
            final Pair<View.OnClickListener, Boolean> event = entry.getValue();
            Object v = this.findViewById(viewId);
            if (v == null) continue;
            if (((Boolean)event.second).booleanValue()) {
                v.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        if (event.first != null) {
                            ((View.OnClickListener)event.first).onClick(v);
                        }
                        QuickPopup.this.dismiss();
                    }
                });
                continue;
            }
            v.setOnClickListener((View.OnClickListener)event.first);
        }
    }

    @Override
    protected Animation onCreateShowAnimation() {
        return this.mConfig.getShowAnimation();
    }

    @Override
    protected Animation onCreateDismissAnimation() {
        return this.mConfig.getDismissAnimation();
    }

    @Override
    protected Animator onCreateDismissAnimator() {
        return this.mConfig.getDismissAnimator();
    }

    @Override
    protected Animator onCreateShowAnimator() {
        return this.mConfig.getShowAnimator();
    }

    @Override
    public View onCreateContentView() {
        return this.createPopupById(this.mConfig.getContentViewLayoutid());
    }
}

