/*
 * Decompiled with CFR 0.152.
 */
package razerdp.basepopup;

import android.content.Context;
import android.util.AttributeSet;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import razerdp.basepopup.BasePopupHelper;
import razerdp.basepopup.PopupBackgroundView;
import razerdp.basepopup.PopupWindowActionListener;
import razerdp.blur.BlurImageView;
import razerdp.util.PopupUtil;
import razerdp.util.log.PopupLogUtil;

class PopupMaskLayout
extends FrameLayout {
    private PopupBackgroundView mBackgroundView;
    private BlurImageView mBlurImageView;
    private int lastContentTop;

    private PopupMaskLayout(Context context) {
        this(context, null);
    }

    private PopupMaskLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    private PopupMaskLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    public static PopupMaskLayout create(Context context, BasePopupHelper helper) {
        PopupMaskLayout view = new PopupMaskLayout(context);
        view.init(context, helper);
        return view;
    }

    public boolean dispatchKeyEvent(KeyEvent event) {
        boolean dispatch = super.dispatchKeyEvent(event);
        PopupLogUtil.trace("dispatch  >> " + dispatch);
        return dispatch;
    }

    private void init(Context context, BasePopupHelper mHelper) {
        this.setLayoutAnimation(null);
        if (mHelper == null) {
            this.setBackgroundColor(0);
            return;
        }
        if (mHelper.isAllowToBlur()) {
            this.mBlurImageView = new BlurImageView(context);
            this.mBlurImageView.applyBlurOption(mHelper.getBlurOption());
            this.addViewInLayout((View)this.mBlurImageView, -1, (ViewGroup.LayoutParams)this.generateDefaultLayoutParams());
        }
        if (!PopupUtil.isBackgroundInvalidated(mHelper.getPopupBackground())) {
            this.mBackgroundView = PopupBackgroundView.creaete(context, mHelper);
            this.addViewInLayout(this.mBackgroundView, -1, (ViewGroup.LayoutParams)this.generateDefaultLayoutParams());
        }
        mHelper.registerActionListener(new PopupWindowActionListener(){

            @Override
            public void onShow(boolean hasAnimate) {
            }

            @Override
            public void onDismiss(boolean hasAnimate) {
                PopupMaskLayout.this.handleDismiss(hasAnimate ? -2L : 0L);
            }
        });
    }

    public void handleAlignBackground(int contentLeft, int contentTop, int contentRight, int contentBottom) {
        if (contentTop > 0 && this.lastContentTop != contentTop) {
            this.lastContentTop = contentTop;
            this.mBackgroundView.offsetTopAndBottom(contentTop);
        }
    }

    protected FrameLayout.LayoutParams generateDefaultLayoutParams() {
        return new FrameLayout.LayoutParams(-1, -1);
    }

    public void handleStart(long duration) {
        if (this.mBlurImageView != null) {
            this.mBlurImageView.start(duration);
        }
    }

    public void handleDismiss(long duration) {
        if (this.mBlurImageView != null) {
            this.mBlurImageView.dismiss(duration);
        }
        if (this.mBackgroundView != null) {
            this.mBackgroundView.handleAnimateDismiss();
        }
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.removeAllViews();
        if (this.mBackgroundView != null) {
            this.mBackgroundView.destroy();
            this.mBackgroundView = null;
        }
        if (this.mBlurImageView != null) {
            this.mBlurImageView.destroy();
            this.mBlurImageView = null;
        }
    }
}

