/*
 * Decompiled with CFR 0.152.
 */
package razerdp.util;

import android.app.Activity;
import android.content.Context;
import android.view.View;
import android.view.inputmethod.InputMethodManager;

public class InputMethodUtils {
    public static void showInputMethod(View view) {
        InputMethodManager imm = (InputMethodManager)view.getContext().getSystemService("input_method");
        if (imm != null) {
            imm.showSoftInput(view, 1);
        }
    }

    public static void showInputMethod(Context context) {
        InputMethodManager imm = (InputMethodManager)context.getSystemService("input_method");
        imm.toggleSoftInput(0, 2);
    }

    public static void showInputMethod(final View view, long delayMillis) {
        if (view == null) {
            return;
        }
        view.postDelayed(new Runnable(){

            @Override
            public void run() {
                InputMethodUtils.showInputMethod(view);
            }
        }, delayMillis);
    }

    public static void close(Activity activity) {
        if (activity == null) {
            return;
        }
        View view = activity.getWindow().getDecorView().getRootView();
        try {
            InputMethodManager imm = (InputMethodManager)view.getContext().getSystemService("input_method");
            if (imm != null) {
                imm.hideSoftInputFromWindow(view.getWindowToken(), 2);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void close(View view) {
        try {
            InputMethodManager imm = (InputMethodManager)view.getContext().getSystemService("input_method");
            if (imm != null) {
                imm.hideSoftInputFromWindow(view.getWindowToken(), 0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

