/*
 * Decompiled with CFR 0.152.
 */
package razerdp.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class UnsafeHelper {
    private static Object unSafe;

    private UnsafeHelper() {
    }

    private static void creteUnSafe() {
        try {
            Class<?> unsafeClass = Class.forName("sun.misc.Unsafe");
            Field f = unsafeClass.getDeclaredField("theUnsafe");
            f.setAccessible(true);
            unSafe = f.get(null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void checkUnSafe() throws NullPointerException {
        if (unSafe == null) {
            throw new NullPointerException("unsafe\u5bf9\u8c61\u4e3a\u7a7a");
        }
    }

    public static long objectFieldOffset(Field field) throws Exception {
        UnsafeHelper.checkUnSafe();
        Method field_objectFieldOffset = unSafe.getClass().getMethod("objectFieldOffset", Field.class);
        return (Long)field_objectFieldOffset.invoke(unSafe, field);
    }

    public static Object getObject(Object var1, long var2) throws Exception {
        UnsafeHelper.checkUnSafe();
        Method field_getObject = unSafe.getClass().getMethod("getObject", Object.class, Long.TYPE);
        return field_getObject.invoke(unSafe, var1, var2);
    }

    public static void putObject(Object var1, long var2, Object var4) throws Exception {
        UnsafeHelper.checkUnSafe();
        Method field_putObject = unSafe.getClass().getMethod("putObject", Object.class, Long.TYPE, Object.class);
        field_putObject.invoke(unSafe, var1, var2, var4);
    }

    public static int arrayBaseOffset(Class<?> var1) throws Exception {
        UnsafeHelper.checkUnSafe();
        Method field_arrayBaseOffset = unSafe.getClass().getMethod("arrayBaseOffset", Class.class);
        return (Integer)field_arrayBaseOffset.invoke(unSafe, var1);
    }

    public static int addressSize() throws Exception {
        UnsafeHelper.checkUnSafe();
        Method field_addressSize = unSafe.getClass().getMethod("addressSize", new Class[0]);
        return (Integer)field_addressSize.invoke(unSafe, new Object[0]);
    }

    public static int getInt(long var1) throws Exception {
        UnsafeHelper.checkUnSafe();
        Method field_getInt = unSafe.getClass().getMethod("getInt", Long.TYPE);
        return (Integer)field_getInt.invoke(unSafe, var1);
    }

    public static int getInt(Object var1, long var2) throws Exception {
        UnsafeHelper.checkUnSafe();
        Method field_getInt = unSafe.getClass().getMethod("getInt", Object.class, Long.TYPE);
        return (Integer)field_getInt.invoke(unSafe, var1, var2);
    }

    public static int getLong(long var1) throws Exception {
        UnsafeHelper.checkUnSafe();
        Method field_getLong = unSafe.getClass().getMethod("getLong", Long.TYPE);
        return (Integer)field_getLong.invoke(unSafe, var1);
    }

    public static int getLong(Object var1, long var2) throws Exception {
        UnsafeHelper.checkUnSafe();
        Method field_getLong = unSafe.getClass().getMethod("getLong", Object.class, Long.TYPE);
        return (Integer)field_getLong.invoke(unSafe, var1, var2);
    }

    public static long addressOf(Object o) throws Exception {
        long result;
        UnsafeHelper.checkUnSafe();
        Object[] array = new Object[]{o};
        long baseOffset = UnsafeHelper.arrayBaseOffset(Object[].class);
        int addressSize = UnsafeHelper.addressSize();
        switch (addressSize) {
            case 4: {
                result = UnsafeHelper.getInt(array, baseOffset);
                break;
            }
            case 8: {
                result = UnsafeHelper.getLong(array, baseOffset);
                break;
            }
            default: {
                throw new Error("unsupported address size: " + addressSize);
            }
        }
        return result;
    }

    public static Object getObjectVolatile(Object var1, long var2) throws Exception {
        UnsafeHelper.checkUnSafe();
        Method field_getObjectVolatile = unSafe.getClass().getMethod("getObjectVolatile", Object.class, Long.TYPE);
        return field_getObjectVolatile.invoke(unSafe, var1, var2);
    }

    public static void putObjectVolatile(Object var1, long var2, Object var4) throws Exception {
        UnsafeHelper.checkUnSafe();
        Method field_putObjectVolatile = unSafe.getClass().getMethod("putObjectVolatile", Object.class, Long.TYPE, Object.class);
        field_putObjectVolatile.invoke(unSafe, var1, var2, var4);
    }

    static {
        UnsafeHelper.creteUnSafe();
    }
}

