/*
 * Decompiled with CFR 0.152.
 */
package razerdp.basepopup;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.AnimatorSet;
import android.app.Activity;
import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.Log;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.widget.AdapterView;
import android.widget.EditText;
import android.widget.PopupWindow;
import java.lang.ref.WeakReference;
import razerdp.basepopup.BasePopup;
import razerdp.basepopup.BasePopupHelper;
import razerdp.basepopup.InnerPopupWindowStateListener;
import razerdp.basepopup.PopupTouchController;
import razerdp.basepopup.PopupWindowProxy;
import razerdp.blur.PopupBlurOption;
import razerdp.util.InputMethodUtils;
import razerdp.util.SimpleAnimationUtils;
import razerdp.util.log.LogTag;
import razerdp.util.log.PopupLogUtil;

public abstract class BasePopupWindow
implements BasePopup,
PopupWindow.OnDismissListener,
PopupTouchController {
    private static final String TAG = "BasePopupWindow";
    private static final int MAX_RETRY_SHOW_TIME = 3;
    private BasePopupHelper mHelper;
    public static int SCREEN_WIDTH = 0;
    public static int SCREEN_HEIGHT = 0;
    private WeakReference<Context> mContext;
    private PopupWindowProxy mPopupWindow;
    private View mContentView;
    protected View mDisplayAnimateView;
    private volatile boolean isExitAnimatePlaying = false;
    private int retryCounter;
    private InnerPopupWindowStateListener mStateListener;
    private EditText mAutoShowInputEdittext;
    private boolean initImmediately;
    private Animator.AnimatorListener mAnimatorListener = new AnimatorListenerAdapter(){

        public void onAnimationStart(Animator animation) {
            BasePopupWindow.this.isExitAnimatePlaying = true;
            if (BasePopupWindow.this.mStateListener != null) {
                BasePopupWindow.this.mStateListener.onAnimateDismissStart();
            }
        }

        public void onAnimationEnd(Animator animation) {
            BasePopupWindow.this.mContentView.post(new Runnable(){

                @Override
                public void run() {
                    BasePopupWindow.this.mPopupWindow.callSuperDismiss();
                    BasePopupWindow.this.isExitAnimatePlaying = false;
                }
            });
        }

        public void onAnimationCancel(Animator animation) {
            BasePopupWindow.this.isExitAnimatePlaying = false;
        }
    };
    private Animation.AnimationListener mAnimationListener = new SimpleAnimationUtils.AnimationListenerAdapter(){

        @Override
        public void onAnimationStart(Animation animation) {
            BasePopupWindow.this.isExitAnimatePlaying = true;
            if (BasePopupWindow.this.mStateListener != null) {
                BasePopupWindow.this.mStateListener.onAnimateDismissStart();
            }
        }

        @Override
        public void onAnimationEnd(Animation animation) {
            BasePopupWindow.this.mContentView.post(new Runnable(){

                @Override
                public void run() {
                    BasePopupWindow.this.mPopupWindow.callSuperDismiss();
                    BasePopupWindow.this.isExitAnimatePlaying = false;
                }
            });
        }
    };

    public BasePopupWindow(Context context) {
        this(context, -1, -1);
    }

    public BasePopupWindow(Context context, int w, int h) {
        this(context, w, h, true);
    }

    protected BasePopupWindow(Context context, int w, int h, boolean initImmediately) {
        this.initImmediately = initImmediately;
        if (initImmediately) {
            this.initView(context, w, h);
        }
    }

    protected void callInit(Context context, int w, int h) {
        if (this.initImmediately) {
            return;
        }
        this.initView(context, w, h);
    }

    private void initView(Context context, int w, int h) {
        this.mContext = new WeakReference<Context>(context);
        this.mHelper = new BasePopupHelper();
        this.mContentView = this.onCreateContentView();
        this.mDisplayAnimateView = this.onCreateAnimateView();
        if (this.mDisplayAnimateView == null) {
            this.mDisplayAnimateView = this.mContentView;
        }
        this.mPopupWindow = new PopupWindowProxy(this.mContentView, w, h, (PopupTouchController)this);
        this.mPopupWindow.setOnDismissListener(this);
        this.mPopupWindow.bindPopupHelper(this.mHelper);
        this.setAllowDismissWhenTouchOutside(true);
        this.mHelper.setPopupViewWidth(w);
        this.mHelper.setPopupViewHeight(h);
        this.preMeasurePopupView(w, h);
        View v = this.onInitDismissClickView();
        if (v != null && !(v instanceof AdapterView)) {
            v.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    BasePopupWindow.this.dismiss();
                }
            });
        }
        this.mHelper.setShowAnimation(this.onCreateShowAnimation()).setShowAnimator(this.onCreateShowAnimator()).setDismissAnimation(this.onCreateDismissAnimation()).setDismissAnimator(this.onCreateDismissAnimator());
    }

    private void preMeasurePopupView(int w, int h) {
        if (this.mContentView != null) {
            int measureWidth = View.MeasureSpec.makeMeasureSpec((int)w, (int)0);
            int measureHeight = View.MeasureSpec.makeMeasureSpec((int)h, (int)0);
            this.mContentView.measure(measureWidth, measureHeight);
            this.mHelper.setPreMeasureWidth(this.mContentView.getMeasuredWidth()).setPreMeasureHeight(this.mContentView.getMeasuredHeight());
            this.mContentView.setFocusableInTouchMode(true);
        }
    }

    protected abstract Animation onCreateShowAnimation();

    protected abstract Animation onCreateDismissAnimation();

    protected View onInitDismissClickView() {
        return this.getContentView();
    }

    protected Animator onCreateShowAnimator() {
        return null;
    }

    protected View onCreateAnimateView() {
        return null;
    }

    protected Animator onCreateDismissAnimator() {
        return null;
    }

    public BasePopupWindow setPopupFadeEnable(boolean needPopupFadeAnimate) {
        this.mHelper.setPopupFadeEnable(this.mPopupWindow, needPopupFadeAnimate);
        return this;
    }

    public boolean isPopupFadeEnable() {
        return this.mHelper.isPopupFadeEnable();
    }

    public BasePopupWindow setPopupAnimationStyle(int animationStyleRes) {
        this.mPopupWindow.setAnimationStyle(animationStyleRes);
        return this;
    }

    public void showPopupWindow() {
        if (this.checkPerformShow(null)) {
            this.mHelper.setShowAsDropDown(false);
            this.tryToShowPopup(null);
        }
    }

    public void showPopupWindow(int anchorViewResid) {
        Context context = this.getContext();
        assert (context != null) : "context is null";
        if (context instanceof Activity) {
            View v = ((Activity)context).findViewById(anchorViewResid);
            this.showPopupWindow(v);
        } else {
            Log.e((String)TAG, (String)"can not get token from context,make sure that context is instance of activity");
        }
    }

    public void showPopupWindow(View anchorView) {
        if (this.checkPerformShow(anchorView)) {
            this.mHelper.setShowAsDropDown(true);
            this.tryToShowPopup(anchorView);
        }
    }

    private void tryToShowPopup(View v) {
        try {
            if (this.isShowing()) {
                return;
            }
            if (v != null) {
                int[] offset = this.calculateOffset(v);
                if (this.mHelper.isShowAsDropDown()) {
                    this.mPopupWindow.showAsDropDownProxy(v, offset[0], offset[1]);
                } else {
                    this.mPopupWindow.showAtLocationProxy(v, this.mHelper.getPopupGravity(), offset[0], offset[1]);
                }
            } else {
                Context context = this.getContext();
                assert (context != null) : "context is null ! please make sure your activity is not be destroyed";
                if (context instanceof Activity) {
                    this.mPopupWindow.showAtLocationProxy(((Activity)context).findViewById(0x1020002), this.mHelper.getPopupGravity(), this.mHelper.getOffsetX(), this.mHelper.getOffsetY());
                } else {
                    Log.e((String)TAG, (String)"can not get token from context,make sure that context is instance of activity");
                }
            }
            if (this.mStateListener != null) {
                this.mStateListener.onTryToShow(this.mHelper.getShowAnimation() != null || this.mHelper.getShowAnimator() != null);
            }
            if (this.mDisplayAnimateView != null) {
                if (this.mHelper.getShowAnimation() != null) {
                    this.mHelper.getShowAnimation().cancel();
                    this.mDisplayAnimateView.startAnimation(this.mHelper.getShowAnimation());
                } else if (this.mHelper.getShowAnimator() != null) {
                    this.mHelper.getShowAnimator().start();
                }
            }
            if (this.mHelper.isAutoShowInputMethod() && this.mAutoShowInputEdittext != null) {
                this.mAutoShowInputEdittext.requestFocus();
                InputMethodUtils.showInputMethod((View)this.mAutoShowInputEdittext, 350L);
            }
            this.retryCounter = 0;
        }
        catch (Exception e) {
            this.retryToShowPopup(v);
            PopupLogUtil.trace(LogTag.e, TAG, "show error\n" + e.getMessage());
            e.printStackTrace();
        }
    }

    private void retryToShowPopup(final View v) {
        boolean available;
        Activity act;
        if (this.retryCounter > 3) {
            return;
        }
        PopupLogUtil.trace(LogTag.e, TAG, "catch an exception on showing popupwindow ...now retrying to show ... retry count  >>  " + this.retryCounter);
        if (this.mPopupWindow.callSuperIsShowing()) {
            this.mPopupWindow.callSuperDismiss();
        }
        if ((act = this.mPopupWindow.scanForActivity(this.getContext())) == null) {
            return;
        }
        if (Build.VERSION.SDK_INT >= 17) {
            available = !act.isFinishing() && !act.isDestroyed();
        } else {
            boolean bl = available = !act.isFinishing();
        }
        if (available) {
            View rootView = act.getWindow().getDecorView();
            if (rootView == null) {
                return;
            }
            rootView.postDelayed(new Runnable(){

                @Override
                public void run() {
                    BasePopupWindow.this.retryCounter++;
                    BasePopupWindow.this.tryToShowPopup(v);
                    PopupLogUtil.trace(LogTag.e, BasePopupWindow.TAG, "retry to show >> " + BasePopupWindow.this.retryCounter);
                }
            }, 350L);
        }
    }

    private int[] calculateOffset(View anchorView) {
        int[] offset = new int[]{this.mHelper.getOffsetX(), this.mHelper.getOffsetY()};
        this.mHelper.getAnchorLocation(anchorView);
        if (this.mHelper.isAutoLocatePopup()) {
            boolean onTop;
            boolean bl = onTop = this.getScreenHeight() - (this.mHelper.getAnchorY() + offset[1]) < this.getHeight();
            if (onTop) {
                offset[1] = -anchorView.getHeight() - this.getHeight() - offset[1];
                this.mHelper.setInternalOffsetY(offset[1]);
                this.onAnchorTop(this.mContentView, anchorView);
            } else {
                this.onAnchorBottom(this.mContentView, anchorView);
            }
        }
        return offset;
    }

    public BasePopupWindow setAdjustInputMethod(boolean needAdjust) {
        this.setAdjustInputMethod(needAdjust, 16);
        return this;
    }

    public BasePopupWindow setAdjustInputMethod(boolean needAdjust, int flag) {
        if (needAdjust) {
            this.mPopupWindow.setSoftInputMode(flag);
        } else {
            this.mPopupWindow.setSoftInputMode(48);
        }
        return this;
    }

    public BasePopupWindow setAutoShowInputMethod(EditText editText, boolean autoShow) {
        this.mHelper.setAutoShowInputMethod(this.mPopupWindow, autoShow);
        this.mAutoShowInputEdittext = editText;
        return this;
    }

    public BasePopupWindow setBackPressEnable(boolean backPressEnable) {
        this.mHelper.setBackPressEnable(this.mPopupWindow, backPressEnable);
        return this;
    }

    public View createPopupById(int resId) {
        if (resId != 0) {
            return LayoutInflater.from((Context)this.getContext()).inflate(resId, null);
        }
        return null;
    }

    public <T extends View> T findViewById(int id2) {
        if (this.mContentView != null && id2 != 0) {
            return (T)this.mContentView.findViewById(id2);
        }
        return null;
    }

    public BasePopupWindow setPopupWindowFullScreen(boolean needFullScreen) {
        this.mHelper.setFullScreen(needFullScreen);
        return this;
    }

    public BasePopupWindow setBackgroundColor(int color) {
        this.mHelper.setPopupBackground((Drawable)new ColorDrawable(color));
        return this;
    }

    public BasePopupWindow setBackground(int drawableIds) {
        if (Build.VERSION.SDK_INT >= 21) {
            return this.setBackground(this.getContext().getDrawable(drawableIds));
        }
        return this.setBackground(this.getContext().getResources().getDrawable(drawableIds, this.getContext().getTheme()));
    }

    public BasePopupWindow setBackground(Drawable background) {
        this.mHelper.setPopupBackground(background);
        return this;
    }

    public Drawable getPopupBackground() {
        return this.mHelper.getPopupBackground();
    }

    public BasePopupWindow setBlurBackgroundEnable(boolean blur) {
        return this.setBlurBackgroundEnable(blur, null);
    }

    public BasePopupWindow setBlurBackgroundEnable(boolean blur, OnBlurOptionInitListener optionInitListener) {
        if (!(this.getContext() instanceof Activity)) {
            PopupLogUtil.trace(LogTag.e, TAG, "\u65e0\u6cd5\u914d\u7f6e\u9ed8\u8ba4\u6a21\u7cca\u811a\u672c\uff0c\u56e0\u4e3acontext\u4e0d\u662factivity");
            return this;
        }
        PopupBlurOption option = null;
        if (blur) {
            View decorView;
            option = new PopupBlurOption();
            option.setFullScreen(true).setBlurInDuration(this.mHelper.getShowAnimationDuration()).setBlurOutDuration(this.mHelper.getExitAnimationDuration());
            if (optionInitListener != null) {
                optionInitListener.onCreateBlurOption(option);
            }
            if ((decorView = ((Activity)this.getContext()).getWindow().getDecorView()) instanceof ViewGroup) {
                option.setBlurView(((ViewGroup)decorView).getChildAt(0));
            } else {
                option.setBlurView(decorView);
            }
        }
        return this.setBlurOption(option);
    }

    public BasePopupWindow setBlurOption(PopupBlurOption option) {
        this.mHelper.applyBlur(option);
        return this;
    }

    protected void setViewClickListener(View.OnClickListener listener, View ... views) {
        for (View view : views) {
            if (view == null || listener == null) continue;
            view.setOnClickListener(listener);
        }
    }

    public boolean isShowing() {
        return this.mPopupWindow.isShowing();
    }

    public OnDismissListener getOnDismissListener() {
        return this.mHelper.getOnDismissListener();
    }

    public BasePopupWindow setOnDismissListener(OnDismissListener onDismissListener) {
        this.mHelper.setOnDismissListener(onDismissListener);
        return this;
    }

    public OnBeforeShowCallback getOnBeforeShowCallback() {
        return this.mHelper.getOnBeforeShowCallback();
    }

    public BasePopupWindow setOnBeforeShowCallback(OnBeforeShowCallback mOnBeforeShowCallback) {
        this.mHelper.setOnBeforeShowCallback(mOnBeforeShowCallback);
        return this;
    }

    public BasePopupWindow setShowAnimation(Animation showAnimation) {
        this.mHelper.setShowAnimation(showAnimation);
        return this;
    }

    public Animation getShowAnimation() {
        return this.mHelper.getShowAnimation();
    }

    public BasePopupWindow setShowAnimator(Animator showAnimator) {
        this.mHelper.setShowAnimator(showAnimator);
        return this;
    }

    public Animator getShowAnimator() {
        return this.mHelper.getShowAnimator();
    }

    public BasePopupWindow setDismissAnimation(Animation dismissAnimation) {
        this.mHelper.setDismissAnimation(dismissAnimation);
        return this;
    }

    public Animation getDismissAnimation() {
        return this.mHelper.getDismissAnimation();
    }

    public BasePopupWindow setDismissAnimator(Animator dismissAnimator) {
        this.mHelper.setDismissAnimator(dismissAnimator);
        return this;
    }

    public Animator getDismissAnimator() {
        return this.mHelper.getDismissAnimator();
    }

    public Context getContext() {
        return this.mContext == null ? null : (Context)this.mContext.get();
    }

    public View getContentView() {
        return this.mContentView;
    }

    public PopupWindow getPopupWindow() {
        return this.mPopupWindow;
    }

    public int getOffsetX() {
        return this.mHelper.getOffsetX();
    }

    public BasePopupWindow setOffsetX(int offsetX) {
        this.mHelper.setOffsetX(offsetX);
        return this;
    }

    public int getOffsetY() {
        return this.mHelper.getOffsetY();
    }

    public BasePopupWindow setOffsetY(int offsetY) {
        this.mHelper.setOffsetY(offsetY);
        return this;
    }

    public int getPopupGravity() {
        return this.mHelper.getPopupGravity();
    }

    public BasePopupWindow setPopupGravity(int popupGravity) {
        this.mHelper.setPopupGravity(popupGravity);
        return this;
    }

    public boolean isAutoLocatePopup() {
        return this.mHelper.isAutoLocatePopup();
    }

    public BasePopupWindow setAutoLocatePopup(boolean autoLocatePopup) {
        this.mHelper.setShowAsDropDown(true).setAutoLocatePopup(true);
        return this;
    }

    public int getHeight() {
        return this.mPopupWindow.getHeight() <= 0 ? this.mHelper.getPreMeasureHeight() : this.mPopupWindow.getHeight();
    }

    public int getWidth() {
        return this.mPopupWindow.getWidth() <= 0 ? this.mHelper.getPreMeasureWidth() : this.mPopupWindow.getWidth();
    }

    public BasePopupWindow setAllowDismissWhenTouchOutside(boolean dismissWhenTouchOutside) {
        this.mHelper.setDismissWhenTouchOutside(this.mPopupWindow, dismissWhenTouchOutside);
        return this;
    }

    public BasePopupWindow setAllowInterceptTouchEvent(boolean touchable) {
        this.mHelper.setInterceptTouchEvent(this.mPopupWindow, touchable);
        return this;
    }

    public boolean isAllowDismissWhenTouchOutside() {
        return this.mHelper.isDismissWhenTouchOutside();
    }

    public boolean isAllowInterceptTouchEvent() {
        return this.mHelper.isInterceptTouchEvent();
    }

    public boolean isAlignMaskToPopup() {
        return this.mHelper.isAlignBackground();
    }

    public BasePopupWindow setAlignBackground(boolean mAlignBackground) {
        this.mHelper.setAlignBackgound(mAlignBackground);
        return this;
    }

    void setOnInnerPopupWindowStateListener(InnerPopupWindowStateListener listener) {
        this.mStateListener = listener;
    }

    public void dismiss() {
        try {
            this.mPopupWindow.dismiss();
        }
        catch (Exception e) {
            PopupLogUtil.trace(LogTag.e, TAG, "dismiss error");
            e.printStackTrace();
        }
    }

    @Override
    public boolean onBeforeDismiss() {
        return this.checkPerformDismiss();
    }

    @Override
    public boolean callDismissAtOnce() {
        boolean hasAnima = false;
        if (this.mHelper.getDismissAnimation() != null && this.mDisplayAnimateView != null) {
            if (!this.isExitAnimatePlaying) {
                this.mHelper.getDismissAnimation().setAnimationListener(this.mAnimationListener);
                this.mHelper.getDismissAnimation().cancel();
                this.mDisplayAnimateView.startAnimation(this.mHelper.getDismissAnimation());
                this.isExitAnimatePlaying = true;
                hasAnima = true;
            }
        } else if (this.mHelper.getDismissAnimator() != null && !this.isExitAnimatePlaying) {
            this.mHelper.getDismissAnimator().removeListener(this.mAnimatorListener);
            this.mHelper.getDismissAnimator().addListener(this.mAnimatorListener);
            this.mHelper.getDismissAnimator().start();
            this.isExitAnimatePlaying = true;
            hasAnima = true;
        }
        if (!hasAnima && this.mStateListener != null) {
            this.mStateListener.onNoAnimateDismiss();
        }
        return !hasAnima;
    }

    public void dismissWithOutAnimate() {
        if (!this.checkPerformDismiss()) {
            return;
        }
        if (this.mHelper.getDismissAnimation() != null && this.mDisplayAnimateView != null) {
            this.mHelper.getDismissAnimation().cancel();
        }
        if (this.mHelper.getDismissAnimator() != null) {
            this.mHelper.getDismissAnimator().removeAllListeners();
        }
        this.mPopupWindow.callSuperDismiss();
        if (this.mStateListener != null) {
            this.mStateListener.onNoAnimateDismiss();
        }
    }

    private boolean checkPerformDismiss() {
        boolean callDismiss = true;
        if (this.mHelper.getOnDismissListener() != null) {
            callDismiss = this.mHelper.getOnDismissListener().onBeforeDismiss();
        }
        return callDismiss && !this.isExitAnimatePlaying;
    }

    private boolean checkPerformShow(View v) {
        boolean result = true;
        if (this.mHelper.getOnBeforeShowCallback() != null) {
            result = this.mHelper.getOnBeforeShowCallback().onBeforeShow(this.mContentView, v, this.mHelper.getShowAnimation() != null || this.mHelper.getShowAnimator() != null);
        }
        return result;
    }

    @Override
    public boolean onDispatchKeyEvent(KeyEvent event) {
        return false;
    }

    @Override
    public boolean onInterceptTouchEvent(MotionEvent event) {
        return false;
    }

    @Override
    public boolean onTouchEvent(MotionEvent event) {
        return false;
    }

    @Override
    public boolean onBackPressed() {
        if (this.mHelper.isBackPressEnable()) {
            this.dismiss();
            return true;
        }
        return false;
    }

    @Override
    public boolean onOutSideTouch() {
        boolean result = false;
        if (this.mHelper.isDismissWhenTouchOutside()) {
            this.dismiss();
            result = true;
        } else if (this.mHelper.isInterceptTouchEvent()) {
            result = true;
        }
        return result;
    }

    protected Animation getTranslateVerticalAnimation(int start, int end, int durationMillis) {
        return SimpleAnimationUtils.getTranslateVerticalAnimation(start, end, durationMillis);
    }

    protected Animation getTranslateVerticalAnimation(float start, float end, int durationMillis) {
        return SimpleAnimationUtils.getTranslateVerticalAnimation(start, end, durationMillis);
    }

    protected Animation getScaleAnimation(float fromX, float toX, float fromY, float toY, int pivotXType, float pivotXValue, int pivotYType, float pivotYValue) {
        return SimpleAnimationUtils.getScaleAnimation(fromX, toX, fromY, toY, pivotXType, pivotXValue, pivotYType, pivotYValue);
    }

    protected Animation getDefaultScaleAnimation() {
        return this.getDefaultScaleAnimation(true);
    }

    protected Animation getDefaultScaleAnimation(boolean in) {
        return SimpleAnimationUtils.getDefaultScaleAnimation(in);
    }

    protected Animation getDefaultAlphaAnimation() {
        return this.getDefaultAlphaAnimation(true);
    }

    protected Animation getDefaultAlphaAnimation(boolean in) {
        return SimpleAnimationUtils.getDefaultAlphaAnimation(in);
    }

    protected AnimatorSet getDefaultSlideFromBottomAnimationSet() {
        return SimpleAnimationUtils.getDefaultSlideFromBottomAnimationSet(this.mDisplayAnimateView);
    }

    public int getScreenHeight() {
        if (SCREEN_HEIGHT == 0) {
            SCREEN_HEIGHT = this.getContext().getResources().getDisplayMetrics().heightPixels;
        }
        return SCREEN_HEIGHT;
    }

    public int getScreenWidth() {
        if (SCREEN_WIDTH == 0) {
            SCREEN_WIDTH = this.getContext().getResources().getDisplayMetrics().widthPixels;
        }
        return SCREEN_WIDTH;
    }

    protected void onAnchorTop(View mPopupView, View anchorView) {
    }

    protected void onAnchorBottom(View mPopupView, View anchorView) {
    }

    public void onDismiss() {
        if (this.mHelper.getOnDismissListener() != null) {
            this.mHelper.getOnDismissListener().onDismiss();
        }
        this.isExitAnimatePlaying = false;
    }

    protected float dipToPx(float dip) {
        if (this.getContext() == null) {
            return dip;
        }
        return dip * this.getContext().getResources().getDisplayMetrics().density + 0.5f;
    }

    public static void setDebugLogEnable(boolean printLog) {
        PopupLogUtil.setOpenLog(printLog);
    }

    public static abstract class OnDismissListener
    implements PopupWindow.OnDismissListener {
        public boolean onBeforeDismiss() {
            return true;
        }
    }

    public static interface OnBlurOptionInitListener {
        public void onCreateBlurOption(PopupBlurOption var1);
    }

    public static interface OnBeforeShowCallback {
        public boolean onBeforeShow(View var1, View var2, boolean var3);
    }
}

