/*
 * Decompiled with CFR 0.152.
 */
package razerdp.basepopup;

import android.animation.Animator;
import android.util.Pair;
import android.view.View;
import android.view.animation.Animation;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import razerdp.basepopup.BasePopupWindow;
import razerdp.blur.PopupBlurOption;
import razerdp.util.SimpleAnimationUtils;

public final class QuickPopupConfig {
    Animation mShowAnimation;
    Animation mDismissAnimation;
    Animator mShowAnimator;
    Animator mDismissAnimator;
    boolean fadeEnable = true;
    BasePopupWindow.OnDismissListener mDismissListener;
    boolean blurBackground;
    WeakReference<BasePopupWindow.OnBlurOptionInitListener> mOnBlurOptionInitListener;
    PopupBlurOption mPopupBlurOption;
    int offsetX;
    int offsetY;
    float offsetRatioOfPopupWidth;
    float offsetRatioOfPopupHeight;
    boolean alignBackground;
    HashMap<Integer, Pair<View.OnClickListener, Boolean>> mListenersHolderMap;

    public static QuickPopupConfig generateDefault() {
        return new QuickPopupConfig().withShowAnimation(SimpleAnimationUtils.getDefaultAlphaAnimation(true)).withDismissAnimation(SimpleAnimationUtils.getDefaultScaleAnimation(false)).fadeInAndOut(true);
    }

    public QuickPopupConfig withShowAnimation(Animation showAnimation) {
        this.mShowAnimation = showAnimation;
        return this;
    }

    public QuickPopupConfig withDismissAnimation(Animation dismissAnimation) {
        this.mDismissAnimation = dismissAnimation;
        return this;
    }

    public QuickPopupConfig withShowAnimator(Animator showAnimator) {
        this.mShowAnimator = showAnimator;
        return this;
    }

    public QuickPopupConfig withDismissAnimator(Animator dismissAnimator) {
        this.mDismissAnimator = dismissAnimator;
        return this;
    }

    public QuickPopupConfig dismissListener(BasePopupWindow.OnDismissListener dismissListener) {
        this.mDismissListener = dismissListener;
        return this;
    }

    public QuickPopupConfig blurBackground(boolean blurBackground) {
        return this.blurBackground(blurBackground, null);
    }

    public QuickPopupConfig blurBackground(boolean blurBackground, BasePopupWindow.OnBlurOptionInitListener mInitListener) {
        this.blurBackground = blurBackground;
        this.mOnBlurOptionInitListener = new WeakReference<BasePopupWindow.OnBlurOptionInitListener>(mInitListener);
        return this;
    }

    public QuickPopupConfig withBlurOption(PopupBlurOption popupBlurOption) {
        this.mPopupBlurOption = popupBlurOption;
        return this;
    }

    public QuickPopupConfig withClick(int viewId, View.OnClickListener listener) {
        return this.withClick(viewId, listener, false);
    }

    public QuickPopupConfig withClick(int viewId, View.OnClickListener listener, boolean dismissWhenClick) {
        if (this.mListenersHolderMap == null) {
            this.mListenersHolderMap = new HashMap();
        }
        this.mListenersHolderMap.put(viewId, (Pair<View.OnClickListener, Boolean>)Pair.create((Object)listener, (Object)dismissWhenClick));
        return this;
    }

    public QuickPopupConfig fadeInAndOut(boolean fadeEnable) {
        this.fadeEnable = fadeEnable;
        return this;
    }

    public QuickPopupConfig offsetX(int offsetX) {
        return this.offsetX(offsetX, 0.0f);
    }

    public QuickPopupConfig offsetY(int offsetY) {
        return this.offsetY(offsetY, 0.0f);
    }

    public QuickPopupConfig offsetX(int offsetX, float ratioOfPopupWidth) {
        this.offsetX = offsetX;
        this.offsetRatioOfPopupWidth = ratioOfPopupWidth;
        return this;
    }

    public QuickPopupConfig offsetY(int offsetY, float ratioOfPopupHeight) {
        this.offsetY = offsetY;
        this.offsetRatioOfPopupHeight = ratioOfPopupHeight;
        return this;
    }

    public QuickPopupConfig alignBackground(boolean alignBackground) {
        this.alignBackground = alignBackground;
        return this;
    }

    public Animation getShowAnimation() {
        return this.mShowAnimation;
    }

    public Animation getDismissAnimation() {
        return this.mDismissAnimation;
    }

    public Animator getShowAnimator() {
        return this.mShowAnimator;
    }

    public Animator getDismissAnimator() {
        return this.mDismissAnimator;
    }

    public PopupBlurOption getPopupBlurOption() {
        return this.mPopupBlurOption;
    }

    public boolean isBlurBackground() {
        return this.blurBackground;
    }

    public boolean isFadeEnable() {
        return this.fadeEnable;
    }

    public int getOffsetX() {
        return this.offsetX;
    }

    public int getOffsetY() {
        return this.offsetY;
    }

    public float getOffsetRatioOfPopupWidth() {
        return this.offsetRatioOfPopupWidth;
    }

    public float getOffsetRatioOfPopupHeight() {
        return this.offsetRatioOfPopupHeight;
    }

    public boolean isAlignBackground() {
        return this.alignBackground;
    }

    public HashMap<Integer, Pair<View.OnClickListener, Boolean>> getListenersHolderMap() {
        return this.mListenersHolderMap;
    }

    public BasePopupWindow.OnBlurOptionInitListener getOnBlurOptionInitListener() {
        if (this.mOnBlurOptionInitListener == null) {
            return null;
        }
        return (BasePopupWindow.OnBlurOptionInitListener)this.mOnBlurOptionInitListener.get();
    }

    public BasePopupWindow.OnDismissListener getDismissListener() {
        return this.mDismissListener;
    }
}

