/*
 * Decompiled with CFR 0.152.
 */
package razerdp.blur;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.os.Build;
import android.os.Looper;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.DecelerateInterpolator;
import android.widget.ImageView;
import java.lang.ref.WeakReference;
import razerdp.blur.BlurHelper;
import razerdp.blur.PopupBlurOption;
import razerdp.blur.thread.ThreadPoolManager;
import razerdp.util.log.LogTag;
import razerdp.util.log.PopupLogUtil;

public class BlurImageView
extends ImageView {
    private static final String TAG = "BlurImageView";
    private volatile boolean abortBlur = false;
    private WeakReference<PopupBlurOption> mBlurOption;
    private volatile boolean blurFinish = false;
    private volatile boolean isAnimating = false;
    private long startDuration;

    public BlurImageView(Context context) {
        this(context, null);
    }

    public BlurImageView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public BlurImageView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        this.setFocusable(false);
        this.setFocusableInTouchMode(false);
        this.setScaleType(ImageView.ScaleType.MATRIX);
        this.setAlpha(0.0f);
        if (Build.VERSION.SDK_INT >= 16) {
            this.setBackground(null);
        } else {
            this.setBackgroundDrawable(null);
        }
    }

    public void attachBlurOption(PopupBlurOption option) {
        if (option == null) {
            return;
        }
        this.mBlurOption = new WeakReference<PopupBlurOption>(option);
        View anchorView = option.getBlurView();
        if (anchorView == null) {
            PopupLogUtil.trace(LogTag.e, TAG, "\u6a21\u7cca\u951a\u70b9View\u4e3a\u7a7a\uff0c\u653e\u5f03\u6a21\u7cca\u64cd\u4f5c...");
            return;
        }
        if (option.isBlurAsync()) {
            PopupLogUtil.trace(LogTag.i, TAG, "\u5b50\u7ebf\u7a0bblur");
            this.startBlurTask(anchorView);
        } else {
            try {
                PopupLogUtil.trace(LogTag.i, TAG, "\u4e3b\u7ebf\u7a0bblur");
                if (!BlurHelper.renderScriptSupported()) {
                    PopupLogUtil.trace(LogTag.e, TAG, "\u4e0d\u652f\u6301\u811a\u672c\u6a21\u7cca\u3002\u3002\u3002\u6700\u4f4e\u652f\u6301api 17(Android 4.2.2)\uff0c\u5c06\u91c7\u7528fastblur");
                }
                this.setImageBitmapOnUiThread(BlurHelper.blur(this.getContext(), anchorView, option.getBlurPreScaleRatio(), option.getBlurRadius(), option.isFullScreen()));
            }
            catch (Exception e) {
                PopupLogUtil.trace(LogTag.e, TAG, "\u6a21\u7cca\u5f02\u5e38");
                e.printStackTrace();
            }
        }
    }

    PopupBlurOption getOption() {
        if (this.mBlurOption == null) {
            return null;
        }
        return (PopupBlurOption)this.mBlurOption.get();
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.abortBlur = true;
    }

    public void start(long duration) {
        this.startDuration = duration;
        if (!this.blurFinish) {
            this.postDelayed(new WaitForBlurFinishRunnalbe(), 8L);
            PopupLogUtil.trace(LogTag.v, TAG, "\u7b49\u5f85blur\u5b8c\u6210");
            return;
        }
        if (this.isAnimating) {
            return;
        }
        PopupLogUtil.trace(LogTag.i, TAG, "\u5f00\u59cb\u6a21\u7ccaimageview alpha\u52a8\u753b");
        this.isAnimating = true;
        if (duration > 0L) {
            this.animate().alpha(1.0f).setDuration(duration).setInterpolator((TimeInterpolator)new DecelerateInterpolator()).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    BlurImageView.this.isAnimating = false;
                }
            }).start();
        } else if (duration == -2L) {
            this.animate().alpha(1.0f).setDuration(this.getOption() == null ? 300L : this.getOption().getBlurInDuration()).setInterpolator((TimeInterpolator)new DecelerateInterpolator()).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    BlurImageView.this.isAnimating = false;
                }
            }).start();
        } else {
            this.setAlpha(1.0f);
        }
    }

    public void dismiss(long duration) {
        this.isAnimating = false;
        PopupLogUtil.trace(LogTag.i, TAG, "dismiss\u6a21\u7ccaimageview alpha\u52a8\u753b");
        if (duration > 0L) {
            this.animate().alpha(0.0f).setDuration(duration).setInterpolator((TimeInterpolator)new DecelerateInterpolator()).start();
        } else if (duration == -2L) {
            this.animate().alpha(0.0f).setDuration(this.getOption() == null ? 300L : this.getOption().getBlurOutDuration()).setInterpolator((TimeInterpolator)new DecelerateInterpolator()).start();
        } else {
            this.setAlpha(0.0f);
        }
    }

    private void startBlurTask(View anchorView) {
        ThreadPoolManager.execute(new CreateBlurBitmapRunnable(BlurHelper.getViewBitmap(anchorView, this.getOption().isFullScreen())));
    }

    private void setImageBitmapOnUiThread(final Bitmap blurBitmap) {
        if (blurBitmap != null) {
            PopupLogUtil.trace("blurBitmap\u4e0d\u4e3a\u7a7a");
        } else {
            PopupLogUtil.trace("blurBitmap\u4e3a\u7a7a");
        }
        if (this.isUiThread()) {
            this.handleSetImageBitmap(blurBitmap);
        } else {
            this.post(new Runnable(){

                @Override
                public void run() {
                    BlurImageView.this.handleSetImageBitmap(blurBitmap);
                }
            });
        }
    }

    private void handleSetImageBitmap(Bitmap bitmap) {
        PopupBlurOption option;
        this.setAlpha(0.0f);
        this.setImageBitmap(bitmap);
        if (this.getOption() != null && !(option = this.getOption()).isFullScreen()) {
            View anchorView = option.getBlurView();
            if (anchorView == null) {
                return;
            }
            Rect rect = new Rect();
            anchorView.getGlobalVisibleRect(rect);
            Matrix matrix = this.getImageMatrix();
            matrix.setTranslate((float)rect.left, (float)rect.top);
            this.setImageMatrix(matrix);
        }
        this.blurFinish = true;
    }

    private boolean isUiThread() {
        return Thread.currentThread() == Looper.getMainLooper().getThread();
    }

    class WaitForBlurFinishRunnalbe
    implements Runnable {
        WaitForBlurFinishRunnalbe() {
        }

        @Override
        public void run() {
            if (BlurImageView.this.blurFinish) {
                BlurImageView.this.start(BlurImageView.this.startDuration);
            } else {
                BlurImageView.this.postDelayed(this, 8L);
            }
        }
    }

    class CreateBlurBitmapRunnable
    implements Runnable {
        private Bitmap bitmap;

        CreateBlurBitmapRunnable(Bitmap bitmap) {
            this.bitmap = bitmap;
        }

        @Override
        public void run() {
            if (BlurImageView.this.abortBlur || BlurImageView.this.getOption() == null) {
                PopupLogUtil.trace(LogTag.e, BlurImageView.TAG, "\u653e\u5f03\u6a21\u7cca\uff0c\u53ef\u80fd\u662f\u5df2\u7ecf\u79fb\u9664\u4e86\u5e03\u5c40");
                return;
            }
            BlurImageView.this.setImageBitmapOnUiThread(BlurHelper.blur(BlurImageView.this.getContext(), this.bitmap, BlurImageView.this.getOption().getBlurPreScaleRatio(), BlurImageView.this.getOption().getBlurRadius()));
        }
    }
}

