/*
 * Decompiled with CFR 0.152.
 */
package razerdp.basepopup;

import android.text.TextUtils;
import android.view.Display;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import java.lang.ref.WeakReference;
import razerdp.basepopup.BasePopupHelper;
import razerdp.basepopup.HackPopupDecorView;
import razerdp.basepopup.PopupController;

final class HackWindowManager
implements WindowManager {
    private static final String TAG = "HackWindowManager";
    private WeakReference<WindowManager> mWindowManager;
    private WeakReference<PopupController> mPopupController;
    private WeakReference<HackPopupDecorView> mHackPopupDecorView;
    private WeakReference<BasePopupHelper> mPopupHelper;

    public HackWindowManager(WindowManager windowManager, PopupController popupController) {
        this.mWindowManager = new WeakReference<WindowManager>(windowManager);
        this.mPopupController = new WeakReference<PopupController>(popupController);
    }

    public Display getDefaultDisplay() {
        return this.getWindowManager() == null ? null : this.getWindowManager().getDefaultDisplay();
    }

    public void removeViewImmediate(View view) {
        if (this.getWindowManager() == null) {
            return;
        }
        if (this.checkProxyValided(view) && this.getHackPopupDecorView() != null) {
            HackPopupDecorView hackPopupDecorView = this.getHackPopupDecorView();
            this.getWindowManager().removeViewImmediate((View)hackPopupDecorView);
            hackPopupDecorView.setPopupController(null);
            this.mHackPopupDecorView.clear();
            this.mHackPopupDecorView = null;
        } else {
            this.getWindowManager().removeViewImmediate(view);
        }
    }

    public void addView(View view, ViewGroup.LayoutParams params) {
        if (this.getWindowManager() == null) {
            return;
        }
        if (this.checkProxyValided(view)) {
            params = this.applyHelper(params);
            HackPopupDecorView hackPopupDecorView = new HackPopupDecorView(view.getContext());
            this.mHackPopupDecorView = new WeakReference<HackPopupDecorView>(hackPopupDecorView);
            hackPopupDecorView.setPopupController(this.getPopupController());
            hackPopupDecorView.addView(view, params);
            this.getWindowManager().addView((View)hackPopupDecorView, params);
        } else {
            this.getWindowManager().addView(view, params);
        }
    }

    private ViewGroup.LayoutParams applyHelper(ViewGroup.LayoutParams params) {
        if (!(params instanceof WindowManager.LayoutParams) || this.getBasePopupHelper() == null) {
            return params;
        }
        WindowManager.LayoutParams p = (WindowManager.LayoutParams)params;
        BasePopupHelper helper = this.getBasePopupHelper();
        if (helper == null) {
            return params;
        }
        if (!helper.isInterceptTouchEvent()) {
            p.flags |= 0x20;
            p.flags |= 0x40000;
        }
        if (helper.isFullScreen()) {
            p.flags |= 0x100;
        }
        return p;
    }

    public void updateViewLayout(View view, ViewGroup.LayoutParams params) {
        if (this.getWindowManager() == null) {
            return;
        }
        if (this.checkProxyValided(view) && this.getHackPopupDecorView() != null) {
            HackPopupDecorView hackPopupDecorView = this.getHackPopupDecorView();
            this.getWindowManager().updateViewLayout((View)hackPopupDecorView, params);
        } else {
            this.getWindowManager().updateViewLayout(view, params);
        }
    }

    public void removeView(View view) {
        if (this.getWindowManager() == null) {
            return;
        }
        if (this.checkProxyValided(view) && this.getHackPopupDecorView() != null) {
            HackPopupDecorView hackPopupDecorView = this.getHackPopupDecorView();
            this.getWindowManager().removeView((View)hackPopupDecorView);
            hackPopupDecorView.setPopupController(null);
            this.mHackPopupDecorView.clear();
            this.mHackPopupDecorView = null;
        } else {
            this.getWindowManager().removeView(view);
        }
    }

    private boolean checkProxyValided(View v) {
        if (v == null) {
            return false;
        }
        String viewSimpleClassName = v.getClass().getSimpleName();
        return TextUtils.equals((CharSequence)viewSimpleClassName, (CharSequence)"PopupDecorView") || TextUtils.equals((CharSequence)viewSimpleClassName, (CharSequence)"PopupViewContainer");
    }

    private HackPopupDecorView getHackPopupDecorView() {
        if (this.mHackPopupDecorView == null) {
            return null;
        }
        return (HackPopupDecorView)((Object)this.mHackPopupDecorView.get());
    }

    private WindowManager getWindowManager() {
        if (this.mWindowManager == null) {
            return null;
        }
        return (WindowManager)this.mWindowManager.get();
    }

    private PopupController getPopupController() {
        if (this.mPopupController == null) {
            return null;
        }
        return (PopupController)this.mPopupController.get();
    }

    private BasePopupHelper getBasePopupHelper() {
        if (this.mPopupHelper == null) {
            return null;
        }
        return (BasePopupHelper)this.mPopupHelper.get();
    }

    void bindPopupHelper(BasePopupHelper helper) {
        this.mPopupHelper = new WeakReference<BasePopupHelper>(helper);
    }
}

