/*
 * Decompiled with CFR 0.152.
 */
package razerdp.basepopup;

import android.app.Activity;
import android.content.Context;
import android.content.ContextWrapper;
import android.os.Build;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.widget.PopupWindow;
import razerdp.basepopup.PopupController;

public class PopupWindowProxy
extends PopupWindow {
    private static final String TAG = "PopupWindowProxy";
    private final boolean isFixAndroidN = Build.VERSION.SDK_INT == 24;
    private final boolean isOverAndroidN = Build.VERSION.SDK_INT > 24;
    private static final int MAX_SCAN_ACTIVITY_COUNT = 50;
    private volatile int tryScanActivityCount = 0;
    private PopupController mController;

    public PopupWindowProxy(Context context, PopupController mController) {
        super(context);
        this.mController = mController;
    }

    public PopupWindowProxy(Context context, AttributeSet attrs, PopupController mController) {
        super(context, attrs);
        this.mController = mController;
    }

    public PopupWindowProxy(Context context, AttributeSet attrs, int defStyleAttr, PopupController mController) {
        super(context, attrs, defStyleAttr);
        this.mController = mController;
    }

    public PopupWindowProxy(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes, PopupController mController) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.mController = mController;
    }

    public PopupWindowProxy(PopupController mController) {
        this.mController = mController;
    }

    public PopupWindowProxy(View contentView, PopupController mController) {
        super(contentView);
        this.mController = mController;
    }

    public PopupWindowProxy(int width, int height, PopupController mController) {
        super(width, height);
        this.mController = mController;
    }

    public PopupWindowProxy(View contentView, int width, int height, PopupController mController) {
        super(contentView, width, height);
        this.mController = mController;
    }

    public PopupWindowProxy(View contentView, int width, int height, boolean focusable, PopupController mController) {
        super(contentView, width, height, focusable);
        this.mController = mController;
    }

    public void showAsDropDown(View anchor, int xoff, int yoff, int gravity) {
        if (this.isFixAndroidN && anchor != null) {
            int[] anchorLocation = new int[2];
            anchor.getLocationInWindow(anchorLocation);
            Activity activity = this.scanForActivity(anchor.getContext());
            if (activity == null) {
                Log.e((String)TAG, (String)"please make sure that context is instance of activity");
                return;
            }
            xoff = anchorLocation[0] + xoff;
            yoff = anchorLocation[1] + anchor.getHeight() + yoff;
            this.setFocusable(false);
            super.showAtLocation(activity.getWindow().getDecorView(), 0, xoff, yoff);
            this.initSystemBar(this.getContentView());
            this.setFocusable(true);
            this.update();
        } else {
            if (this.isOverAndroidN) {
                this.setHeight(-2);
            }
            this.setFocusable(false);
            super.showAsDropDown(anchor, xoff, yoff, gravity);
            this.initSystemBar(this.getContentView());
            this.setFocusable(true);
            this.update();
        }
    }

    public void showAtLocation(View parent, int gravity, int x, int y) {
        this.setFocusable(false);
        super.showAtLocation(parent, gravity, x, y);
        this.initSystemBar(this.getContentView());
        this.setFocusable(true);
        this.update();
    }

    private Activity scanForActivity(Context cont) {
        if (cont == null) {
            return null;
        }
        if (cont instanceof Activity) {
            return (Activity)cont;
        }
        if (cont instanceof ContextWrapper) {
            if (this.tryScanActivityCount > 50) {
                return null;
            }
            ++this.tryScanActivityCount;
            return this.scanForActivity(((ContextWrapper)cont).getBaseContext());
        }
        return null;
    }

    void initSystemBar(View view) {
        try {
            if (Build.VERSION.SDK_INT >= 19) {
                boolean isFullScreen;
                int uiOptions = 5894;
                boolean bl = isFullScreen = view.getSystemUiVisibility() == uiOptions;
                if (isFullScreen) {
                    this.hideSystemUI(view);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void hideSystemUI(View view) {
        if (view == null) {
            return;
        }
        try {
            if (Build.VERSION.SDK_INT >= 19) {
                int uiOptions = 5894;
                view.setSystemUiVisibility(uiOptions);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void showSystemUI(View view) {
        try {
            if (Build.VERSION.SDK_INT >= 19) {
                int uiOptions = 1792;
                view.setSystemUiVisibility(uiOptions);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void dismiss() {
        if (this.mController == null) {
            return;
        }
        boolean performDismiss = this.mController.onBeforeDismiss();
        if (!performDismiss) {
            return;
        }
        boolean dismissAtOnce = this.mController.callDismissAtOnce();
        if (dismissAtOnce) {
            this.callSuperDismiss();
        }
    }

    void callSuperDismiss() {
        super.dismiss();
    }
}

