/*
 * Decompiled with CFR 0.152.
 */
package com.apt7.rxpermissions;

import android.os.Build;
import java.util.ArrayList;
import java.util.List;

public class PermissionsIgnoreList {
    private static PermissionsIgnoreList permissionsIgnoreList;
    private List<String> permissionsList = new ArrayList<String>();

    public static PermissionsIgnoreList getInstance() {
        if (permissionsIgnoreList == null) {
            permissionsIgnoreList = new PermissionsIgnoreList();
        }
        return permissionsIgnoreList;
    }

    private PermissionsIgnoreList() {
        this.setUp();
    }

    private void setUp() {
        this.permissionsList.clear();
        if (Build.VERSION.SDK_INT > 23) {
            this.permissionsList.add("android.permission.GET_ACCOUNTS");
        }
        this.permissionsList.add("android.permission.ACCESS_LOCATION_EXTRA_COMMANDS");
        this.permissionsList.add("android.permission.ACCESS_NETWORK_STATE");
        this.permissionsList.add("android.permission.ACCESS_NOTIFICATION_POLICY");
        this.permissionsList.add("android.permission.ACCESS_WIFI_STATE");
        this.permissionsList.add("android.permission.ACCESS_WIMAX_STATE");
        this.permissionsList.add("android.permission.BLUETOOTH");
        this.permissionsList.add("android.permission.BLUETOOTH_ADMIN");
        this.permissionsList.add("android.permission.BROADCAST_STICKY");
        this.permissionsList.add("android.permission.CHANGE_NETWORK_STATE");
        this.permissionsList.add("android.permission.CHANGE_WIFI_MULTICAST_STATE");
        this.permissionsList.add("android.permission.CHANGE_WIFI_STATE");
        this.permissionsList.add("android.permission.CHANGE_WIMAX_STATE");
        this.permissionsList.add("android.permission.DISABLE_KEYGUARD");
        this.permissionsList.add("android.permission.EXPAND_STATUS_BAR");
        this.permissionsList.add("android.permission.FLASHLIGHT");
        this.permissionsList.add("android.permission.GET_PACKAGE_SIZE");
        this.permissionsList.add("android.permission.INTERNET");
        this.permissionsList.add("android.permission.KILL_BACKGROUND_PROCESSES");
        this.permissionsList.add("android.permission.MODIFY_AUDIO_SETTINGS");
        this.permissionsList.add("android.permission.NFC");
        this.permissionsList.add("android.permission.READ_SYNC_SETTINGS");
        this.permissionsList.add("android.permission.READ_SYNC_STATS");
        this.permissionsList.add("android.permission.RECEIVE_BOOT_COMPLETED");
        this.permissionsList.add("android.permission.REORDER_TASKS");
        this.permissionsList.add("android.permission.REQUEST_INSTALL_PACKAGES");
        this.permissionsList.add("android.permission.SET_TIME_ZONE");
        this.permissionsList.add("android.permission.SET_WALLPAPER");
        this.permissionsList.add("android.permission.SET_WALLPAPER_HINTS");
        this.permissionsList.add("android.permission.SUBSCRIBED_FEEDS_READ");
        this.permissionsList.add("android.permission.TRANSMIT_IR");
        this.permissionsList.add("android.permission.USE_FINGERPRINT");
        this.permissionsList.add("android.permission.VIBRATE");
        this.permissionsList.add("android.permission.WAKE_LOCK");
        this.permissionsList.add("android.permission.WRITE_SYNC_SETTINGS");
        this.permissionsList.add("com.android.alarm.permission.SET_ALARM");
        this.permissionsList.add("com.android.launcher.permission.INSTALL_SHORTCUT");
        this.permissionsList.add("com.android.launcher.permission.UNINSTALL_SHORTCUT");
    }

    public boolean validate(String permission) {
        if (permission == null) {
            throw new NullPointerException("Permission cant be null");
        }
        return !this.permissionsList.contains(permission);
    }

    public List<String> validate(List<String> pList) {
        if (pList == null) {
            throw new NullPointerException("List cant be null");
        }
        ArrayList<String> processedList = new ArrayList<String>();
        for (String permission : pList) {
            if (permission == null || this.permissionsList.contains(permission)) continue;
            processedList.add(permission);
        }
        return processedList;
    }
}

