/*
 * Decompiled with CFR 0.152.
 */
package com.amulyakhare.textdrawable;

import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Typeface;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.OvalShape;
import android.graphics.drawable.shapes.RectShape;
import android.graphics.drawable.shapes.RoundRectShape;
import android.graphics.drawable.shapes.Shape;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 #2\u00020\u0001:\u0005\"#$%&B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0010\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\bH\u0002J\b\u0010\u001a\u001a\u00020\bH\u0016J\b\u0010\u001b\u001a\u00020\bH\u0016J\b\u0010\u001c\u001a\u00020\bH\u0016J\u0010\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\bH\u0016J\u0012\u0010\u001f\u001a\u00020\u00142\b\u0010 \u001a\u0004\u0018\u00010!H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/amulyakhare/textdrawable/TextDrawable;", "Landroid/graphics/drawable/ShapeDrawable;", "builder", "Lcom/amulyakhare/textdrawable/TextDrawable$Builder;", "(Lcom/amulyakhare/textdrawable/TextDrawable$Builder;)V", "borderPaint", "Landroid/graphics/Paint;", "borderThickness", "", "fontSize", "height", "radius", "", "shape", "Landroid/graphics/drawable/shapes/RectShape;", "text", "", "textPaint", "width", "draw", "", "canvas", "Landroid/graphics/Canvas;", "drawBorder", "getDarkerShade", "color", "getIntrinsicHeight", "getIntrinsicWidth", "getOpacity", "setAlpha", "alpha", "setColorFilter", "cf", "Landroid/graphics/ColorFilter;", "Builder", "Companion", "IBuilder", "IConfigBuilder", "IShapeBuilder", "library_release"})
public final class TextDrawable
extends ShapeDrawable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Paint textPaint;
    @NotNull
    private final Paint borderPaint;
    @NotNull
    private final String text;
    @NotNull
    private final RectShape shape;
    private final int height;
    private final int width;
    private final int fontSize;
    private final float radius;
    private final int borderThickness;
    private static final float SHADE_FACTOR = 0.9f;

    public TextDrawable(@NotNull Builder builder) {
        String string;
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        super((Shape)builder.getShape());
        this.shape = builder.getShape();
        this.height = builder.getHeight();
        this.width = builder.getWidth();
        this.radius = builder.getRadius();
        if (builder.getToUpperCase()) {
            String string2 = builder.getText();
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault()");
            boolean bl = false;
            String string3 = string2;
            if (string3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.toUpperCase(locale);
            string = string4;
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).toUpperCase(locale)");
        } else {
            string = builder.getText();
        }
        this.text = string;
        int color = builder.getColor();
        this.fontSize = builder.getFontSize();
        this.textPaint = new Paint();
        this.textPaint.setColor(builder.getTextColor());
        this.textPaint.setAntiAlias(true);
        this.textPaint.setFakeBoldText(builder.isBold());
        this.textPaint.setStyle(Paint.Style.FILL);
        this.textPaint.setTypeface(builder.getFont());
        this.textPaint.setTextAlign(Paint.Align.CENTER);
        this.textPaint.setStrokeWidth((float)builder.getBorderThickness());
        this.borderThickness = builder.getBorderThickness();
        this.borderPaint = new Paint();
        this.borderPaint.setColor(this.getDarkerShade(color));
        this.borderPaint.setStyle(Paint.Style.STROKE);
        this.borderPaint.setStrokeWidth((float)this.borderThickness);
        Paint paint = this.getPaint();
        paint.setColor(color);
    }

    private final int getDarkerShade(int color) {
        return Color.rgb((int)((int)(0.9f * (float)Color.red((int)color))), (int)((int)(0.9f * (float)Color.green((int)color))), (int)((int)(0.9f * (float)Color.blue((int)color))));
    }

    public void draw(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        super.draw(canvas);
        Rect rect = this.getBounds();
        Intrinsics.checkNotNullExpressionValue((Object)rect, (String)"bounds");
        Rect r = rect;
        if (this.borderThickness > 0) {
            this.drawBorder(canvas);
        }
        int count = canvas.save();
        canvas.translate((float)r.left, (float)r.top);
        int width = this.width < 0 ? r.width() : this.width;
        int height = this.height < 0 ? r.height() : this.height;
        int fontSize = this.fontSize < 0 ? Math.min(width, height) / 2 : this.fontSize;
        this.textPaint.setTextSize((float)fontSize);
        canvas.drawText(this.text, (float)(width / 2), (float)(height / 2) - (this.textPaint.descent() + this.textPaint.ascent()) / (float)2, this.textPaint);
        canvas.restoreToCount(count);
    }

    private final void drawBorder(Canvas canvas) {
        RectF rect = new RectF(this.getBounds());
        rect.inset((float)(this.borderThickness / 2), (float)(this.borderThickness / 2));
        if (this.shape instanceof OvalShape) {
            canvas.drawOval(rect, this.borderPaint);
        } else if (this.shape instanceof RoundRectShape) {
            canvas.drawRoundRect(rect, this.radius, this.radius, this.borderPaint);
        } else {
            canvas.drawRect(rect, this.borderPaint);
        }
    }

    public void setAlpha(int alpha) {
        this.textPaint.setAlpha(alpha);
    }

    public void setColorFilter(@Nullable ColorFilter cf) {
        this.textPaint.setColorFilter(cf);
    }

    public int getOpacity() {
        return -3;
    }

    public int getIntrinsicWidth() {
        return this.width;
    }

    public int getIntrinsicHeight() {
        return this.height;
    }

    @JvmStatic
    @NotNull
    public static final IShapeBuilder builder() {
        return Companion.builder();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0005\u00a2\u0006\u0002\u0010\u0004J\b\u0010:\u001a\u00020\u0001H\u0016J\b\u0010;\u001a\u00020\u0001H\u0016J\u0018\u0010<\u001a\u00020=2\u0006\u0010+\u001a\u00020,2\u0006\u0010\u000b\u001a\u00020\u0006H\u0016J\u0018\u0010>\u001a\u00020=2\u0006\u0010+\u001a\u00020,2\u0006\u0010\u000b\u001a\u00020\u0006H\u0016J\u0018\u0010?\u001a\u00020=2\u0006\u0010+\u001a\u00020,2\u0006\u0010\u000b\u001a\u00020\u0006H\u0016J \u0010@\u001a\u00020=2\u0006\u0010+\u001a\u00020,2\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\u001f\u001a\u00020\u0006H\u0016J\b\u0010A\u001a\u00020\u0002H\u0016J\u0010\u0010\u0014\u001a\u00020\u00012\u0006\u0010B\u001a\u00020\u0006H\u0016J\u0010\u0010\u0017\u001a\u00020\u00012\u0006\u0010\u0017\u001a\u00020\u0006H\u0016J\b\u0010C\u001a\u00020\u0003H\u0016J\b\u0010D\u001a\u00020\u0003H\u0016J\u0010\u0010E\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020\u0006H\u0016J\u0010\u00101\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\u0006H\u0016J\b\u00104\u001a\u00020\u0001H\u0016J\u0010\u0010F\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u00107\u001a\u00020\u00012\u0006\u00107\u001a\u00020\u0006H\u0016J\u0010\u0010G\u001a\u00020\u00012\u0006\u0010H\u001a\u00020\u0006H\u0016R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\b\"\u0004\b\r\u0010\nR\u001a\u0010\u000e\u001a\u00020\u000fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\b\"\u0004\b\u0016\u0010\nR\u001a\u0010\u0017\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\b\"\u0004\b\u0019\u0010\nR\u001a\u0010\u001a\u001a\u00020\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\u001a\u0010\u001f\u001a\u00020 X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\"\"\u0004\b#\u0010$R\u001a\u0010%\u001a\u00020&X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\u001a\u0010+\u001a\u00020,X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010.\"\u0004\b/\u00100R\u001a\u00101\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u0010\b\"\u0004\b3\u0010\nR\u001a\u00104\u001a\u00020\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u0010\u001c\"\u0004\b6\u0010\u001eR\u001a\u00107\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b8\u0010\b\"\u0004\b9\u0010\n\u00a8\u0006I"}, d2={"Lcom/amulyakhare/textdrawable/TextDrawable$Builder;", "Lcom/amulyakhare/textdrawable/TextDrawable$IConfigBuilder;", "Lcom/amulyakhare/textdrawable/TextDrawable$IShapeBuilder;", "Lcom/amulyakhare/textdrawable/TextDrawable$IBuilder;", "()V", "borderThickness", "", "getBorderThickness", "()I", "setBorderThickness", "(I)V", "color", "getColor", "setColor", "font", "Landroid/graphics/Typeface;", "getFont", "()Landroid/graphics/Typeface;", "setFont", "(Landroid/graphics/Typeface;)V", "fontSize", "getFontSize", "setFontSize", "height", "getHeight", "setHeight", "isBold", "", "()Z", "setBold", "(Z)V", "radius", "", "getRadius", "()F", "setRadius", "(F)V", "shape", "Landroid/graphics/drawable/shapes/RectShape;", "getShape", "()Landroid/graphics/drawable/shapes/RectShape;", "setShape", "(Landroid/graphics/drawable/shapes/RectShape;)V", "text", "", "getText", "()Ljava/lang/String;", "setText", "(Ljava/lang/String;)V", "textColor", "getTextColor", "setTextColor", "toUpperCase", "getToUpperCase", "setToUpperCase", "width", "getWidth", "setWidth", "beginConfig", "bold", "build", "Lcom/amulyakhare/textdrawable/TextDrawable;", "buildRect", "buildRound", "buildRoundRect", "endConfig", "size", "rect", "round", "roundRect", "useFont", "withBorder", "thickness", "library_release"})
    public static final class Builder
    implements IConfigBuilder,
    IShapeBuilder,
    IBuilder {
        @NotNull
        private String text = "";
        private int color = -7829368;
        private int borderThickness = 0;
        private int width = -1;
        private int height = -1;
        @NotNull
        private Typeface font;
        @NotNull
        private RectShape shape = new RectShape();
        private int textColor = -1;
        private int fontSize;
        private boolean isBold;
        private boolean toUpperCase;
        private float radius;

        public Builder() {
            Typeface typeface = Typeface.create((String)"sans-serif-light", (int)0);
            Intrinsics.checkNotNullExpressionValue((Object)typeface, (String)"create(\"sans-serif-light\", Typeface.NORMAL)");
            this.font = typeface;
            this.fontSize = -1;
            this.isBold = false;
            this.toUpperCase = false;
        }

        @NotNull
        public final String getText() {
            return this.text;
        }

        public final void setText(@NotNull String string) {
            Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
            this.text = string;
        }

        public final int getColor() {
            return this.color;
        }

        public final void setColor(int n) {
            this.color = n;
        }

        public final int getBorderThickness() {
            return this.borderThickness;
        }

        public final void setBorderThickness(int n) {
            this.borderThickness = n;
        }

        public final int getWidth() {
            return this.width;
        }

        public final void setWidth(int n) {
            this.width = n;
        }

        public final int getHeight() {
            return this.height;
        }

        public final void setHeight(int n) {
            this.height = n;
        }

        @NotNull
        public final Typeface getFont() {
            return this.font;
        }

        public final void setFont(@NotNull Typeface typeface) {
            Intrinsics.checkNotNullParameter((Object)typeface, (String)"<set-?>");
            this.font = typeface;
        }

        @NotNull
        public final RectShape getShape() {
            return this.shape;
        }

        public final void setShape(@NotNull RectShape rectShape) {
            Intrinsics.checkNotNullParameter((Object)rectShape, (String)"<set-?>");
            this.shape = rectShape;
        }

        public final int getTextColor() {
            return this.textColor;
        }

        public final void setTextColor(int n) {
            this.textColor = n;
        }

        public final int getFontSize() {
            return this.fontSize;
        }

        public final void setFontSize(int n) {
            this.fontSize = n;
        }

        public final boolean isBold() {
            return this.isBold;
        }

        public final void setBold(boolean bl) {
            this.isBold = bl;
        }

        public final boolean getToUpperCase() {
            return this.toUpperCase;
        }

        public final void setToUpperCase(boolean bl) {
            this.toUpperCase = bl;
        }

        public final float getRadius() {
            return this.radius;
        }

        public final void setRadius(float f) {
            this.radius = f;
        }

        @Override
        @NotNull
        public IConfigBuilder width(int width) {
            this.width = width;
            return this;
        }

        @Override
        @NotNull
        public IConfigBuilder height(int height) {
            this.height = height;
            return this;
        }

        @Override
        @NotNull
        public IConfigBuilder textColor(int color) {
            this.textColor = color;
            return this;
        }

        @Override
        @NotNull
        public IConfigBuilder withBorder(int thickness) {
            this.borderThickness = thickness;
            return this;
        }

        @Override
        @NotNull
        public IConfigBuilder useFont(@NotNull Typeface font) {
            Intrinsics.checkNotNullParameter((Object)font, (String)"font");
            this.font = font;
            return this;
        }

        @Override
        @NotNull
        public IConfigBuilder fontSize(int size) {
            this.fontSize = size;
            return this;
        }

        @Override
        @NotNull
        public IConfigBuilder bold() {
            this.isBold = true;
            return this;
        }

        @Override
        @NotNull
        public IConfigBuilder toUpperCase() {
            this.toUpperCase = true;
            return this;
        }

        @Override
        @NotNull
        public IConfigBuilder beginConfig() {
            return this;
        }

        @Override
        @NotNull
        public IShapeBuilder endConfig() {
            return this;
        }

        @Override
        @NotNull
        public IBuilder rect() {
            this.shape = new RectShape();
            return this;
        }

        @Override
        @NotNull
        public IBuilder round() {
            this.shape = (RectShape)new OvalShape();
            return this;
        }

        @Override
        @NotNull
        public IBuilder roundRect(int radius) {
            this.radius = radius;
            float[] fArray = new float[]{radius, radius, radius, radius, radius, radius, radius, radius};
            float[] radii = fArray;
            this.shape = (RectShape)new RoundRectShape(radii, null, null);
            return this;
        }

        @Override
        @NotNull
        public TextDrawable buildRect(@NotNull String text, int color) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            this.rect();
            return this.build(text, color);
        }

        @Override
        @NotNull
        public TextDrawable buildRoundRect(@NotNull String text, int color, int radius) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            this.roundRect(radius);
            return this.build(text, color);
        }

        @Override
        @NotNull
        public TextDrawable buildRound(@NotNull String text, int color) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            this.round();
            return this.build(text, color);
        }

        @Override
        @NotNull
        public TextDrawable build(@NotNull String text, int color) {
            Intrinsics.checkNotNullParameter((Object)text, (String)"text");
            this.color = color;
            this.text = text;
            return new TextDrawable(this);
        }
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0000H&J\b\u0010\u0003\u001a\u00020\u0004H&J\u0010\u0010\u0005\u001a\u00020\u00002\u0006\u0010\u0006\u001a\u00020\u0007H&J\u0010\u0010\b\u001a\u00020\u00002\u0006\u0010\b\u001a\u00020\u0007H&J\u0010\u0010\t\u001a\u00020\u00002\u0006\u0010\n\u001a\u00020\u0007H&J\b\u0010\u000b\u001a\u00020\u0000H&J\u0010\u0010\f\u001a\u00020\u00002\u0006\u0010\r\u001a\u00020\u000eH&J\u0010\u0010\u000f\u001a\u00020\u00002\u0006\u0010\u000f\u001a\u00020\u0007H&J\u0010\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0007H&\u00a8\u0006\u0012"}, d2={"Lcom/amulyakhare/textdrawable/TextDrawable$IConfigBuilder;", "", "bold", "endConfig", "Lcom/amulyakhare/textdrawable/TextDrawable$IShapeBuilder;", "fontSize", "size", "", "height", "textColor", "color", "toUpperCase", "useFont", "font", "Landroid/graphics/Typeface;", "width", "withBorder", "thickness", "library_release"})
    public static interface IConfigBuilder {
        @NotNull
        public IConfigBuilder width(int var1);

        @NotNull
        public IConfigBuilder height(int var1);

        @NotNull
        public IConfigBuilder textColor(int var1);

        @NotNull
        public IConfigBuilder withBorder(int var1);

        @NotNull
        public IConfigBuilder useFont(@NotNull Typeface var1);

        @NotNull
        public IConfigBuilder fontSize(int var1);

        @NotNull
        public IConfigBuilder bold();

        @NotNull
        public IConfigBuilder toUpperCase();

        @NotNull
        public IShapeBuilder endConfig();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&\u00a8\u0006\b"}, d2={"Lcom/amulyakhare/textdrawable/TextDrawable$IBuilder;", "", "build", "Lcom/amulyakhare/textdrawable/TextDrawable;", "text", "", "color", "", "library_release"})
    public static interface IBuilder {
        @NotNull
        public TextDrawable build(@NotNull String var1, int var2);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\bf\u0018\u00002\u00020\u0001J\b\u0010\u0002\u001a\u00020\u0003H&J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH&J\u0018\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH&J \u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\tH&J\b\u0010\r\u001a\u00020\u000eH&J\b\u0010\u000f\u001a\u00020\u000eH&J\u0010\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\f\u001a\u00020\tH&\u00a8\u0006\u0011"}, d2={"Lcom/amulyakhare/textdrawable/TextDrawable$IShapeBuilder;", "", "beginConfig", "Lcom/amulyakhare/textdrawable/TextDrawable$IConfigBuilder;", "buildRect", "Lcom/amulyakhare/textdrawable/TextDrawable;", "text", "", "color", "", "buildRound", "buildRoundRect", "radius", "rect", "Lcom/amulyakhare/textdrawable/TextDrawable$IBuilder;", "round", "roundRect", "library_release"})
    public static interface IShapeBuilder {
        @NotNull
        public IConfigBuilder beginConfig();

        @NotNull
        public IBuilder rect();

        @NotNull
        public IBuilder round();

        @NotNull
        public IBuilder roundRect(int var1);

        @NotNull
        public TextDrawable buildRect(@NotNull String var1, int var2);

        @NotNull
        public TextDrawable buildRoundRect(@NotNull String var1, int var2, int var3);

        @NotNull
        public TextDrawable buildRound(@NotNull String var1, int var2);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0006H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/amulyakhare/textdrawable/TextDrawable$Companion;", "", "()V", "SHADE_FACTOR", "", "builder", "Lcom/amulyakhare/textdrawable/TextDrawable$IShapeBuilder;", "library_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final IShapeBuilder builder() {
            return new Builder();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

