/*
 * Decompiled with CFR 0.152.
 */
package ru.rambler.libs.swipe_layout;

import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.content.res.TypedArray;
import android.support.v4.view.NestedScrollingParent;
import android.support.v4.view.ViewCompat;
import android.support.v4.widget.ViewDragHelper;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.animation.AccelerateInterpolator;
import com.rds.swipelayout.R;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.WeakHashMap;

public class SwipeLayout
extends ViewGroup {
    private static final String TAG = SwipeLayout.class.getSimpleName();
    private static final float VELOCITY_THRESHOLD = 1500.0f;
    private ViewDragHelper dragHelper;
    private View leftView;
    private View rightView;
    private View centerView;
    private float velocityThreshold;
    private float touchSlop;
    private OnSwipeListener swipeListener;
    private WeakReference<ObjectAnimator> resetAnimator;
    private final Map<View, Boolean> hackedParents = new WeakHashMap<View, Boolean>();
    private boolean swipeEnabled;
    private static final int TOUCH_STATE_WAIT = 0;
    private static final int TOUCH_STATE_SWIPE = 1;
    private static final int TOUCH_STATE_SKIP = 2;
    private int touchState = 0;
    private float touchX;
    private float touchY;
    private final ViewDragHelper.Callback dragCallback = new ViewDragHelper.Callback(){
        private int initLeft;

        public boolean tryCaptureView(View child, int pointerId) {
            this.initLeft = child.getLeft();
            return true;
        }

        public int clampViewPositionHorizontal(View child, int left, int dx) {
            if (dx > 0) {
                return this.clampMoveRight(child, left);
            }
            return this.clampMoveLeft(child, left);
        }

        public int getViewHorizontalDragRange(View child) {
            return SwipeLayout.this.getWidth();
        }

        public void onViewReleased(View releasedChild, float xvel, float yvel) {
            Log.d((String)TAG, (String)("VELOCITY " + xvel + "; THRESHOLD " + SwipeLayout.this.velocityThreshold));
            int dx = releasedChild.getLeft() - this.initLeft;
            if (dx == 0) {
                return;
            }
            boolean handled = false;
            if (dx > 0) {
                handled = xvel >= 0.0f ? this.onMoveRightReleased(releasedChild, dx, xvel) : this.onMoveLeftReleased(releasedChild, dx, xvel);
            } else if (dx < 0) {
                boolean bl = handled = xvel <= 0.0f ? this.onMoveLeftReleased(releasedChild, dx, xvel) : this.onMoveRightReleased(releasedChild, dx, xvel);
            }
            if (!handled) {
                SwipeLayout.this.startScrollAnimation(releasedChild, releasedChild.getLeft() - SwipeLayout.this.centerView.getLeft(), false, dx > 0);
            }
        }

        private boolean leftViewClampReached(LayoutParams leftViewLP) {
            if (SwipeLayout.this.leftView == null) {
                return false;
            }
            switch (leftViewLP.clamp) {
                case -1: {
                    return SwipeLayout.this.leftView.getRight() >= SwipeLayout.this.getWidth();
                }
                case -2: {
                    return SwipeLayout.this.leftView.getRight() >= SwipeLayout.this.leftView.getWidth();
                }
            }
            return SwipeLayout.this.leftView.getRight() >= leftViewLP.clamp;
        }

        private boolean rightViewClampReached(LayoutParams lp) {
            if (SwipeLayout.this.rightView == null) {
                return false;
            }
            switch (lp.clamp) {
                case -1: {
                    return SwipeLayout.this.rightView.getRight() <= SwipeLayout.this.getWidth();
                }
                case -2: {
                    return SwipeLayout.this.rightView.getRight() <= SwipeLayout.this.getWidth();
                }
            }
            return SwipeLayout.this.rightView.getLeft() + lp.clamp <= SwipeLayout.this.getWidth();
        }

        public void onViewPositionChanged(View changedView, int left, int top, int dx, int dy) {
            SwipeLayout.this.offsetChildren(changedView, dx);
            if (SwipeLayout.this.swipeListener == null) {
                return;
            }
            if (dx > 0) {
                int stickyBound;
                if (SwipeLayout.this.leftView != null && (stickyBound = this.getStickyBound(SwipeLayout.this.leftView)) != -2 && SwipeLayout.this.leftView.getRight() - stickyBound > 0 && SwipeLayout.this.leftView.getRight() - stickyBound - dx <= 0) {
                    SwipeLayout.this.swipeListener.onLeftStickyEdge(SwipeLayout.this, true);
                }
                if (SwipeLayout.this.rightView != null && (stickyBound = this.getStickyBound(SwipeLayout.this.rightView)) != -2 && SwipeLayout.this.rightView.getLeft() + stickyBound > SwipeLayout.this.getWidth() && SwipeLayout.this.rightView.getLeft() + stickyBound - dx <= SwipeLayout.this.getWidth()) {
                    SwipeLayout.this.swipeListener.onRightStickyEdge(SwipeLayout.this, true);
                }
            } else if (dx < 0) {
                int stickyBound;
                if (SwipeLayout.this.leftView != null && (stickyBound = this.getStickyBound(SwipeLayout.this.leftView)) != -2 && SwipeLayout.this.leftView.getRight() - stickyBound <= 0 && SwipeLayout.this.leftView.getRight() - stickyBound - dx > 0) {
                    SwipeLayout.this.swipeListener.onLeftStickyEdge(SwipeLayout.this, false);
                }
                if (SwipeLayout.this.rightView != null && (stickyBound = this.getStickyBound(SwipeLayout.this.rightView)) != -2 && SwipeLayout.this.rightView.getLeft() + stickyBound <= SwipeLayout.this.getWidth() && SwipeLayout.this.rightView.getLeft() + stickyBound - dx > SwipeLayout.this.getWidth()) {
                    SwipeLayout.this.swipeListener.onRightStickyEdge(SwipeLayout.this, false);
                }
            }
        }

        private int getStickyBound(View view) {
            LayoutParams lp = SwipeLayout.this.getLayoutParams(view);
            if (lp.sticky == -2) {
                return -2;
            }
            return lp.sticky == -1 ? view.getWidth() : lp.sticky;
        }

        private int clampMoveRight(View child, int left) {
            if (SwipeLayout.this.leftView == null) {
                return child == SwipeLayout.this.centerView ? Math.min(left, 0) : Math.min(left, SwipeLayout.this.getWidth());
            }
            LayoutParams lp = SwipeLayout.this.getLayoutParams(SwipeLayout.this.leftView);
            switch (lp.clamp) {
                case -1: {
                    return Math.min(left, SwipeLayout.this.getWidth() + child.getLeft() - SwipeLayout.this.leftView.getRight());
                }
                case -2: {
                    return Math.min(left, child.getLeft() - SwipeLayout.this.leftView.getLeft());
                }
            }
            return Math.min(left, child.getLeft() - SwipeLayout.this.leftView.getRight() + lp.clamp);
        }

        private int clampMoveLeft(View child, int left) {
            if (SwipeLayout.this.rightView == null) {
                return child == SwipeLayout.this.centerView ? Math.max(left, 0) : Math.max(left, -child.getWidth());
            }
            LayoutParams lp = SwipeLayout.this.getLayoutParams(SwipeLayout.this.rightView);
            switch (lp.clamp) {
                case -1: {
                    return Math.max(child.getLeft() - SwipeLayout.this.rightView.getLeft(), left);
                }
                case -2: {
                    return Math.max(left, SwipeLayout.this.getWidth() - SwipeLayout.this.rightView.getLeft() + child.getLeft() - SwipeLayout.this.rightView.getWidth());
                }
            }
            return Math.max(left, SwipeLayout.this.getWidth() - SwipeLayout.this.rightView.getLeft() + child.getLeft() - lp.clamp);
        }

        private boolean onMoveRightReleased(View child, int dx, float xvel) {
            int stickyBound;
            float amplitude;
            if (xvel > SwipeLayout.this.velocityThreshold) {
                int left = SwipeLayout.this.centerView.getLeft() < 0 ? child.getLeft() - SwipeLayout.this.centerView.getLeft() : SwipeLayout.this.getWidth();
                boolean moveToOriginal = SwipeLayout.this.centerView.getLeft() < 0;
                SwipeLayout.this.startScrollAnimation(child, this.clampMoveRight(child, left), !moveToOriginal, true);
                return true;
            }
            if (SwipeLayout.this.leftView == null) {
                SwipeLayout.this.startScrollAnimation(child, child.getLeft() - SwipeLayout.this.centerView.getLeft(), false, true);
                return true;
            }
            LayoutParams lp = SwipeLayout.this.getLayoutParams(SwipeLayout.this.leftView);
            if (dx > 0 && xvel >= 0.0f && this.leftViewClampReached(lp)) {
                if (SwipeLayout.this.swipeListener != null) {
                    SwipeLayout.this.swipeListener.onSwipeClampReached(SwipeLayout.this, true);
                }
                return true;
            }
            if (dx > 0 && xvel >= 0.0f && lp.bringToClamp != -1 && SwipeLayout.this.leftView.getRight() > lp.bringToClamp) {
                int left = SwipeLayout.this.centerView.getLeft() < 0 ? child.getLeft() - SwipeLayout.this.centerView.getLeft() : SwipeLayout.this.getWidth();
                SwipeLayout.this.startScrollAnimation(child, this.clampMoveRight(child, left), true, true);
                return true;
            }
            if (lp.sticky != -2 && this.isBetween(-(amplitude = (float)(stickyBound = lp.sticky == -1 ? SwipeLayout.this.leftView.getWidth() : lp.sticky) * lp.stickySensitivity), amplitude, SwipeLayout.this.centerView.getLeft() - stickyBound)) {
                boolean toClamp = lp.clamp == -2 && stickyBound == SwipeLayout.this.leftView.getWidth() || lp.clamp == stickyBound || lp.clamp == -1 && stickyBound == SwipeLayout.this.getWidth();
                SwipeLayout.this.startScrollAnimation(child, child.getLeft() - SwipeLayout.this.centerView.getLeft() + stickyBound, toClamp, true);
                return true;
            }
            return false;
        }

        private boolean onMoveLeftReleased(View child, int dx, float xvel) {
            int stickyBound;
            float amplitude;
            if (-xvel > SwipeLayout.this.velocityThreshold) {
                int left = SwipeLayout.this.centerView.getLeft() > 0 ? child.getLeft() - SwipeLayout.this.centerView.getLeft() : -SwipeLayout.this.getWidth();
                boolean moveToOriginal = SwipeLayout.this.centerView.getLeft() > 0;
                SwipeLayout.this.startScrollAnimation(child, this.clampMoveLeft(child, left), !moveToOriginal, false);
                return true;
            }
            if (SwipeLayout.this.rightView == null) {
                SwipeLayout.this.startScrollAnimation(child, child.getLeft() - SwipeLayout.this.centerView.getLeft(), false, false);
                return true;
            }
            LayoutParams lp = SwipeLayout.this.getLayoutParams(SwipeLayout.this.rightView);
            if (dx < 0 && xvel <= 0.0f && this.rightViewClampReached(lp)) {
                if (SwipeLayout.this.swipeListener != null) {
                    SwipeLayout.this.swipeListener.onSwipeClampReached(SwipeLayout.this, false);
                }
                return true;
            }
            if (dx < 0 && xvel <= 0.0f && lp.bringToClamp != -1 && SwipeLayout.this.rightView.getLeft() + lp.bringToClamp < SwipeLayout.this.getWidth()) {
                int left = SwipeLayout.this.centerView.getLeft() > 0 ? child.getLeft() - SwipeLayout.this.centerView.getLeft() : -SwipeLayout.this.getWidth();
                SwipeLayout.this.startScrollAnimation(child, this.clampMoveLeft(child, left), true, false);
                return true;
            }
            if (lp.sticky != -2 && this.isBetween(-(amplitude = (float)(stickyBound = lp.sticky == -1 ? SwipeLayout.this.rightView.getWidth() : lp.sticky) * lp.stickySensitivity), amplitude, SwipeLayout.this.centerView.getRight() + stickyBound - SwipeLayout.this.getWidth())) {
                boolean toClamp = lp.clamp == -2 && stickyBound == SwipeLayout.this.rightView.getWidth() || lp.clamp == stickyBound || lp.clamp == -1 && stickyBound == SwipeLayout.this.getWidth();
                SwipeLayout.this.startScrollAnimation(child, child.getLeft() - SwipeLayout.this.rightView.getLeft() + SwipeLayout.this.getWidth() - stickyBound, toClamp, false);
                return true;
            }
            return false;
        }

        private boolean isBetween(float left, float right, float check) {
            return check >= left && check <= right;
        }
    };

    public SwipeLayout(Context context) {
        super(context);
        this.init();
    }

    public SwipeLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public SwipeLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        this.dragHelper = ViewDragHelper.create((ViewGroup)this, (float)1.0f, (ViewDragHelper.Callback)this.dragCallback);
        this.velocityThreshold = TypedValue.applyDimension((int)1, (float)1500.0f, (DisplayMetrics)this.getResources().getDisplayMetrics());
        this.touchSlop = ViewConfiguration.get((Context)this.getContext()).getScaledTouchSlop();
        this.swipeEnabled = true;
    }

    public void setOnSwipeListener(OnSwipeListener swipeListener) {
        this.swipeListener = swipeListener;
    }

    public void reset() {
        if (this.centerView == null) {
            return;
        }
        this.finishResetAnimator();
        this.dragHelper.abort();
        this.offsetChildren(null, -this.centerView.getLeft());
    }

    public void animateReset() {
        if (this.centerView == null) {
            return;
        }
        this.finishResetAnimator();
        this.dragHelper.abort();
        ObjectAnimator animator = new ObjectAnimator();
        animator.setTarget((Object)this);
        animator.setPropertyName("offset");
        animator.setInterpolator((TimeInterpolator)new AccelerateInterpolator());
        animator.setIntValues(new int[]{this.centerView.getLeft(), 0});
        animator.setDuration(200L);
        animator.start();
        this.resetAnimator = new WeakReference<ObjectAnimator>(animator);
    }

    private void finishResetAnimator() {
        if (this.resetAnimator == null) {
            return;
        }
        ObjectAnimator animator = (ObjectAnimator)this.resetAnimator.get();
        if (animator != null) {
            this.resetAnimator.clear();
            if (animator.isRunning()) {
                animator.end();
            }
        }
    }

    public int getOffset() {
        return this.centerView == null ? 0 : this.centerView.getLeft();
    }

    public void setOffset(int offset) {
        if (this.centerView != null) {
            this.offsetChildren(null, offset - this.centerView.getLeft());
        }
    }

    public boolean isSwipeEnabled() {
        return this.swipeEnabled;
    }

    public void setSwipeEnabled(boolean enabled) {
        this.swipeEnabled = enabled;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        View child;
        int i;
        int count = this.getChildCount();
        int maxHeight = 0;
        if (View.MeasureSpec.getMode((int)heightMeasureSpec) == 0x40000000) {
            this.measureChildren(widthMeasureSpec, heightMeasureSpec);
        } else {
            for (i = 0; i < count; ++i) {
                child = this.getChildAt(i);
                this.measureChild(child, widthMeasureSpec, heightMeasureSpec);
                maxHeight = Math.max(maxHeight, child.getMeasuredHeight());
            }
            if (maxHeight > 0) {
                heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)maxHeight, (int)0x40000000);
                this.measureChildren(widthMeasureSpec, heightMeasureSpec);
            }
        }
        for (i = 0; i < count; ++i) {
            child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            int childBottom = child.getMeasuredHeight();
            maxHeight = Math.max(maxHeight, childBottom);
        }
        maxHeight += this.getPaddingTop() + this.getPaddingBottom();
        maxHeight = Math.max(maxHeight, this.getSuggestedMinimumHeight());
        this.setMeasuredDimension(SwipeLayout.resolveSize((int)this.getSuggestedMinimumWidth(), (int)widthMeasureSpec), SwipeLayout.resolveSize((int)maxHeight, (int)heightMeasureSpec));
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        this.layoutChildren(left, top, right, bottom);
    }

    private void layoutChildren(int left, int top, int right, int bottom) {
        LayoutParams lp;
        View child;
        int i;
        int count = this.getChildCount();
        int parentTop = this.getPaddingTop();
        block9: for (i = 0; i < count; ++i) {
            child = this.getChildAt(i);
            lp = (LayoutParams)child.getLayoutParams();
            switch (lp.gravity) {
                case 0: {
                    this.centerView = child;
                    continue block9;
                }
                case -1: {
                    this.leftView = child;
                    continue block9;
                }
                case 1: {
                    this.rightView = child;
                }
            }
        }
        if (this.centerView == null) {
            throw new RuntimeException("Center view must be added");
        }
        for (i = 0; i < count; ++i) {
            int childLeft;
            child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            lp = (LayoutParams)child.getLayoutParams();
            int width = child.getMeasuredWidth();
            int height = child.getMeasuredHeight();
            int orientation = lp.gravity;
            switch (orientation) {
                case -1: {
                    childLeft = this.centerView.getLeft() - width;
                    break;
                }
                case 1: {
                    childLeft = this.centerView.getRight();
                    break;
                }
                default: {
                    childLeft = child.getLeft();
                }
            }
            int childTop = parentTop;
            child.layout(childLeft, childTop, childLeft + width, childTop + height);
        }
    }

    private void startScrollAnimation(View view, int targetX, boolean moveToClamp, boolean toRight) {
        if (this.dragHelper.settleCapturedViewAt(targetX, view.getTop())) {
            ViewCompat.postOnAnimation((View)view, (Runnable)new SettleRunnable(view, moveToClamp, toRight));
        } else if (moveToClamp && this.swipeListener != null) {
            this.swipeListener.onSwipeClampReached(this, toRight);
        }
    }

    private LayoutParams getLayoutParams(View view) {
        return (LayoutParams)view.getLayoutParams();
    }

    private void offsetChildren(View skip, int dx) {
        if (dx == 0) {
            return;
        }
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (child == skip) continue;
            child.offsetLeftAndRight(dx);
            this.invalidate(child.getLeft(), child.getTop(), child.getRight(), child.getBottom());
        }
    }

    private void hackParents() {
        for (ViewParent parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof NestedScrollingParent)) continue;
            View view = (View)parent;
            this.hackedParents.put(view, view.isEnabled());
        }
    }

    private void unHackParents() {
        for (Map.Entry<View, Boolean> entry : this.hackedParents.entrySet()) {
            View view = entry.getKey();
            if (view == null) continue;
            view.setEnabled(entry.getValue().booleanValue());
        }
        this.hackedParents.clear();
    }

    public boolean onInterceptTouchEvent(MotionEvent event) {
        return this.swipeEnabled ? this.dragHelper.shouldInterceptTouchEvent(event) : super.onInterceptTouchEvent(event);
    }

    public boolean onTouchEvent(MotionEvent event) {
        boolean defaultResult = super.onTouchEvent(event);
        if (!this.swipeEnabled) {
            return defaultResult;
        }
        switch (event.getActionMasked()) {
            case 0: {
                this.touchState = 0;
                this.touchX = event.getX();
                this.touchY = event.getY();
                break;
            }
            case 2: {
                if (this.touchState != 0) break;
                float dx = Math.abs(event.getX() - this.touchX);
                float dy = Math.abs(event.getY() - this.touchY);
                if (!(dx >= this.touchSlop) && !(dy >= this.touchSlop)) break;
                int n = this.touchState = dy == 0.0f || dx / dy > 1.0f ? 1 : 2;
                if (this.touchState != 1) break;
                this.requestDisallowInterceptTouchEvent(true);
                this.hackParents();
                if (this.swipeListener == null) break;
                this.swipeListener.onBeginSwipe(this, event.getX() > this.touchX);
                break;
            }
            case 1: 
            case 3: {
                if (this.touchState == 1) {
                    this.unHackParents();
                    this.requestDisallowInterceptTouchEvent(false);
                }
                this.touchState = 0;
            }
        }
        if (event.getActionMasked() != 2 || this.touchState == 1) {
            this.dragHelper.processTouchEvent(event);
        }
        return true;
    }

    protected LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams(-1, -2);
    }

    public LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new LayoutParams(this.getContext(), attrs);
    }

    protected LayoutParams generateLayoutParams(ViewGroup.LayoutParams p) {
        return new LayoutParams(p);
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams p) {
        return p instanceof LayoutParams;
    }

    public static interface OnSwipeListener {
        public void onBeginSwipe(SwipeLayout var1, boolean var2);

        public void onSwipeClampReached(SwipeLayout var1, boolean var2);

        public void onLeftStickyEdge(SwipeLayout var1, boolean var2);

        public void onRightStickyEdge(SwipeLayout var1, boolean var2);
    }

    public static class LayoutParams
    extends ViewGroup.LayoutParams {
        public static final int LEFT = -1;
        public static final int RIGHT = 1;
        public static final int CENTER = 0;
        public static final int CLAMP_PARENT = -1;
        public static final int CLAMP_SELF = -2;
        public static final int BRING_TO_CLAMP_NO = -1;
        public static final int STICKY_SELF = -1;
        public static final int STICKY_NONE = -2;
        private static final float DEFAULT_STICKY_SENSITIVITY = 0.9f;
        private int gravity = 0;
        private int sticky;
        private float stickySensitivity = 0.9f;
        private int clamp = -2;
        private int bringToClamp = -1;

        public LayoutParams(Context c, AttributeSet attrs) {
            super(c, attrs);
            TypedArray a = c.obtainStyledAttributes(attrs, R.styleable.SwipeLayout);
            int N = a.getIndexCount();
            for (int i = 0; i < N; ++i) {
                int attr = a.getIndex(i);
                if (attr == R.styleable.SwipeLayout_gravity) {
                    this.gravity = a.getInt(attr, 0);
                    continue;
                }
                if (attr == R.styleable.SwipeLayout_sticky) {
                    this.sticky = a.getLayoutDimension(attr, -1);
                    continue;
                }
                if (attr == R.styleable.SwipeLayout_clamp) {
                    this.clamp = a.getLayoutDimension(attr, -2);
                    continue;
                }
                if (attr == R.styleable.SwipeLayout_bring_to_clamp) {
                    this.bringToClamp = a.getLayoutDimension(attr, -1);
                    continue;
                }
                if (attr != R.styleable.SwipeLayout_sticky_sensitivity) continue;
                this.stickySensitivity = a.getFloat(attr, 0.9f);
            }
            a.recycle();
        }

        public LayoutParams(ViewGroup.LayoutParams source) {
            super(source);
        }

        public LayoutParams(int width, int height) {
            super(width, height);
        }
    }

    private class SettleRunnable
    implements Runnable {
        private final View mView;
        private final boolean moveToClamp;
        private final boolean moveToRight;

        SettleRunnable(View view, boolean moveToClamp, boolean moveToRight) {
            this.mView = view;
            this.moveToClamp = moveToClamp;
            this.moveToRight = moveToRight;
        }

        @Override
        public void run() {
            if (SwipeLayout.this.dragHelper != null && SwipeLayout.this.dragHelper.continueSettling(true)) {
                ViewCompat.postOnAnimation((View)this.mView, (Runnable)this);
            } else {
                Log.d((String)TAG, (String)("ONSWIPE clamp: " + this.moveToClamp + " ; moveToRight: " + this.moveToRight));
                if (this.moveToClamp && SwipeLayout.this.swipeListener != null) {
                    SwipeLayout.this.swipeListener.onSwipeClampReached(SwipeLayout.this, this.moveToRight);
                }
            }
        }
    }
}

