/*
 * Decompiled with CFR 0.152.
 */
package rst.pdfbox.layout.text.annotations;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import rst.pdfbox.layout.text.ControlCharacter;
import rst.pdfbox.layout.text.ControlCharacters;
import rst.pdfbox.layout.text.annotations.Annotation;
import rst.pdfbox.layout.text.annotations.Annotations;

public class AnnotationCharacters {
    private static final List<AnnotationControlCharacterFactory<?>> FACTORIES = new CopyOnWriteArrayList();

    public static void register(AnnotationControlCharacterFactory<?> factory) {
        FACTORIES.add(factory);
    }

    public static Iterable<AnnotationControlCharacterFactory<?>> getFactories() {
        return FACTORIES;
    }

    public static void main(String[] args) {
        Pattern PATTERN = Pattern.compile("(?<!\\\\)(\\\\\\\\)*(__(\\{(-?\\d+(\\.\\d*)?)?\\:(-?\\d+(\\.\\d*)?)?\\})?)");
        Matcher matcher = PATTERN.matcher("__");
        System.out.println("matches: " + matcher.find());
        if (!matcher.matches()) {
            System.err.println("exit");
            return;
        }
        System.out.println("start: " + matcher.start());
        System.out.println("end: " + matcher.end());
        System.out.println("groups: " + matcher.groupCount());
        for (int i = 0; i < matcher.groupCount(); ++i) {
            System.out.println("group " + i + ": '" + matcher.group(i) + "'");
        }
    }

    static {
        AnnotationCharacters.register(new HyperlinkControlCharacterFactory());
        AnnotationCharacters.register(new AnchorControlCharacterFactory());
        AnnotationCharacters.register(new UnderlineControlCharacterFactory());
    }

    public static abstract class AnnotationControlCharacter<T extends Annotation>
    extends ControlCharacter {
        protected AnnotationControlCharacter(String description, String charaterToEscape) {
            super(description, charaterToEscape);
        }

        public abstract T getAnnotation();

        public abstract Class<T> getAnnotationType();
    }

    public static interface AnnotationControlCharacterFactory<T extends AnnotationControlCharacter<? extends Annotation>>
    extends ControlCharacters.ControlCharacterFactory {
        public T createControlCharacter(String var1, Matcher var2, List<CharSequence> var3);
    }

    public static class UnderlineControlCharacter
    extends AnnotationControlCharacter<Annotations.UnderlineAnnotation> {
        public static final String UNDERLINE_DEFAULT_BASELINE_OFFSET_SCALE_PROPERTY = "pdfbox.layout.underline.baseline.offset.scale.default";
        private static Float defaultBaselineOffsetScale;
        private Annotations.UnderlineAnnotation line;

        protected UnderlineControlCharacter() {
            this(null, null);
        }

        protected UnderlineControlCharacter(String baselineOffsetScaleValue, String lineWeightValue) {
            super("UNDERLINE", "__");
            float baselineOffsetScale = UnderlineControlCharacter.parseFloat(baselineOffsetScaleValue, UnderlineControlCharacter.getdefaultBaselineOffsetScale());
            float lineWeight = UnderlineControlCharacter.parseFloat(lineWeightValue, 1.0f);
            this.line = new Annotations.UnderlineAnnotation(baselineOffsetScale, lineWeight);
        }

        @Override
        public Annotations.UnderlineAnnotation getAnnotation() {
            return this.line;
        }

        @Override
        public Class<Annotations.UnderlineAnnotation> getAnnotationType() {
            return Annotations.UnderlineAnnotation.class;
        }

        private static float parseFloat(String text, float defaultValue) {
            if (text == null) {
                return defaultValue;
            }
            try {
                return Float.parseFloat(text);
            }
            catch (NumberFormatException e) {
                return defaultValue;
            }
        }

        private static float getdefaultBaselineOffsetScale() {
            if (defaultBaselineOffsetScale == null) {
                defaultBaselineOffsetScale = Float.valueOf(Float.parseFloat(System.getProperty(UNDERLINE_DEFAULT_BASELINE_OFFSET_SCALE_PROPERTY, "-0.1")));
            }
            return defaultBaselineOffsetScale.floatValue();
        }
    }

    public static class AnchorControlCharacter
    extends AnnotationControlCharacter<Annotations.AnchorAnnotation> {
        private Annotations.AnchorAnnotation anchor;

        protected AnchorControlCharacter(String anchor) {
            super("ANCHOR", "{");
            if (anchor != null) {
                this.anchor = new Annotations.AnchorAnnotation(anchor);
            }
        }

        @Override
        public Annotations.AnchorAnnotation getAnnotation() {
            return this.anchor;
        }

        @Override
        public Class<Annotations.AnchorAnnotation> getAnnotationType() {
            return Annotations.AnchorAnnotation.class;
        }
    }

    public static class HyperlinkControlCharacter
    extends AnnotationControlCharacter<Annotations.HyperlinkAnnotation> {
        private Annotations.HyperlinkAnnotation hyperlink;

        protected HyperlinkControlCharacter(String hyperlink, String linkStyle) {
            super("HYPERLINK", "{");
            if (hyperlink != null) {
                Annotations.HyperlinkAnnotation.LinkStyle style = Annotations.HyperlinkAnnotation.LinkStyle.ul;
                if (linkStyle != null) {
                    style = Annotations.HyperlinkAnnotation.LinkStyle.valueOf(linkStyle);
                }
                this.hyperlink = new Annotations.HyperlinkAnnotation(hyperlink, style);
            }
        }

        @Override
        public Annotations.HyperlinkAnnotation getAnnotation() {
            return this.hyperlink;
        }

        @Override
        public Class<Annotations.HyperlinkAnnotation> getAnnotationType() {
            return Annotations.HyperlinkAnnotation.class;
        }
    }

    private static class UnderlineControlCharacterFactory
    implements AnnotationControlCharacterFactory<UnderlineControlCharacter> {
        private static Pattern PATTERN = Pattern.compile("(?<!\\\\)(\\\\\\\\)*(__(\\{(-?\\d+(\\.\\d*)?)?\\:(-?\\d+(\\.\\d*)?)?\\})?)");
        private static final String TO_ESCAPE = "__";

        private UnderlineControlCharacterFactory() {
        }

        @Override
        public UnderlineControlCharacter createControlCharacter(String text, Matcher matcher, List<CharSequence> charactersSoFar) {
            return new UnderlineControlCharacter(matcher.group(4), matcher.group(6));
        }

        @Override
        public Pattern getPattern() {
            return PATTERN;
        }

        @Override
        public String unescape(String text) {
            return text.replaceAll("\\\\" + Pattern.quote(TO_ESCAPE), TO_ESCAPE);
        }

        @Override
        public boolean patternMatchesBeginOfLine() {
            return false;
        }
    }

    private static class AnchorControlCharacterFactory
    implements AnnotationControlCharacterFactory<AnchorControlCharacter> {
        private static final Pattern PATTERN = Pattern.compile("(?<!\\\\)(\\\\\\\\)*\\{anchor(:((\\w+)))?\\}");
        private static final String TO_ESCAPE = "{";

        private AnchorControlCharacterFactory() {
        }

        @Override
        public AnchorControlCharacter createControlCharacter(String text, Matcher matcher, List<CharSequence> charactersSoFar) {
            return new AnchorControlCharacter(matcher.group(3));
        }

        @Override
        public Pattern getPattern() {
            return PATTERN;
        }

        @Override
        public String unescape(String text) {
            return text.replaceAll("\\\\" + Pattern.quote(TO_ESCAPE), TO_ESCAPE);
        }

        @Override
        public boolean patternMatchesBeginOfLine() {
            return false;
        }
    }

    private static class HyperlinkControlCharacterFactory
    implements AnnotationControlCharacterFactory<HyperlinkControlCharacter> {
        private static final Pattern PATTERN = Pattern.compile("(?<!\\\\)(\\\\\\\\)*\\{link(:(ul|none))?(\\[(([^}]+))\\])?\\}");
        private static final String TO_ESCAPE = "{";

        private HyperlinkControlCharacterFactory() {
        }

        @Override
        public HyperlinkControlCharacter createControlCharacter(String text, Matcher matcher, List<CharSequence> charactersSoFar) {
            return new HyperlinkControlCharacter(matcher.group(5), matcher.group(3));
        }

        @Override
        public Pattern getPattern() {
            return PATTERN;
        }

        @Override
        public String unescape(String text) {
            return text.replaceAll("\\\\" + Pattern.quote(TO_ESCAPE), TO_ESCAPE);
        }

        @Override
        public boolean patternMatchesBeginOfLine() {
            return false;
        }
    }
}

