/*
 * Decompiled with CFR 0.152.
 */
package rst.pdfbox.layout.text;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import rst.pdfbox.layout.elements.Dividable;
import rst.pdfbox.layout.elements.Paragraph;
import rst.pdfbox.layout.text.Alignment;
import rst.pdfbox.layout.text.FontDescriptor;
import rst.pdfbox.layout.text.NewLine;
import rst.pdfbox.layout.text.Position;
import rst.pdfbox.layout.text.StyledText;
import rst.pdfbox.layout.text.TextFlow;
import rst.pdfbox.layout.text.TextFragment;
import rst.pdfbox.layout.text.TextLine;
import rst.pdfbox.layout.text.TextSequence;
import rst.pdfbox.layout.text.WrappingNewLine;

public class TextSequenceUtil {
    public static List<TextLine> getLines(TextSequence text) throws IOException {
        ArrayList<TextLine> result = new ArrayList<TextLine>();
        TextLine line = new TextLine();
        for (TextFragment fragment : text) {
            if (fragment instanceof NewLine) {
                line.setNewLine((NewLine)fragment);
                result.add(line);
                line = new TextLine();
                continue;
            }
            line.add((StyledText)fragment);
        }
        if (!line.isEmpty()) {
            result.add(line);
        }
        return result;
    }

    public static Dividable.Divided divide(TextSequence text, float maxWidth, float maxHeight) throws IOException {
        TextLine line;
        TextFlow wrapped = TextSequenceUtil.wordWrap(text, maxWidth);
        List<TextLine> lines = TextSequenceUtil.getLines(wrapped);
        Paragraph first = new Paragraph();
        Paragraph tail = new Paragraph();
        if (text instanceof TextFlow) {
            TextFlow flow = (TextFlow)text;
            first.setMaxWidth(flow.getMaxWidth());
            first.setLineSpacing(flow.getLineSpacing());
            tail.setMaxWidth(flow.getMaxWidth());
            tail.setLineSpacing(flow.getLineSpacing());
        }
        int index = 0;
        do {
            line = lines.get(index);
            first.add(line);
        } while (++index < lines.size() && first.getHeight() < maxHeight);
        if (first.getHeight() > maxHeight) {
            line = lines.get(--index);
            for (TextFragment textFragment : line) {
                first.removeLast();
            }
        }
        for (int i = index; i < lines.size(); ++i) {
            tail.add(lines.get(i));
        }
        return new Dividable.Divided(first, tail);
    }

    public static TextFlow wordWrap(TextSequence text, float maxWidth) throws IOException {
        TextFlow result = new TextFlow();
        float lineLength = 0.0f;
        for (TextFragment fragment : text) {
            if (fragment instanceof NewLine) {
                result.add(fragment);
                lineLength = 0.0f;
                continue;
            }
            TextFlow words = TextSequenceUtil.splitWords(fragment);
            for (TextFragment word : words) {
                FontDescriptor fontDescriptor = word.getFontDescriptor();
                float length = fontDescriptor.getSize() * fontDescriptor.getFont().getStringWidth(word.getText()) / 1000.0f;
                float extraSpace = 0.0f;
                if (lineLength > 0.0f && word.getText().length() > 0) {
                    extraSpace = fontDescriptor.getSize() * fontDescriptor.getFont().getSpaceWidth() / 1000.0f;
                }
                if (maxWidth > 0.0f && lineLength > 0.0f && lineLength + length + extraSpace > maxWidth) {
                    result.add(new WrappingNewLine(fontDescriptor));
                    lineLength = 0.0f;
                }
                if (lineLength > 0.0f && word.getText().length() > 0) {
                    word = new StyledText(" " + word.getText(), word.getFontDescriptor());
                }
                result.add(word);
                lineLength += length + extraSpace;
            }
        }
        return result;
    }

    public static List<TextLine> wordWrapToLines(TextSequence text, float maxWidth) throws IOException {
        TextFlow wrapped = TextSequenceUtil.wordWrap(text, maxWidth);
        List<TextLine> lines = TextSequenceUtil.getLines(wrapped);
        return lines;
    }

    public static TextFlow splitWords(TextFragment text) {
        TextFlow result = new TextFlow();
        if (text instanceof NewLine) {
            result.add(text);
        } else {
            String[] words;
            for (String word : words = text.getText().split(" ")) {
                result.add(new StyledText(word, text.getFontDescriptor()));
            }
        }
        return result;
    }

    public static void drawText(TextSequence text, PDPageContentStream contentStream, Position upperLeft, Alignment alignment, float maxWidth, float lineSpacing) throws IOException {
        List<TextLine> lines = TextSequenceUtil.wordWrapToLines(text, maxWidth);
        float targetWidth = TextSequenceUtil.getMaxWidth(lines);
        Position position = upperLeft;
        float lastLineHeight = 0.0f;
        for (int i = 0; i < lines.size(); ++i) {
            TextLine textLine = lines.get(i);
            float currentLineHeight = textLine.getHeight();
            float lead = lastLineHeight + currentLineHeight * (lineSpacing - 1.0f);
            lastLineHeight = currentLineHeight;
            position = position.add(0.0f, -lead);
            float offset = TextSequenceUtil.getOffset(textLine, targetWidth, alignment);
            position = new Position(upperLeft.getX() + offset, position.getY());
            textLine.drawText(contentStream, position, alignment);
        }
    }

    public static float getOffset(TextSequence textLine, float targetWidth, Alignment alignment) throws IOException {
        switch (alignment) {
            case Right: {
                return targetWidth - textLine.getWidth();
            }
            case Center: {
                return (targetWidth - textLine.getWidth()) / 2.0f;
            }
        }
        return 0.0f;
    }

    public static float getMaxWidth(Iterable<TextLine> lines) throws IOException {
        float max = 0.0f;
        for (TextLine line : lines) {
            max = Math.max(max, line.getWidth());
        }
        return max;
    }

    public static float getWidth(TextSequence textSequence, float maxWidth) throws IOException {
        List<TextLine> lines = TextSequenceUtil.wordWrapToLines(textSequence, maxWidth);
        float max = 0.0f;
        for (TextLine line : lines) {
            max = Math.max(max, line.getWidth());
        }
        return max;
    }

    public static float getHeight(TextSequence textSequence, float maxWidth, float lineSpacing) throws IOException {
        List<TextLine> lines = TextSequenceUtil.wordWrapToLines(textSequence, maxWidth);
        float sum = 0.0f;
        for (int i = 0; i < lines.size(); ++i) {
            TextLine line = lines.get(i);
            float lineHeight = line.getHeight() * lineSpacing;
            sum += lineHeight;
        }
        return sum;
    }
}

