/*
 * Decompiled with CFR 0.152.
 */
package rst.pdfbox.layout.text;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.font.PDFont;
import rst.pdfbox.layout.text.Alignment;
import rst.pdfbox.layout.text.BaseFont;
import rst.pdfbox.layout.text.Position;
import rst.pdfbox.layout.text.TextFlowUtil;
import rst.pdfbox.layout.text.TextFragment;
import rst.pdfbox.layout.text.TextSequence;
import rst.pdfbox.layout.text.TextSequenceUtil;
import rst.pdfbox.layout.text.WidthRespecting;

public class TextFlow
implements TextSequence,
WidthRespecting {
    public static final float DEFAULT_LINE_SPACING = 1.2f;
    private final List<TextFragment> text = new ArrayList<TextFragment>();
    private float lineSpacing = 1.2f;
    private float maxWidth = -1.0f;

    public void addText(String text, float fontSize, PDFont font) {
        this.add(TextFlowUtil.createTextFlow(text, fontSize, font));
    }

    public void addMarkup(String markup, float fontSize, BaseFont baseFont) {
        this.add(TextFlowUtil.createTextFlowFromMarkup(markup, fontSize, baseFont));
    }

    public void addMarkup(String markup, float fontSize, PDFont plainFont, PDFont boldFont, PDFont italicFont, PDFont boldItalicFont) {
        this.add(TextFlowUtil.createTextFlowFromMarkup(markup, fontSize, plainFont, boldFont, italicFont, boldItalicFont));
    }

    public void add(TextSequence sequence) {
        for (TextFragment fragment : sequence) {
            this.add(fragment);
        }
    }

    public void add(TextFragment fragment) {
        this.text.add(fragment);
    }

    public TextFragment removeLast() {
        if (this.text.size() > 0) {
            return this.text.remove(this.text.size() - 1);
        }
        return null;
    }

    public boolean isEmpty() {
        return this.text.isEmpty();
    }

    @Override
    public Iterator<TextFragment> iterator() {
        return this.text.iterator();
    }

    @Override
    public float getMaxWidth() {
        return this.maxWidth;
    }

    @Override
    public void setMaxWidth(float maxWidth) {
        this.maxWidth = maxWidth;
    }

    public float getLineSpacing() {
        return this.lineSpacing;
    }

    public void setLineSpacing(float lineSpacing) {
        this.lineSpacing = lineSpacing;
    }

    @Override
    public float getWidth() throws IOException {
        return TextSequenceUtil.getWidth(this, this.getMaxWidth());
    }

    @Override
    public float getHeight() throws IOException {
        return TextSequenceUtil.getHeight(this, this.getMaxWidth(), this.getLineSpacing());
    }

    @Override
    public void drawText(PDPageContentStream contentStream, Position upperLeft, Alignment alignment) throws IOException {
        TextSequenceUtil.drawText(this, contentStream, upperLeft, alignment, this.getMaxWidth(), this.getLineSpacing());
    }

    public void drawTextRightAligned(PDPageContentStream contentStream, Position endOfFirstLine) throws IOException {
        this.drawText(contentStream, endOfFirstLine.add(-this.getWidth(), 0.0f), Alignment.Right);
    }

    public String toString() {
        return "TextFlow [text=" + this.text + "]";
    }
}

