/*
 * Decompiled with CFR 0.152.
 */
package rst.pdfbox.layout.text.annotations;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.pdfbox.pdmodel.font.PDFont;
import rst.pdfbox.layout.text.FontDescriptor;
import rst.pdfbox.layout.text.StyledText;
import rst.pdfbox.layout.text.annotations.Annotated;
import rst.pdfbox.layout.text.annotations.Annotation;

public class AnnotatedStyledText
extends StyledText
implements Annotated {
    private List<Annotation> annotations = new ArrayList<Annotation>();

    public AnnotatedStyledText(String text, FontDescriptor fontDescriptor, Color color, float leftMargin, float rightMargin, float baselineOffset, Collection<? extends Annotation> annotations) {
        super(text, fontDescriptor, color, baselineOffset, leftMargin, rightMargin);
        if (annotations != null) {
            this.annotations.addAll(annotations);
        }
    }

    public AnnotatedStyledText(String text, float size, PDFont font, Color color, float baselineOffset, Collection<? extends Annotation> annotations) {
        this(text, new FontDescriptor(font, size), color, baselineOffset, 0.0f, 0.0f, annotations);
    }

    @Override
    public Iterator<Annotation> iterator() {
        return this.annotations.iterator();
    }

    @Override
    public <T extends Annotation> Iterable<T> getAnnotationsOfType(Class<T> type) {
        ArrayList<Annotation> result = null;
        for (Annotation annotation : this.annotations) {
            if (!type.isAssignableFrom(annotation.getClass())) continue;
            if (result == null) {
                result = new ArrayList<Annotation>();
            }
            result.add(annotation);
        }
        if (result == null) {
            return Collections.emptyList();
        }
        return result;
    }

    public void addAnnotation(Annotation annotation) {
        this.annotations.add(annotation);
    }

    public void addAllAnnotation(Collection<Annotation> annos) {
        this.annotations.addAll(annos);
    }

    @Override
    public AnnotatedStyledText inheritAttributes(String text, float leftMargin, float rightMargin) {
        return new AnnotatedStyledText(text, this.getFontDescriptor(), this.getColor(), this.getBaselineOffset(), leftMargin, rightMargin, this.annotations);
    }
}

