/*
 * Decompiled with CFR 0.152.
 */
package rst.pdfbox.layout.elements;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import rst.pdfbox.layout.elements.ControlElement;
import rst.pdfbox.layout.elements.Drawable;
import rst.pdfbox.layout.elements.Element;
import rst.pdfbox.layout.elements.render.Layout;
import rst.pdfbox.layout.elements.render.LayoutHint;
import rst.pdfbox.layout.elements.render.RenderContext;
import rst.pdfbox.layout.elements.render.RenderListener;
import rst.pdfbox.layout.elements.render.VerticalLayout;
import rst.pdfbox.layout.elements.render.VerticalLayoutHint;

public class Document
implements RenderListener {
    private final float marginLeft;
    private final float marginRight;
    private final float marginTop;
    private final float marginBottom;
    private final PDRectangle mediaBox;
    private final List<Map.Entry<Element, LayoutHint>> elements = new ArrayList<Map.Entry<Element, LayoutHint>>();
    private final List<RenderListener> renderListener = new CopyOnWriteArrayList<RenderListener>();
    private Layout layout = new VerticalLayout();

    public Document(PDRectangle mediaBox) {
        this(mediaBox, 0.0f, 0.0f, 0.0f, 0.0f);
    }

    public Document(PDRectangle mediaBox, float marginLeft, float marginRight, float marginTop, float marginBottom) {
        this.mediaBox = mediaBox;
        this.marginLeft = marginLeft;
        this.marginRight = marginRight;
        this.marginTop = marginTop;
        this.marginBottom = marginBottom;
    }

    public void add(Element element) {
        this.add(element, new VerticalLayoutHint());
    }

    public void add(Element element, LayoutHint layoutHint) {
        this.elements.add(this.createEntry(element, layoutHint));
    }

    private Map.Entry<Element, LayoutHint> createEntry(Element element, LayoutHint layoutHint) {
        return new AbstractMap.SimpleEntry<Element, LayoutHint>(element, layoutHint);
    }

    public void remove(Element element) {
        this.elements.remove(element);
    }

    public float getMarginLeft() {
        return this.marginLeft;
    }

    public float getMarginRight() {
        return this.marginRight;
    }

    public float getMarginTop() {
        return this.marginTop;
    }

    public float getMarginBottom() {
        return this.marginBottom;
    }

    public PDRectangle getMediaBox() {
        return this.mediaBox;
    }

    public float getPageWidth() {
        return this.getMediaBox().getWidth() - this.getMarginLeft() - this.getMarginRight();
    }

    public float getPageHeight() {
        return this.getMediaBox().getHeight() - this.getMarginTop() - this.getMarginBottom();
    }

    public PDDocument render() throws IOException {
        PDDocument document = new PDDocument();
        RenderContext renderContext = new RenderContext(this, document);
        for (Map.Entry<Element, LayoutHint> entry : this.elements) {
            Element element = entry.getKey();
            LayoutHint layoutHint = entry.getValue();
            if (element instanceof Drawable) {
                this.layout.render(renderContext, (Drawable)((Object)element), layoutHint);
            }
            if (element == ControlElement.NEWPAGE) {
                renderContext.newPage();
            }
            if (!(element instanceof Layout)) continue;
            this.layout = (Layout)element;
        }
        renderContext.close();
        return document;
    }

    public void save(File file) throws IOException {
        try (FileOutputStream out = new FileOutputStream(file);){
            this.save(out);
        }
    }

    public void save(OutputStream output) throws IOException {
        try (PDDocument document = this.render();){
            try {
                document.save(output);
            }
            catch (IOException ioe) {
                throw ioe;
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
    }

    public void addRenderListener(RenderListener listener) {
        if (listener != null) {
            this.renderListener.add(listener);
        }
    }

    public void removeRenderListener(RenderListener listener) {
        this.renderListener.remove(listener);
    }

    @Override
    public void beforePage(RenderContext renderContext) throws IOException {
        for (RenderListener listener : this.renderListener) {
            listener.beforePage(renderContext);
        }
    }

    @Override
    public void afterPage(RenderContext renderContext) throws IOException {
        for (RenderListener listener : this.renderListener) {
            listener.afterPage(renderContext);
        }
    }
}

