/*
 * Decompiled with CFR 0.152.
 */
package com.mobsandgeeks.saripaar.rule;

import android.content.Context;
import com.mobsandgeeks.saripaar.ContextualAnnotationRule;
import com.mobsandgeeks.saripaar.ValidationContext;
import com.mobsandgeeks.saripaar.annotation.Past;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class PastRule
extends ContextualAnnotationRule<Past, String> {
    protected PastRule(ValidationContext validationContext, Past past) {
        super(validationContext, past);
    }

    @Override
    public boolean isValid(String dateString) {
        DateFormat dateFormat = this.getDateFormat();
        Date parsedDate = null;
        try {
            parsedDate = dateFormat.parse(dateString);
        }
        catch (ParseException ignored) {
            // empty catch block
        }
        Date now = new Date();
        return parsedDate != null && parsedDate.before(now);
    }

    private DateFormat getDateFormat() {
        Context context = this.mValidationContext.getContext();
        int dateFormatResId = ((Past)this.mRuleAnnotation).dateFormatResId();
        String dateFormatString = dateFormatResId != -1 ? context.getString(dateFormatResId) : ((Past)this.mRuleAnnotation).dateFormat();
        return new SimpleDateFormat(dateFormatString);
    }
}

