/*
 * Decompiled with CFR 0.152.
 */
package com.mobsandgeeks.saripaar.rule;

import android.content.Context;
import com.mobsandgeeks.saripaar.ContextualAnnotationRule;
import com.mobsandgeeks.saripaar.ValidationContext;
import com.mobsandgeeks.saripaar.annotation.Future;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class FutureRule
extends ContextualAnnotationRule<Future, String> {
    protected FutureRule(ValidationContext validationContext, Future future) {
        super(validationContext, future);
    }

    @Override
    public boolean isValid(String dateString) {
        DateFormat dateFormat = this.getDateFormat();
        Date parsedDate = null;
        try {
            parsedDate = dateFormat.parse(dateString);
        }
        catch (ParseException ignored) {
            // empty catch block
        }
        Date now = new Date();
        return parsedDate != null && parsedDate.after(now);
    }

    private DateFormat getDateFormat() {
        Context context = this.mValidationContext.getContext();
        int dateFormatResId = ((Future)this.mRuleAnnotation).dateFormatResId();
        String dateFormatString = dateFormatResId != -1 ? context.getString(dateFormatResId) : ((Future)this.mRuleAnnotation).dateFormat();
        return new SimpleDateFormat(dateFormatString);
    }
}

