/*
 * Decompiled with CFR 0.152.
 */
package com.takusemba.spotlight.shape;

import android.animation.TimeInterpolator;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PointF;
import android.view.animation.DecelerateInterpolator;
import com.takusemba.spotlight.shape.Shape;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB-\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ(\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00032\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001d"}, d2={"Lcom/takusemba/spotlight/shape/Circle;", "Lcom/takusemba/spotlight/shape/Shape;", "radius", "", "type", "Lcom/takusemba/spotlight/shape/Shape$ShapeType;", "duration", "", "interpolator", "Landroid/animation/TimeInterpolator;", "(FLcom/takusemba/spotlight/shape/Shape$ShapeType;JLandroid/animation/TimeInterpolator;)V", "getDuration", "()J", "getInterpolator", "()Landroid/animation/TimeInterpolator;", "getRadius", "()F", "getType", "()Lcom/takusemba/spotlight/shape/Shape$ShapeType;", "draw", "", "canvas", "Landroid/graphics/Canvas;", "point", "Landroid/graphics/PointF;", "value", "paint", "Landroid/graphics/Paint;", "Companion", "spotlight_release"})
public final class Circle
implements Shape {
    private final float radius;
    @NotNull
    private final Shape.ShapeType type;
    private final long duration;
    @NotNull
    private final TimeInterpolator interpolator;
    private static final long DEFAULT_DURATION;
    @NotNull
    private static final DecelerateInterpolator DEFAULT_INTERPOLATOR;
    @NotNull
    public static final Companion Companion;

    @Override
    public void draw(@NotNull Canvas canvas, @NotNull PointF point, float value, @NotNull Paint paint) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        Intrinsics.checkNotNullParameter((Object)paint, (String)"paint");
        canvas.drawCircle(point.x, point.y, value * this.radius, paint);
    }

    public final float getRadius() {
        return this.radius;
    }

    @Override
    @NotNull
    public Shape.ShapeType getType() {
        return this.type;
    }

    @Override
    public long getDuration() {
        return this.duration;
    }

    @Override
    @NotNull
    public TimeInterpolator getInterpolator() {
        return this.interpolator;
    }

    @JvmOverloads
    public Circle(float radius, @NotNull Shape.ShapeType type, long duration, @NotNull TimeInterpolator interpolator) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)interpolator, (String)"interpolator");
        this.radius = radius;
        this.type = type;
        this.duration = duration;
        this.interpolator = interpolator;
    }

    public /* synthetic */ Circle(float f, Shape.ShapeType shapeType, long l, TimeInterpolator timeInterpolator, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            shapeType = Shape.ShapeType.CIRCLE;
        }
        if ((n & 4) != 0) {
            l = DEFAULT_DURATION;
        }
        if ((n & 8) != 0) {
            timeInterpolator = (TimeInterpolator)DEFAULT_INTERPOLATOR;
        }
        this(f, shapeType, l, timeInterpolator);
    }

    @JvmOverloads
    public Circle(float radius, @NotNull Shape.ShapeType type, long duration) {
        this(radius, type, duration, null, 8, null);
    }

    @JvmOverloads
    public Circle(float radius, @NotNull Shape.ShapeType type) {
        this(radius, type, 0L, null, 12, null);
    }

    @JvmOverloads
    public Circle(float radius) {
        this(radius, null, 0L, null, 14, null);
    }

    static {
        Companion = new Companion(null);
        DEFAULT_DURATION = TimeUnit.MILLISECONDS.toMillis(500L);
        DEFAULT_INTERPOLATOR = new DecelerateInterpolator(2.0f);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/takusemba/spotlight/shape/Circle$Companion;", "", "()V", "DEFAULT_DURATION", "", "getDEFAULT_DURATION", "()J", "DEFAULT_INTERPOLATOR", "Landroid/view/animation/DecelerateInterpolator;", "getDEFAULT_INTERPOLATOR", "()Landroid/view/animation/DecelerateInterpolator;", "spotlight_release"})
    public static final class Companion {
        public final long getDEFAULT_DURATION() {
            return DEFAULT_DURATION;
        }

        @NotNull
        public final DecelerateInterpolator getDEFAULT_INTERPOLATOR() {
            return DEFAULT_INTERPOLATOR;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

