/*
 * Decompiled with CFR 0.152.
 */
package com.github.pwittchen.reactivenetwork.library.rx2.network.observing.strategy;

import android.annotation.TargetApi;
import android.content.Context;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkRequest;
import android.util.Log;
import com.github.pwittchen.reactivenetwork.library.rx2.Connectivity;
import com.github.pwittchen.reactivenetwork.library.rx2.network.observing.NetworkObservingStrategy;
import io.reactivex.Observable;
import io.reactivex.ObservableEmitter;
import io.reactivex.ObservableOnSubscribe;
import io.reactivex.functions.Action;

@TargetApi(value=21)
public class LollipopNetworkObservingStrategy
implements NetworkObservingStrategy {
    private ConnectivityManager.NetworkCallback networkCallback;

    @Override
    public Observable<Connectivity> observeNetworkConnectivity(final Context context) {
        String service = "connectivity";
        final ConnectivityManager manager = (ConnectivityManager)context.getSystemService("connectivity");
        return Observable.create((ObservableOnSubscribe)new ObservableOnSubscribe<Connectivity>(){

            public void subscribe(ObservableEmitter<Connectivity> subscriber) throws Exception {
                LollipopNetworkObservingStrategy.this.networkCallback = LollipopNetworkObservingStrategy.this.createNetworkCallback((ObservableEmitter<Connectivity>)subscriber, context);
                NetworkRequest networkRequest = new NetworkRequest.Builder().build();
                manager.registerNetworkCallback(networkRequest, LollipopNetworkObservingStrategy.this.networkCallback);
            }
        }).doOnDispose(new Action(){

            public void run() {
                LollipopNetworkObservingStrategy.this.tryToUnregisterCallback(manager);
            }
        }).startWith((Object)Connectivity.create(context)).distinctUntilChanged();
    }

    private void tryToUnregisterCallback(ConnectivityManager manager) {
        try {
            manager.unregisterNetworkCallback(this.networkCallback);
        }
        catch (Exception exception) {
            this.onError("could not unregister network callback", exception);
        }
    }

    @Override
    public void onError(String message, Exception exception) {
        Log.e((String)"ReactiveNetwork", (String)message, (Throwable)exception);
    }

    private ConnectivityManager.NetworkCallback createNetworkCallback(final ObservableEmitter<Connectivity> subscriber, final Context context) {
        return new ConnectivityManager.NetworkCallback(){

            public void onAvailable(Network network) {
                subscriber.onNext((Object)Connectivity.create(context));
            }

            public void onLost(Network network) {
                subscriber.onNext((Object)Connectivity.create(context));
            }
        };
    }
}

