/*
 * Decompiled with CFR 0.152.
 */
package com.onegravity.rteditor.spans;

import android.text.Spanned;
import com.onegravity.rteditor.spans.AbsoluteSizeSpan;

abstract class BaseListItemSpan {
    BaseListItemSpan() {
    }

    float determineTextSize(Spanned spanned, int start, int end, float defaultTextSize) {
        AbsoluteSizeSpan[] absoluteSizeSpans;
        int position = this.firstVisibleCharIndex(spanned, start, end);
        if (position >= 0 && (absoluteSizeSpans = (AbsoluteSizeSpan[])spanned.getSpans(position, position, AbsoluteSizeSpan.class)).length > 0) {
            AbsoluteSizeSpan absoluteSizeSpan = absoluteSizeSpans[absoluteSizeSpans.length - 1];
            return absoluteSizeSpan.getValue().intValue();
        }
        return defaultTextSize;
    }

    private int firstVisibleCharIndex(Spanned spanned, int start, int end) {
        while (start < end) {
            if (this.isVisibleChar(spanned.charAt(start))) {
                return start;
            }
            ++start;
        }
        return -1;
    }

    private boolean isVisibleChar(char c) {
        switch (c) {
            case '\u200b': 
            case '\uffef': {
                return false;
            }
        }
        return true;
    }
}

