/*
 * Decompiled with CFR 0.152.
 */
package com.onegravity.rteditor.media.choose;

import android.annotation.SuppressLint;
import android.content.Intent;
import android.os.Bundle;
import com.onegravity.rteditor.R;
import com.onegravity.rteditor.api.RTMediaFactory;
import com.onegravity.rteditor.api.media.RTAudio;
import com.onegravity.rteditor.api.media.RTImage;
import com.onegravity.rteditor.api.media.RTVideo;
import com.onegravity.rteditor.media.MediaUtils;
import com.onegravity.rteditor.media.MonitoredActivity;
import com.onegravity.rteditor.media.choose.processor.MediaProcessor;
import com.onegravity.rteditor.utils.Constants;

abstract class MediaChooserManager
implements MediaProcessor.MediaProcessorListener {
    protected transient MonitoredActivity mActivity;
    protected transient RTMediaFactory<RTImage, RTAudio, RTVideo> mMediaFactory;
    protected transient Constants.MediaAction mMediaAction;
    private transient MediaChooserListener mListener;
    private String mOriginalFile;

    MediaChooserManager(MonitoredActivity activity, Constants.MediaAction mediaAction, RTMediaFactory<RTImage, RTAudio, RTVideo> mediaFactory, MediaChooserListener listener, Bundle savedInstanceState) {
        this.mActivity = activity;
        this.mMediaFactory = mediaFactory;
        this.mMediaAction = mediaAction;
        this.mListener = listener;
        if (savedInstanceState != null) {
            this.mOriginalFile = savedInstanceState.getString("mOriginalFile");
        }
    }

    void onSaveInstanceState(Bundle outState) {
        outState.putString("mOriginalFile", this.mOriginalFile);
    }

    abstract boolean chooseMedia() throws IllegalArgumentException;

    abstract void processMedia(Constants.MediaAction var1, Intent var2);

    @Override
    public void onError(String reason) {
        if (this.mListener != null) {
            this.mListener.onError(reason);
        }
    }

    @SuppressLint(value={"NewApi"})
    protected void startActivity(Intent intent) {
        if (this.mActivity != null) {
            this.mActivity.startActivityForResult(intent, this.mMediaAction.requestCode());
        }
    }

    protected void startBackgroundJob(MediaProcessor processor) {
        this.mActivity.startBackgroundJob(R.string.rte_processing_image, processor);
    }

    protected String getOriginalFile() {
        return this.mOriginalFile;
    }

    protected void setOriginalFile(String originalFile) {
        this.mOriginalFile = originalFile;
    }

    protected String determineOriginalFile(Intent data) {
        this.mOriginalFile = null;
        if (data != null && data.getDataString() != null) {
            try {
                this.mOriginalFile = MediaUtils.determineOriginalFile(this.mActivity.getApplicationContext(), data.getData());
            }
            catch (IllegalArgumentException e) {
                this.onError(e.getMessage());
            }
        }
        return this.mOriginalFile;
    }

    public static interface MediaChooserListener {
        public void onError(String var1);
    }
}

