/*
 * Decompiled with CFR 0.152.
 */
package com.onegravity.rteditor.media.choose;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.widget.Toast;
import com.onegravity.rteditor.api.RTMediaFactory;
import com.onegravity.rteditor.api.format.RTFormat;
import com.onegravity.rteditor.api.media.RTAudio;
import com.onegravity.rteditor.api.media.RTImage;
import com.onegravity.rteditor.api.media.RTMedia;
import com.onegravity.rteditor.api.media.RTVideo;
import com.onegravity.rteditor.media.MonitoredActivity;
import com.onegravity.rteditor.media.choose.AudioChooserManager;
import com.onegravity.rteditor.media.choose.ImageChooserManager;
import com.onegravity.rteditor.media.choose.MediaChooserManager;
import com.onegravity.rteditor.media.choose.MediaEvent;
import com.onegravity.rteditor.media.choose.VideoChooserManager;
import com.onegravity.rteditor.media.crop.CropImageActivity;
import com.onegravity.rteditor.utils.Constants;
import java.io.Serializable;
import org.greenrobot.eventbus.EventBus;

public class MediaChooserActivity
extends MonitoredActivity
implements ImageChooserManager.ImageChooserListener,
AudioChooserManager.AudioChooserListener,
VideoChooserManager.VideoChooserListener {
    private static final String PREFIX = MediaChooserActivity.class.getSimpleName();
    public static final String EXTRA_MEDIA_ACTION = PREFIX + "EXTRA_MEDIA_ACTION";
    public static final String EXTRA_MEDIA_FACTORY = PREFIX + "EXTRA_MEDIA_FACTORY";
    private RTMediaFactory<RTImage, RTAudio, RTVideo> mMediaFactory;
    private Constants.MediaAction mMediaAction;
    private transient MediaChooserManager mMediaChooserMgr;
    private RTMedia mSelectedMedia;
    private static boolean mWorkInProgress;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Bundle extras = this.getIntent().getExtras();
        if (extras != null) {
            String mediaAction = extras.getString(EXTRA_MEDIA_ACTION);
            this.mMediaAction = mediaAction == null ? null : Constants.MediaAction.valueOf(mediaAction);
            this.mMediaFactory = (RTMediaFactory)extras.getSerializable(EXTRA_MEDIA_FACTORY);
        }
        if (this.mMediaAction != null) {
            if (savedInstanceState != null) {
                this.mSelectedMedia = (RTMedia)savedInstanceState.getSerializable("mSelectedMedia");
            }
            switch (this.mMediaAction) {
                case PICK_PICTURE: 
                case CAPTURE_PICTURE: {
                    this.mMediaChooserMgr = new ImageChooserManager((MonitoredActivity)this, this.mMediaAction, this.mMediaFactory, this, savedInstanceState);
                    break;
                }
                case PICK_VIDEO: 
                case CAPTURE_VIDEO: {
                    this.mMediaChooserMgr = new VideoChooserManager((MonitoredActivity)this, this.mMediaAction, this.mMediaFactory, this, savedInstanceState);
                    break;
                }
                case PICK_AUDIO: 
                case CAPTURE_AUDIO: {
                    this.mMediaChooserMgr = new AudioChooserManager((MonitoredActivity)this, this.mMediaAction, this.mMediaFactory, this, savedInstanceState);
                }
            }
            if (this.mMediaChooserMgr == null) {
                this.finish();
            } else if (!this.isWorkInProgress()) {
                this.setWorkInProgress(true);
                if (!this.mMediaChooserMgr.chooseMedia()) {
                    this.finish();
                }
            }
        } else {
            this.finish();
        }
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        if (this.mSelectedMedia != null) {
            outState.putSerializable("mSelectedMedia", (Serializable)this.mSelectedMedia);
        }
    }

    private void setWorkInProgress(boolean value) {
        mWorkInProgress = value;
    }

    private boolean isWorkInProgress() {
        return mWorkInProgress;
    }

    public void finish() {
        super.finish();
        this.setWorkInProgress(false);
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (resultCode == -1) {
            String path;
            if (requestCode == Constants.MediaAction.PICK_PICTURE.requestCode() && data != null) {
                this.mMediaChooserMgr.processMedia(Constants.MediaAction.PICK_PICTURE, data);
            } else if (requestCode == Constants.MediaAction.CAPTURE_PICTURE.requestCode()) {
                this.mMediaChooserMgr.processMedia(Constants.MediaAction.CAPTURE_PICTURE, data);
            } else if (requestCode == 107 && (path = data.getStringExtra("image-dest-file")) != null && this.mSelectedMedia instanceof RTImage) {
                EventBus.getDefault().postSticky((Object)new MediaEvent(this.mSelectedMedia));
                this.finish();
            }
        } else {
            this.setResult(0);
            this.finish();
        }
    }

    @Override
    public void onImageChosen(final RTImage image) {
        this.mSelectedMedia = image;
        this.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (MediaChooserActivity.this.mMediaAction == Constants.MediaAction.CAPTURE_PICTURE) {
                    String filePath = image.getFilePath(RTFormat.SPANNED);
                    Intent intent = new Intent((Context)MediaChooserActivity.this, CropImageActivity.class).putExtra("image-source-file", filePath).putExtra("image-dest-file", filePath).putExtra("scale", true).putExtra("scaleUpIfNeeded", false).putExtra("aspectX", 0).putExtra("aspectY", 0);
                    MediaChooserActivity.this.startActivityForResult(intent, 107);
                } else {
                    EventBus.getDefault().postSticky((Object)new MediaEvent(MediaChooserActivity.this.mSelectedMedia));
                    MediaChooserActivity.this.finish();
                }
            }
        });
    }

    @Override
    public void onAudioChosen(RTAudio audio) {
        this.mSelectedMedia = audio;
        this.setWorkInProgress(false);
    }

    @Override
    public void onVideoChosen(RTVideo video) {
        this.mSelectedMedia = video;
        this.setWorkInProgress(false);
    }

    @Override
    public void onError(String reason) {
        Toast.makeText((Context)this, (CharSequence)reason, (int)0).show();
        this.setWorkInProgress(false);
    }
}

