/*
 * Decompiled with CFR 0.152.
 */
package com.onegravity.rteditor.effects;

import android.text.Editable;
import android.text.Spannable;
import com.onegravity.rteditor.RTEditText;
import com.onegravity.rteditor.effects.ParagraphEffect;
import com.onegravity.rteditor.effects.ParagraphSpanProcessor;
import com.onegravity.rteditor.effects.SpanCollectMode;
import com.onegravity.rteditor.spans.IndentationSpan;
import com.onegravity.rteditor.spans.RTSpan;
import com.onegravity.rteditor.utils.Paragraph;
import com.onegravity.rteditor.utils.Selection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class IndentationEffect
extends ParagraphEffect<Integer, IndentationSpan> {
    private ParagraphSpanProcessor<Integer> mSpans2Process = new ParagraphSpanProcessor();

    @Override
    public void applyToSelection(RTEditText editor, Selection selectedParagraphs, Integer increment) {
        Editable str = editor.getText();
        this.mSpans2Process.clear();
        ArrayList<Paragraph> paragraphs = editor.getParagraphs();
        int size = paragraphs.size();
        for (int i = 0; i < size; ++i) {
            Paragraph paragraph = paragraphs.get(i);
            List existingSpans = this.getSpans((Spannable)str, paragraph, SpanCollectMode.EXACT);
            this.mSpans2Process.removeSpans(existingSpans, paragraph);
            int indentation = 0;
            Iterator iterator = existingSpans.iterator();
            if (iterator.hasNext()) {
                RTSpan span = iterator.next();
                indentation += ((Integer)span.getValue()).intValue();
            }
            int incIndentation = increment == null ? 0 : increment;
            if ((indentation += paragraph.isSelected(selectedParagraphs) ? incIndentation : 0) <= 0) continue;
            IndentationSpan leadingMarginSpan = new IndentationSpan(indentation, paragraph.isEmpty(), paragraph.isFirst(), paragraph.isLast());
            this.mSpans2Process.addSpan(leadingMarginSpan, paragraph);
        }
        this.mSpans2Process.process((Spannable)str);
    }
}

