/*
 * Decompiled with CFR 0.152.
 */
package com.onegravity.rteditor.converter;

import android.text.Spanned;
import android.text.style.AbsoluteSizeSpan;
import android.text.style.BackgroundColorSpan;
import android.text.style.CharacterStyle;
import android.text.style.ForegroundColorSpan;
import android.text.style.ParagraphStyle;
import android.text.style.StrikethroughSpan;
import android.text.style.SubscriptSpan;
import android.text.style.SuperscriptSpan;
import android.text.style.URLSpan;
import com.onegravity.rteditor.api.format.RTFormat;
import com.onegravity.rteditor.api.format.RTHtml;
import com.onegravity.rteditor.api.media.RTAudio;
import com.onegravity.rteditor.api.media.RTImage;
import com.onegravity.rteditor.api.media.RTVideo;
import com.onegravity.rteditor.converter.AccumulatedParagraphStyle;
import com.onegravity.rteditor.converter.ParagraphType;
import com.onegravity.rteditor.converter.SingleParagraphStyle;
import com.onegravity.rteditor.converter.tagsoup.util.StringEscapeUtils;
import com.onegravity.rteditor.spans.AudioSpan;
import com.onegravity.rteditor.spans.BoldSpan;
import com.onegravity.rteditor.spans.ImageSpan;
import com.onegravity.rteditor.spans.ItalicSpan;
import com.onegravity.rteditor.spans.LinkSpan;
import com.onegravity.rteditor.spans.TypefaceSpan;
import com.onegravity.rteditor.spans.UnderlineSpan;
import com.onegravity.rteditor.spans.VideoSpan;
import com.onegravity.rteditor.utils.Helper;
import com.onegravity.rteditor.utils.Paragraph;
import com.onegravity.rteditor.utils.RTLayout;
import com.onegravity.rteditor.utils.Selection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.Stack;
import java.util.TreeSet;

public class ConverterSpannedToHtml {
    private static final String BR = "<br/>\n";
    private static final String LT = "&lt;";
    private static final String GT = "&gt;";
    private static final String AMP = "&amp;";
    private static final String NBSP = "&nbsp;";
    private StringBuilder mOut;
    private Spanned mText;
    private RTFormat mRTFormat;
    private List<RTImage> mImages;
    private Stack<AccumulatedParagraphStyle> mParagraphStyles = new Stack();

    public RTHtml<RTImage, RTAudio, RTVideo> convert(Spanned text, RTFormat.Html rtFormat) {
        this.mText = text;
        this.mRTFormat = rtFormat;
        this.mOut = new StringBuilder();
        this.mImages = new ArrayList<RTImage>();
        this.mParagraphStyles.clear();
        this.convertParagraphs();
        return new RTHtml<RTImage, RTAudio, RTVideo>(rtFormat, this.mOut.toString(), this.mImages);
    }

    private void convertParagraphs() {
        RTLayout rtLayout = new RTLayout(this.mText);
        ArrayList<Paragraph> paragraphs = rtLayout.getParagraphs();
        int size = paragraphs.size();
        for (int i = 0; i < size; ++i) {
            Paragraph paragraph = paragraphs.get(i);
            Set<SingleParagraphStyle> styles = this.getParagraphStyles(this.mText, paragraph);
            ParagraphType alignmentType = null;
            for (SingleParagraphStyle style : styles) {
                if (!style.getType().isAlignment()) continue;
                alignmentType = style.getType();
                break;
            }
            int newIndent = 0;
            ParagraphType newType = ParagraphType.NONE;
            for (SingleParagraphStyle style : styles) {
                newIndent += style.getIndentation();
                ParagraphType type = style.getType();
                newType = type.isBullet() ? ParagraphType.BULLET : (type.isNumbering() ? ParagraphType.NUMBERING : (type.isIndentation() && newType.isUndefined() ? ParagraphType.INDENTATION_UL : newType));
            }
            this.processLeadingMarginStyle(new AccumulatedParagraphStyle(newType, newIndent, 0));
            this.mOut.append(newType.getListStartTag());
            if (alignmentType != null) {
                this.mOut.append(alignmentType.getStartTag());
            }
            this.withinParagraph(this.mText, paragraph.start(), paragraph.end());
            if (alignmentType != null) {
                this.removeTrailingLineBreak(alignmentType);
                this.mOut.append(alignmentType.getEndTag());
            }
            this.removeTrailingLineBreak(newType);
            this.mOut.append(newType.getListEndTag());
        }
        while (!this.mParagraphStyles.isEmpty()) {
            this.removeParagraph();
        }
    }

    private void removeTrailingLineBreak(ParagraphType type) {
        int end;
        int start;
        if (type.endTagAddsLineBreak() && this.mOut.length() >= BR.length() && this.mOut.subSequence(start = this.mOut.length() - BR.length(), end = this.mOut.length()).equals(BR)) {
            this.mOut.delete(start, end);
        }
    }

    private Set<SingleParagraphStyle> getParagraphStyles(Spanned text, Selection selection) {
        HashSet<SingleParagraphStyle> styles = new HashSet<SingleParagraphStyle>();
        for (ParagraphStyle style : (ParagraphStyle[])text.getSpans(selection.start(), selection.end(), ParagraphStyle.class)) {
            ParagraphType type = ParagraphType.getInstance(style);
            if (type == null) continue;
            styles.add(new SingleParagraphStyle(type, style));
        }
        return styles;
    }

    private void processLeadingMarginStyle(AccumulatedParagraphStyle newStyle) {
        int currentIndent = 0;
        ParagraphType currentType = ParagraphType.NONE;
        if (!this.mParagraphStyles.isEmpty()) {
            AccumulatedParagraphStyle currentStyle = this.mParagraphStyles.peek();
            currentIndent = currentStyle.getAbsoluteIndent();
            currentType = currentStyle.getType();
        }
        if (newStyle.getAbsoluteIndent() > currentIndent) {
            newStyle.setRelativeIndent(newStyle.getAbsoluteIndent() - currentIndent);
            this.addParagraph(newStyle);
        } else if (newStyle.getAbsoluteIndent() < currentIndent) {
            this.removeParagraph();
            this.processLeadingMarginStyle(newStyle);
        } else if (newStyle.getType() != currentType) {
            newStyle.setRelativeIndent(this.removeParagraph());
            this.addParagraph(newStyle);
        }
    }

    private int removeParagraph() {
        if (!this.mParagraphStyles.isEmpty()) {
            AccumulatedParagraphStyle style = this.mParagraphStyles.pop();
            String tag = style.getType().getEndTag();
            int indent = style.getRelativeIndent();
            for (int i = 0; i < indent; ++i) {
                this.mOut.append(tag);
            }
            return style.getRelativeIndent();
        }
        return 0;
    }

    private void addParagraph(AccumulatedParagraphStyle style) {
        String tag = style.getType().getStartTag();
        int indent = style.getRelativeIndent();
        for (int i = 0; i < indent; ++i) {
            this.mOut.append(tag);
        }
        this.mParagraphStyles.push(style);
    }

    private void withinParagraph(Spanned text, int start, int end) {
        TreeSet<CharacterStyle> sortedSpans = new TreeSet<CharacterStyle>((s1, s2) -> {
            int end2;
            int start2;
            int start1 = text.getSpanStart(s1);
            if (start1 != (start2 = text.getSpanStart(s2))) {
                return start1 - start2;
            }
            int end1 = text.getSpanEnd(s1);
            if (end1 != (end2 = text.getSpanEnd(s2))) {
                return end2 - end1;
            }
            return s1.getClass().getName().compareTo(s2.getClass().getName());
        });
        List<CharacterStyle> spanList = Arrays.asList((CharacterStyle[])text.getSpans(start, end, CharacterStyle.class));
        sortedSpans.addAll(spanList);
        this.convertText(text, start, end, sortedSpans);
    }

    private void convertText(Spanned text, int start, int end, SortedSet<CharacterStyle> spans) {
        while (start < end) {
            int spanEnd;
            CharacterStyle span = spans.isEmpty() ? null : spans.first();
            int spanStart = span == null ? Integer.MAX_VALUE : text.getSpanStart((Object)span);
            int n = spanEnd = span == null ? Integer.MAX_VALUE : text.getSpanEnd((Object)span);
            if (start < spanStart) {
                this.escape((CharSequence)text, start, Math.min(end, spanStart));
                start = spanStart;
                continue;
            }
            spans.remove(span);
            if (this.handleStartTag(span)) {
                this.convertText(text, Math.max(spanStart, start), Math.min(spanEnd, end), spans);
            }
            this.handleEndTag(span);
            start = spanEnd;
        }
    }

    private boolean handleStartTag(CharacterStyle style) {
        if (style instanceof BoldSpan) {
            this.mOut.append("<b>");
        } else if (style instanceof ItalicSpan) {
            this.mOut.append("<i>");
        } else if (style instanceof UnderlineSpan) {
            this.mOut.append("<u>");
        } else if (style instanceof SuperscriptSpan) {
            this.mOut.append("<sup>");
        } else if (style instanceof SubscriptSpan) {
            this.mOut.append("<sub>");
        } else if (style instanceof StrikethroughSpan) {
            this.mOut.append("<strike>");
        } else if (style instanceof TypefaceSpan) {
            this.mOut.append("<font face=\"");
            String fontName = ((TypefaceSpan)style).getValue().getName();
            this.mOut.append(StringEscapeUtils.escapeHtml4(fontName));
            this.mOut.append("\">");
        } else if (style instanceof AbsoluteSizeSpan) {
            this.mOut.append("<font style=\"font-size:");
            int size = ((AbsoluteSizeSpan)style).getSize();
            size = Helper.convertSpToPx(size);
            this.mOut.append(size);
            this.mOut.append("px\">");
        } else if (style instanceof ForegroundColorSpan) {
            this.mOut.append("<font style=\"color:#");
            String color = Integer.toHexString(((ForegroundColorSpan)style).getForegroundColor() + 0x1000000);
            while (color.length() < 6) {
                color = "0" + color;
            }
            this.mOut.append(color);
            this.mOut.append("\">");
        } else if (style instanceof BackgroundColorSpan) {
            this.mOut.append("<font style=\"background-color:#");
            String color = Integer.toHexString(((BackgroundColorSpan)style).getBackgroundColor() + 0x1000000);
            while (color.length() < 6) {
                color = "0" + color;
            }
            this.mOut.append(color);
            this.mOut.append("\">");
        } else if (style instanceof LinkSpan) {
            this.mOut.append("<a href=\"");
            this.mOut.append(((URLSpan)style).getURL());
            this.mOut.append("\">");
        } else {
            if (style instanceof ImageSpan) {
                ImageSpan span = (ImageSpan)style;
                RTImage image = span.getImage();
                this.mImages.add(image);
                String filePath = image.getFilePath(this.mRTFormat);
                this.mOut.append("<img src=\"" + filePath + "\">");
                return false;
            }
            if (style instanceof AudioSpan) {
                AudioSpan span = (AudioSpan)style;
                RTAudio audio = span.getAudio();
                String filePath = audio.getFilePath(this.mRTFormat);
                this.mOut.append("<embed src=\"" + filePath + "\">");
                return false;
            }
            if (style instanceof VideoSpan) {
                VideoSpan span = (VideoSpan)style;
                RTVideo video = span.getVideo();
                String filePath = video.getFilePath(this.mRTFormat);
                this.mOut.append("<video controls src=\"" + filePath + "\">");
                return false;
            }
        }
        return true;
    }

    private void handleEndTag(CharacterStyle style) {
        if (style instanceof URLSpan) {
            this.mOut.append("</a>");
        } else if (style instanceof TypefaceSpan) {
            this.mOut.append("</font>");
        } else if (style instanceof ForegroundColorSpan) {
            this.mOut.append("</font>");
        } else if (style instanceof BackgroundColorSpan) {
            this.mOut.append("</font>");
        } else if (style instanceof AbsoluteSizeSpan) {
            this.mOut.append("</font>");
        } else if (style instanceof StrikethroughSpan) {
            this.mOut.append("</strike>");
        } else if (style instanceof SubscriptSpan) {
            this.mOut.append("</sub>");
        } else if (style instanceof SuperscriptSpan) {
            this.mOut.append("</sup>");
        } else if (style instanceof UnderlineSpan) {
            this.mOut.append("</u>");
        } else if (style instanceof BoldSpan) {
            this.mOut.append("</b>");
        } else if (style instanceof ItalicSpan) {
            this.mOut.append("</i>");
        }
    }

    private void escape(CharSequence text, int start, int end) {
        for (int i = start; i < end; ++i) {
            char c = text.charAt(i);
            if (c == '\n') {
                this.mOut.append(BR);
                continue;
            }
            if (c == '<') {
                this.mOut.append(LT);
                continue;
            }
            if (c == '>') {
                this.mOut.append(GT);
                continue;
            }
            if (c == '&') {
                this.mOut.append(AMP);
                continue;
            }
            if (c == ' ') {
                while (i + 1 < end && text.charAt(i + 1) == ' ') {
                    this.mOut.append(NBSP);
                    ++i;
                }
                this.mOut.append(' ');
                continue;
            }
            if (c < ' ') {
                this.mOut.append("&#" + c + ";");
                continue;
            }
            this.mOut.append(c);
        }
    }
}

