/*
 * Decompiled with CFR 0.152.
 */
package com.onegravity.rteditor.converter;

import android.annotation.SuppressLint;
import android.text.Layout;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.TextUtils;
import android.text.style.QuoteSpan;
import android.text.style.RelativeSizeSpan;
import com.onegravity.rteditor.api.RTMediaFactory;
import com.onegravity.rteditor.api.format.RTFormat;
import com.onegravity.rteditor.api.format.RTHtml;
import com.onegravity.rteditor.api.format.RTSpanned;
import com.onegravity.rteditor.api.media.RTAudio;
import com.onegravity.rteditor.api.media.RTImage;
import com.onegravity.rteditor.api.media.RTVideo;
import com.onegravity.rteditor.converter.AccumulatedParagraphStyle;
import com.onegravity.rteditor.converter.ParagraphType;
import com.onegravity.rteditor.converter.tagsoup.HTMLSchema;
import com.onegravity.rteditor.converter.tagsoup.Parser;
import com.onegravity.rteditor.fonts.FontManager;
import com.onegravity.rteditor.fonts.RTTypeface;
import com.onegravity.rteditor.spans.AbsoluteSizeSpan;
import com.onegravity.rteditor.spans.AlignmentSpan;
import com.onegravity.rteditor.spans.BackgroundColorSpan;
import com.onegravity.rteditor.spans.BoldSpan;
import com.onegravity.rteditor.spans.BulletSpan;
import com.onegravity.rteditor.spans.ForegroundColorSpan;
import com.onegravity.rteditor.spans.ImageSpan;
import com.onegravity.rteditor.spans.IndentationSpan;
import com.onegravity.rteditor.spans.ItalicSpan;
import com.onegravity.rteditor.spans.LinkSpan;
import com.onegravity.rteditor.spans.NumberSpan;
import com.onegravity.rteditor.spans.RTParagraphSpan;
import com.onegravity.rteditor.spans.StrikethroughSpan;
import com.onegravity.rteditor.spans.SubscriptSpan;
import com.onegravity.rteditor.spans.SuperscriptSpan;
import com.onegravity.rteditor.spans.TypefaceSpan;
import com.onegravity.rteditor.spans.UnderlineSpan;
import com.onegravity.rteditor.utils.Helper;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public class ConverterHtmlToSpanned
implements ContentHandler {
    private static final float[] HEADER_SIZES = new float[]{1.5f, 1.4f, 1.3f, 1.2f, 1.1f, 1.0f};
    private String mSource;
    private RTMediaFactory<? extends RTImage, ? extends RTAudio, ? extends RTVideo> mMediaFactory;
    private Parser mParser;
    private SpannableStringBuilder mResult;
    private Stack<AccumulatedParagraphStyle> mParagraphStyles = new Stack();
    private boolean mIgnoreContent;
    private static final Set<String> sIgnoreTags = new HashSet<String>();
    private static final Pattern FONT_SIZE;
    private static final Pattern FONT_COLOR;
    private static HashMap<String, Integer> COLORS;

    public RTSpanned convert(RTHtml<? extends RTImage, ? extends RTAudio, ? extends RTVideo> input, RTMediaFactory<? extends RTImage, ? extends RTAudio, ? extends RTVideo> mediaFactory) {
        this.mSource = input.getText();
        this.mMediaFactory = mediaFactory;
        this.mParser = new Parser();
        try {
            this.mParser.setProperty("http://www.ccil.org/~cowan/tagsoup/properties/schema", HtmlParser.SCHEMA);
        }
        catch (SAXNotRecognizedException shouldNotHappen) {
            throw new RuntimeException(shouldNotHappen);
        }
        catch (SAXNotSupportedException shouldNotHappen) {
            throw new RuntimeException(shouldNotHappen);
        }
        this.mResult = new SpannableStringBuilder();
        this.mIgnoreContent = false;
        this.mParagraphStyles.clear();
        this.mParser.setContentHandler(this);
        try {
            this.mParser.parse(new InputSource(new StringReader(this.mSource)));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
        this.removeTrailingLineBreaks();
        for (TemporarySpan span : (TemporarySpan[])this.mResult.getSpans(0, this.mResult.length(), TemporarySpan.class)) {
            span.swapIn(this.mResult);
        }
        return new RTSpanned((Spanned)this.mResult);
    }

    private void removeTrailingLineBreaks() {
        int end;
        for (end = this.mResult.length(); end > 0 && this.mResult.charAt(end - 1) == '\n'; --end) {
        }
        if (end < this.mResult.length()) {
            this.mResult = SpannableStringBuilder.valueOf((CharSequence)this.mResult.subSequence(0, end));
        }
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.handleStartTag(localName, attributes);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        this.handleEndTag(localName);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.mIgnoreContent) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            char c = ch[i + start];
            if (c == ' ' || c == '\n') {
                int len = sb.length();
                int pred = len == 0 ? ((len = this.mResult.length()) == 0 ? 10 : (int)this.mResult.charAt(len - 1)) : sb.charAt(len - 1);
                if (pred == 32 || pred == 10) continue;
                sb.append(' ');
                continue;
            }
            sb.append(c);
        }
        this.mResult.append((CharSequence)sb);
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
    }

    private void handleStartTag(String tag, Attributes attributes) {
        if (!tag.equalsIgnoreCase("br")) {
            if (tag.equalsIgnoreCase("p")) {
                this.handleP();
            } else if (tag.equalsIgnoreCase("div")) {
                this.startDiv(attributes);
            } else if (tag.equalsIgnoreCase("ul")) {
                this.startList(false, attributes);
            } else if (tag.equalsIgnoreCase("ol")) {
                this.startList(true, attributes);
            } else if (tag.equalsIgnoreCase("li")) {
                this.startList(attributes);
            } else if (tag.equalsIgnoreCase("strong")) {
                this.start(new Bold());
            } else if (tag.equalsIgnoreCase("b")) {
                this.start(new Bold());
            } else if (tag.equalsIgnoreCase("em")) {
                this.start(new Italic());
            } else if (tag.equalsIgnoreCase("cite")) {
                this.start(new Italic());
            } else if (tag.equalsIgnoreCase("dfn")) {
                this.start(new Italic());
            } else if (tag.equalsIgnoreCase("i")) {
                this.start(new Italic());
            } else if (tag.equalsIgnoreCase("strike")) {
                this.start(new Strikethrough());
            } else if (tag.equalsIgnoreCase("del")) {
                this.start(new Strikethrough());
            } else if (tag.equalsIgnoreCase("big")) {
                this.start(new Big());
            } else if (tag.equalsIgnoreCase("small")) {
                this.start(new Small());
            } else if (tag.equalsIgnoreCase("font")) {
                this.startFont(attributes);
            } else if (tag.equalsIgnoreCase("blockquote")) {
                this.handleP();
                this.start(new Blockquote());
            } else if (tag.equalsIgnoreCase("tt")) {
                this.start(new Monospace());
            } else if (tag.equalsIgnoreCase("a")) {
                this.startAHref(attributes);
            } else if (tag.equalsIgnoreCase("u")) {
                this.start(new Underline());
            } else if (tag.equalsIgnoreCase("sup")) {
                this.start(new Super());
            } else if (tag.equalsIgnoreCase("sub")) {
                this.start(new Sub());
            } else if (tag.length() == 2 && Character.toLowerCase(tag.charAt(0)) == 'h' && tag.charAt(1) >= '1' && tag.charAt(1) <= '6') {
                this.handleP();
                this.start(new Header(tag.charAt(1) - 49));
            } else if (tag.equalsIgnoreCase("img")) {
                this.startImg(attributes);
            } else if (tag.equalsIgnoreCase("video")) {
                this.startVideo(attributes);
            } else if (tag.equalsIgnoreCase("embed")) {
                this.startAudio(attributes);
            } else if (sIgnoreTags.contains(tag.toLowerCase(Locale.getDefault()))) {
                this.mIgnoreContent = true;
            }
        }
    }

    private void handleEndTag(String tag) {
        if (tag.equalsIgnoreCase("br")) {
            this.handleBr();
        } else if (tag.equalsIgnoreCase("p")) {
            this.handleP();
        } else if (tag.equalsIgnoreCase("div")) {
            this.endDiv();
        } else if (tag.equalsIgnoreCase("ul")) {
            this.endList(false);
        } else if (tag.equalsIgnoreCase("ol")) {
            this.endList(true);
        } else if (tag.equalsIgnoreCase("li")) {
            this.endList();
        } else if (tag.equalsIgnoreCase("strong")) {
            this.end(Bold.class, new BoldSpan());
        } else if (tag.equalsIgnoreCase("b")) {
            this.end(Bold.class, new BoldSpan());
        } else if (tag.equalsIgnoreCase("em")) {
            this.end(Italic.class, new ItalicSpan());
        } else if (tag.equalsIgnoreCase("cite")) {
            this.end(Italic.class, new ItalicSpan());
        } else if (tag.equalsIgnoreCase("dfn")) {
            this.end(Italic.class, new ItalicSpan());
        } else if (tag.equalsIgnoreCase("i")) {
            this.end(Italic.class, new ItalicSpan());
        } else if (tag.equalsIgnoreCase("strike")) {
            this.end(Strikethrough.class, new StrikethroughSpan());
        } else if (tag.equalsIgnoreCase("del")) {
            this.end(Strikethrough.class, new StrikethroughSpan());
        } else if (tag.equalsIgnoreCase("big")) {
            int size = Helper.convertPxToSp(32);
            this.end(Big.class, new AbsoluteSizeSpan(size));
        } else if (tag.equalsIgnoreCase("small")) {
            int size = Helper.convertPxToSp(14);
            this.end(Small.class, new AbsoluteSizeSpan(size));
        } else if (tag.equalsIgnoreCase("font")) {
            this.endFont();
        } else if (tag.equalsIgnoreCase("blockquote")) {
            this.handleP();
            this.end(Blockquote.class, new QuoteSpan());
        } else if (tag.equalsIgnoreCase("a")) {
            this.endAHref();
        } else if (tag.equalsIgnoreCase("u")) {
            this.end(Underline.class, new UnderlineSpan());
        } else if (tag.equalsIgnoreCase("sup")) {
            this.end(Super.class, new SuperscriptSpan());
        } else if (tag.equalsIgnoreCase("sub")) {
            this.end(Sub.class, new SubscriptSpan());
        } else if (tag.length() == 2 && Character.toLowerCase(tag.charAt(0)) == 'h' && tag.charAt(1) >= '1' && tag.charAt(1) <= '6') {
            this.handleP();
            this.endHeader();
        } else if (sIgnoreTags.contains(tag.toLowerCase(Locale.getDefault()))) {
            this.mIgnoreContent = false;
        }
    }

    private void startDiv(Attributes attributes) {
        String sAlign = attributes.getValue("align");
        int len = this.mResult.length();
        this.mResult.setSpan((Object)new Div(sAlign), len, len, 17);
    }

    private void endDiv() {
        int end = this.mResult.length();
        Object obj = this.getLast((Spanned)this.mResult, Div.class);
        int start = this.mResult.getSpanStart(obj);
        this.mResult.removeSpan(obj);
        if (start != end && !this.checkDuplicateSpan(this.mResult, start, AlignmentSpan.class)) {
            Layout.Alignment align;
            Div divObj = (Div)obj;
            Layout.Alignment alignment = divObj.mAlign.equalsIgnoreCase("center") ? Layout.Alignment.ALIGN_CENTER : (align = divObj.mAlign.equalsIgnoreCase("right") ? Layout.Alignment.ALIGN_OPPOSITE : Layout.Alignment.ALIGN_NORMAL);
            if (align != null) {
                if (this.mResult.charAt(end - 1) != '\n') {
                    this.mResult.append('\n');
                }
                boolean isRTL = Helper.isRTL((CharSequence)this.mResult, start, end);
                this.mResult.setSpan((Object)new AlignmentSpan(align, isRTL), start, end, 33);
            }
        }
    }

    private void startList(boolean isOrderedList, Attributes attributes) {
        AccumulatedParagraphStyle currentStyle;
        boolean isIndentation = this.isIndentation(attributes);
        ParagraphType newType = isIndentation && isOrderedList ? ParagraphType.INDENTATION_OL : (isIndentation && !isOrderedList ? ParagraphType.INDENTATION_UL : (isOrderedList ? ParagraphType.NUMBERING : ParagraphType.BULLET));
        AccumulatedParagraphStyle accumulatedParagraphStyle = currentStyle = this.mParagraphStyles.isEmpty() ? null : this.mParagraphStyles.peek();
        if (currentStyle == null) {
            AccumulatedParagraphStyle newStyle = new AccumulatedParagraphStyle(newType, 1, 1);
            this.mParagraphStyles.push(newStyle);
        } else if (currentStyle.getType() == newType) {
            currentStyle.setAbsoluteIndent(currentStyle.getAbsoluteIndent() + 1);
            currentStyle.setRelativeIndent(currentStyle.getRelativeIndent() + 1);
        } else {
            AccumulatedParagraphStyle newStyle = new AccumulatedParagraphStyle(newType, currentStyle.getAbsoluteIndent() + 1, 1);
            this.mParagraphStyles.push(newStyle);
        }
    }

    private void endList(boolean orderedList) {
        if (!this.mParagraphStyles.isEmpty()) {
            AccumulatedParagraphStyle style = this.mParagraphStyles.peek();
            ParagraphType type = style.getType();
            if (orderedList && (type.isNumbering() || type == ParagraphType.INDENTATION_OL) || !orderedList && (type.isBullet() || type == ParagraphType.INDENTATION_UL)) {
                int indent = style.getRelativeIndent();
                if (indent > 1) {
                    style.setRelativeIndent(indent - 1);
                    style.setAbsoluteIndent(style.getAbsoluteIndent() - 1);
                } else {
                    this.mParagraphStyles.pop();
                }
            } else {
                this.mParagraphStyles.pop();
                this.endList(orderedList);
            }
        }
    }

    private void startList(Attributes attributes) {
        List listTag = null;
        if (!this.mParagraphStyles.isEmpty()) {
            AccumulatedParagraphStyle currentStyle = this.mParagraphStyles.peek();
            ParagraphType type = currentStyle.getType();
            int indent = currentStyle.getAbsoluteIndent();
            boolean isIndentation = this.isIndentation(attributes);
            if (type.isIndentation() || isIndentation) {
                listTag = new UL(indent, true);
            } else if (type.isNumbering()) {
                listTag = new OL(indent, false);
            } else if (type.isBullet()) {
                listTag = new UL(indent, false);
            }
        } else {
            listTag = new UL(0, false);
        }
        if (listTag != null) {
            this.start(listTag);
        }
    }

    private void endList() {
        List list = (List)this.getLast(List.class);
        if (list != null) {
            RTParagraphSpan<Integer> span;
            int margin;
            if (this.mResult.length() == 0 || this.mResult.charAt(this.mResult.length() - 1) != '\n') {
                this.mResult.append('\n');
            }
            int start = this.mResult.getSpanStart((Object)list);
            int end = this.mResult.length();
            int nrOfIndents = list.mNrOfIndents;
            if (!list.mIsIndentation) {
                --nrOfIndents;
                margin = Helper.getLeadingMarging();
                span = list instanceof UL ? new BulletSpan(margin, start == end, false, false) : new NumberSpan(1, margin, start == end, false, false);
                this.mResult.setSpan((Object)span, start, end, 33);
            }
            if (nrOfIndents > 0) {
                margin = nrOfIndents * Helper.getLeadingMarging();
                span = new IndentationSpan(margin, start == end, false, false);
                this.mResult.setSpan((Object)span, start, end, 33);
            }
            this.mResult.removeSpan((Object)list);
        }
    }

    private boolean isIndentation(Attributes attributes) {
        String style = attributes.getValue("style");
        return style != null && style.toLowerCase(Locale.US).contains("list-style-type:none");
    }

    private boolean checkDuplicateSpan(SpannableStringBuilder text, int where, Class<?> kind) {
        Object[] spans = text.getSpans(where, where, kind);
        if (spans != null && spans.length > 0) {
            for (int i = 0; i < spans.length; ++i) {
                if (text.getSpanStart(spans[i]) != where) continue;
                return true;
            }
        }
        return false;
    }

    private Object getLast(Spanned text, Class<?> kind) {
        Object[] objs = text.getSpans(0, text.length(), kind);
        return objs.length == 0 ? null : objs[objs.length - 1];
    }

    private void handleP() {
        int len = this.mResult.length();
        if (len >= 1 && this.mResult.charAt(len - 1) == '\n') {
            if (len < 2 || this.mResult.charAt(len - 2) != '\n') {
                this.mResult.append((CharSequence)"\n");
            }
        } else if (len != 0) {
            this.mResult.append((CharSequence)"\n\n");
        }
    }

    private void handleBr() {
        this.mResult.append((CharSequence)"\n");
    }

    private Object getLast(Class<? extends Object> kind) {
        Object[] objs = this.mResult.getSpans(0, this.mResult.length(), kind);
        return objs.length == 0 ? null : objs[objs.length - 1];
    }

    private void start(Object mark) {
        int len = this.mResult.length();
        this.mResult.setSpan(mark, len, len, 17);
    }

    private void end(Class<? extends Object> kind, Object repl) {
        int len = this.mResult.length();
        Object obj = this.getLast(kind);
        int where = this.mResult.getSpanStart(obj);
        this.mResult.removeSpan(obj);
        if (where != len) {
            this.mResult.setSpan((Object)new TemporarySpan(repl), where, len, 33);
        }
    }

    private void startImg(Attributes attributes) {
        int len = this.mResult.length();
        String src = attributes.getValue("", "src");
        RTImage image = this.mMediaFactory.createImage(src);
        if (image != null && image.exists()) {
            String path = image.getFilePath(RTFormat.SPANNED);
            File file = new File(path);
            if (file.isDirectory()) {
                return;
            }
            this.mResult.append((CharSequence)"\ufffc");
            ImageSpan imageSpan = new ImageSpan(image, true);
            this.mResult.setSpan((Object)imageSpan, len, len + 1, 33);
        }
    }

    private void startVideo(Attributes attributes) {
    }

    private void startAudio(Attributes attributes) {
    }

    private void startFont(Attributes attributes) {
        int size = Integer.MIN_VALUE;
        String fgColor = null;
        String bgColor = null;
        String fontName = null;
        String style = attributes.getValue("", "style");
        if (style != null) {
            for (String part : style.toLowerCase(Locale.ENGLISH).split(";")) {
                int end;
                int start;
                Matcher matcher;
                if (part.startsWith("font-size")) {
                    matcher = FONT_SIZE.matcher(part);
                    if (!matcher.find(0)) continue;
                    start = matcher.start();
                    end = matcher.end();
                    try {
                        size = Integer.parseInt(part.substring(start, end));
                    }
                    catch (NumberFormatException numberFormatException) {}
                    continue;
                }
                if (part.startsWith("color")) {
                    matcher = FONT_COLOR.matcher(part);
                    if (!matcher.find(0)) continue;
                    start = matcher.start();
                    end = matcher.end();
                    fgColor = part.substring(start, end);
                    continue;
                }
                if (!part.startsWith("background-color") || !(matcher = FONT_COLOR.matcher(part)).find(0)) continue;
                start = matcher.start();
                end = matcher.end();
                bgColor = part.substring(start, end);
            }
        }
        fontName = attributes.getValue("", "face");
        int len = this.mResult.length();
        Font font = new Font().setSize(size).setFGColor(fgColor).setBGColor(bgColor).setFontFace(fontName);
        this.mResult.setSpan((Object)font, len, len, 17);
    }

    private void endFont() {
        int len = this.mResult.length();
        Object obj = this.getLast(Font.class);
        int where = this.mResult.getSpanStart(obj);
        this.mResult.removeSpan(obj);
        if (where != len) {
            int c;
            TemporarySpan span;
            RTTypeface typeface;
            Font font = (Font)obj;
            if (font.hasFontFace() && (typeface = FontManager.getTypeface(font.mFontFace)) != null) {
                span = new TemporarySpan(new TypefaceSpan(typeface));
                this.mResult.setSpan((Object)span, where, len, 33);
            }
            if (font.hasSize()) {
                int size = Helper.convertPxToSp(font.mSize);
                span = new TemporarySpan(new AbsoluteSizeSpan(size));
                this.mResult.setSpan((Object)span, where, len, 33);
            }
            if (font.hasFGColor() && (c = ConverterHtmlToSpanned.getHtmlColor(font.mFGColor)) != -1) {
                span = new TemporarySpan(new ForegroundColorSpan(c | 0xFF000000));
                this.mResult.setSpan((Object)span, where, len, 33);
            }
            if (font.hasBGColor() && (c = ConverterHtmlToSpanned.getHtmlColor(font.mBGColor)) != -1) {
                span = new TemporarySpan(new BackgroundColorSpan(c | 0xFF000000));
                this.mResult.setSpan((Object)span, where, len, 33);
            }
        }
    }

    private void startAHref(Attributes attributes) {
        String href = attributes.getValue("", "href");
        int len = this.mResult.length();
        this.mResult.setSpan((Object)new Href(href), len, len, 17);
    }

    private void endAHref() {
        int len = this.mResult.length();
        Object obj = this.getLast(Href.class);
        int where = this.mResult.getSpanStart(obj);
        this.mResult.removeSpan(obj);
        if (where != len) {
            Href h = (Href)obj;
            if (h.mHref != null) {
                this.mResult.setSpan((Object)new LinkSpan(h.mHref), where, len, 33);
            }
        }
    }

    private void endHeader() {
        int len;
        Object obj = this.getLast(Header.class);
        int where = this.mResult.getSpanStart(obj);
        this.mResult.removeSpan(obj);
        for (len = this.mResult.length(); len > where && this.mResult.charAt(len - 1) == '\n'; --len) {
        }
        if (where != len) {
            Header h = (Header)obj;
            this.mResult.setSpan((Object)new RelativeSizeSpan(HEADER_SIZES[h.mLevel]), where, len, 33);
            this.mResult.setSpan((Object)new BoldSpan(), where, len, 33);
        }
    }

    @SuppressLint(value={"DefaultLocale"})
    private static int getHtmlColor(String color) {
        Integer i = COLORS.get(color.toLowerCase());
        if (i != null) {
            return i;
        }
        try {
            return ConverterHtmlToSpanned.convertValueToInt(color, -1);
        }
        catch (NumberFormatException nfe) {
            return -1;
        }
    }

    private static final int convertValueToInt(CharSequence charSeq, int defaultValue) {
        if (null == charSeq) {
            return defaultValue;
        }
        String nm = charSeq.toString();
        int sign = 1;
        int index = 0;
        int len = nm.length();
        int base = 10;
        if ('-' == nm.charAt(0)) {
            sign = -1;
            ++index;
        }
        if ('0' == nm.charAt(index)) {
            if (index == len - 1) {
                return 0;
            }
            char c = nm.charAt(index + 1);
            if ('x' == c || 'X' == c) {
                index += 2;
                base = 16;
            } else {
                ++index;
                base = 8;
            }
        } else if ('#' == nm.charAt(index)) {
            ++index;
            base = 16;
        }
        return Integer.parseInt(nm.substring(index), base) * sign;
    }

    static {
        SpannableStringBuilder s = new SpannableStringBuilder((CharSequence)"hello");
        s.append(s.subSequence(0, s.length()));
        sIgnoreTags.add("header");
        sIgnoreTags.add("style");
        sIgnoreTags.add("meta");
        FONT_SIZE = Pattern.compile("\\d+");
        FONT_COLOR = Pattern.compile("#[a-f0-9]+");
        COLORS = new HashMap();
        COLORS.put("aqua", 65535);
        COLORS.put("black", 0);
        COLORS.put("blue", 255);
        COLORS.put("fuchsia", 0xFF00FF);
        COLORS.put("green", 32768);
        COLORS.put("grey", 0x808080);
        COLORS.put("lime", 65280);
        COLORS.put("maroon", 0x800000);
        COLORS.put("navy", 128);
        COLORS.put("olive", 0x808000);
        COLORS.put("purple", 0x800080);
        COLORS.put("red", 0xFF0000);
        COLORS.put("silver", 0xC0C0C0);
        COLORS.put("teal", 32896);
        COLORS.put("white", 0xFFFFFF);
        COLORS.put("yellow", 0xFFFF00);
    }

    private static class Header {
        int mLevel;

        Header(int level) {
            this.mLevel = level;
        }
    }

    private static class Href {
        String mHref;

        Href(String href) {
            this.mHref = href;
        }
    }

    private static class Font {
        int mSize = Integer.MIN_VALUE;
        String mFGColor;
        String mBGColor;
        String mFontFace;

        private Font() {
        }

        Font setSize(int size) {
            this.mSize = size;
            return this;
        }

        Font setFGColor(String color) {
            this.mFGColor = color;
            return this;
        }

        Font setBGColor(String color) {
            this.mBGColor = color;
            return this;
        }

        private Font setFontFace(String fontFace) {
            this.mFontFace = fontFace;
            return this;
        }

        boolean hasSize() {
            return this.mSize > 0;
        }

        boolean hasFGColor() {
            return !TextUtils.isEmpty((CharSequence)this.mFGColor);
        }

        boolean hasBGColor() {
            return !TextUtils.isEmpty((CharSequence)this.mBGColor);
        }

        boolean hasFontFace() {
            return !TextUtils.isEmpty((CharSequence)this.mFontFace);
        }
    }

    private static class OL
    extends List {
        OL(int nrOfIndents, boolean isIndentation) {
            super(nrOfIndents, isIndentation);
        }
    }

    private static class UL
    extends List {
        UL(int nrOfIndents, boolean isIndentation) {
            super(nrOfIndents, isIndentation);
        }
    }

    private static abstract class List {
        int mNrOfIndents;
        boolean mIsIndentation;

        List(int nrOfIndents, boolean isIndentation) {
            this.mNrOfIndents = nrOfIndents;
            this.mIsIndentation = isIndentation;
        }
    }

    private static class Blockquote {
        private Blockquote() {
        }
    }

    private static class Monospace {
        private Monospace() {
        }
    }

    private static class Small {
        private Small() {
        }
    }

    private static class Big {
        private Big() {
        }
    }

    private static class Sub {
        private Sub() {
        }
    }

    private static class Super {
        private Super() {
        }
    }

    private static class Strikethrough {
        private Strikethrough() {
        }
    }

    private static class Underline {
        private Underline() {
        }
    }

    private static class Italic {
        private Italic() {
        }
    }

    private static class Bold {
        private Bold() {
        }
    }

    private static class Div {
        String mAlign = "left";

        Div(String align) {
            if (align != null) {
                this.mAlign = align;
            }
        }
    }

    private static class TemporarySpan {
        Object mSpan;

        TemporarySpan(Object span) {
            this.mSpan = span;
        }

        void swapIn(SpannableStringBuilder builder) {
            int start = builder.getSpanStart((Object)this);
            int end = builder.getSpanEnd((Object)this);
            builder.removeSpan((Object)this);
            if (start >= 0 && end > start && end <= builder.length()) {
                builder.setSpan(this.mSpan, start, end, 34);
            }
        }
    }

    private static class HtmlParser {
        private static final HTMLSchema SCHEMA = new HTMLSchema();

        private HtmlParser() {
        }
    }
}

