/*
 * Decompiled with CFR 0.152.
 */
package com.onegravity.rteditor;

import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.text.Editable;
import android.text.Layout;
import android.text.Spannable;
import android.view.ViewGroup;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.widget.EditText;
import com.onegravity.rteditor.LinkFragment;
import com.onegravity.rteditor.R;
import com.onegravity.rteditor.RTEditText;
import com.onegravity.rteditor.RTEditTextListener;
import com.onegravity.rteditor.RTOperationManager;
import com.onegravity.rteditor.RTToolbar;
import com.onegravity.rteditor.RTToolbarListener;
import com.onegravity.rteditor.api.RTApi;
import com.onegravity.rteditor.api.media.RTImage;
import com.onegravity.rteditor.api.media.RTMedia;
import com.onegravity.rteditor.effects.AbsoluteSizeEffect;
import com.onegravity.rteditor.effects.AlignmentEffect;
import com.onegravity.rteditor.effects.BackgroundColorEffect;
import com.onegravity.rteditor.effects.BoldEffect;
import com.onegravity.rteditor.effects.BulletEffect;
import com.onegravity.rteditor.effects.Effect;
import com.onegravity.rteditor.effects.Effects;
import com.onegravity.rteditor.effects.ForegroundColorEffect;
import com.onegravity.rteditor.effects.ItalicEffect;
import com.onegravity.rteditor.effects.NumberEffect;
import com.onegravity.rteditor.effects.SpanCollectMode;
import com.onegravity.rteditor.effects.StrikethroughEffect;
import com.onegravity.rteditor.effects.SubscriptEffect;
import com.onegravity.rteditor.effects.SuperscriptEffect;
import com.onegravity.rteditor.effects.TypefaceEffect;
import com.onegravity.rteditor.effects.UnderlineEffect;
import com.onegravity.rteditor.fonts.RTTypeface;
import com.onegravity.rteditor.media.choose.MediaChooserActivity;
import com.onegravity.rteditor.media.choose.MediaEvent;
import com.onegravity.rteditor.spans.ImageSpan;
import com.onegravity.rteditor.spans.LinkSpan;
import com.onegravity.rteditor.spans.RTSpan;
import com.onegravity.rteditor.utils.Constants;
import com.onegravity.rteditor.utils.Helper;
import com.onegravity.rteditor.utils.Selection;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;
import org.greenrobot.eventbus.ThreadMode;

public class RTManager
implements RTToolbarListener,
RTEditTextListener {
    private static final String ID_01_LINK_FRAGMENT = "ID_01_LINK_FRAGMENT";
    private ToolbarVisibility mToolbarVisibility = ToolbarVisibility.AUTOMATIC;
    private boolean mToolbarIsVisible;
    private int mActiveEditor = Integer.MAX_VALUE;
    private Selection mLinkSelection;
    private final transient Handler mHandler;
    private transient boolean mIsPendingFocusLoss;
    private transient boolean mCancelPendingFocusLoss;
    private final transient Map<Integer, RTEditText> mEditors;
    private final transient Map<Integer, RTToolbar> mToolbars;
    private transient RTApi mRTApi;
    private final transient RTOperationManager mOPManager;

    public RTManager(RTApi rtApi, Bundle savedInstanceState) {
        this.mRTApi = rtApi;
        this.mHandler = new Handler();
        this.mEditors = new ConcurrentHashMap<Integer, RTEditText>();
        this.mToolbars = new ConcurrentHashMap<Integer, RTToolbar>();
        this.mOPManager = new RTOperationManager();
        if (savedInstanceState != null) {
            String tmp = savedInstanceState.getString("mToolbarVisibility");
            if (tmp != null) {
                this.mToolbarVisibility = ToolbarVisibility.valueOf(tmp);
            }
            this.mToolbarIsVisible = savedInstanceState.getBoolean("mToolbarIsVisible");
            this.mActiveEditor = savedInstanceState.getInt("mActiveEditor");
            this.mLinkSelection = (Selection)savedInstanceState.getSerializable("mLinkSelection");
        }
        EventBus.getDefault().register((Object)this);
    }

    public void onSaveInstanceState(Bundle outState) {
        outState.putString("mToolbarVisibility", this.mToolbarVisibility.name());
        outState.putBoolean("mToolbarIsVisible", this.mToolbarIsVisible);
        outState.putInt("mActiveEditor", this.mActiveEditor);
        if (this.mLinkSelection != null) {
            outState.putSerializable("mLinkSelection", (Serializable)this.mLinkSelection);
        }
    }

    public void onDestroy(boolean isSaved) {
        EventBus.getDefault().unregister((Object)this);
        for (RTEditText editor : this.mEditors.values()) {
            editor.unregister();
            editor.onDestroy(isSaved);
        }
        this.mEditors.clear();
        for (RTToolbar toolbar : this.mToolbars.values()) {
            toolbar.removeToolbarListener();
        }
        this.mToolbars.clear();
        this.mRTApi = null;
    }

    public void registerEditor(RTEditText editor, boolean useRichTextEditing) {
        this.mEditors.put(editor.getId(), editor);
        editor.register(this, this.mRTApi);
        editor.setRichTextEditing(useRichTextEditing, false);
        this.updateToolbarVisibility();
    }

    public void unregisterEditor(RTEditText editor) {
        this.mEditors.remove(editor.getId());
        editor.unregister();
        this.updateToolbarVisibility();
    }

    public void registerToolbar(ViewGroup toolbarContainer, RTToolbar toolbar) {
        this.mToolbars.put(toolbar.getId(), toolbar);
        toolbar.setToolbarListener(this);
        toolbar.setToolbarContainer(toolbarContainer);
        this.updateToolbarVisibility();
    }

    public void unregisterToolbar(RTToolbar toolbar) {
        this.mToolbars.remove(toolbar.getId());
        toolbar.removeToolbarListener();
        this.updateToolbarVisibility();
    }

    public void setToolbarVisibility(ToolbarVisibility toolbarVisibility) {
        if (this.mToolbarVisibility != toolbarVisibility) {
            this.mToolbarVisibility = toolbarVisibility;
            this.updateToolbarVisibility();
        }
    }

    private void updateToolbarVisibility() {
        boolean showToolbars;
        boolean bl = showToolbars = this.mToolbarVisibility == ToolbarVisibility.SHOW;
        if (this.mToolbarVisibility == ToolbarVisibility.AUTOMATIC) {
            RTEditText editor = this.getActiveEditor();
            showToolbars = editor != null && editor.usesRTFormatting();
        }
        for (RTToolbar toolbar : this.mToolbars.values()) {
            this.setToolbarVisibility(toolbar, showToolbars);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setToolbarVisibility(RTToolbar toolbar, boolean visible) {
        this.mToolbarIsVisible = visible;
        final ViewGroup toolbarContainer = toolbar.getToolbarContainer();
        int visibility = 0;
        ViewGroup viewGroup = toolbarContainer;
        synchronized (viewGroup) {
            visibility = toolbarContainer.getVisibility();
        }
        if (visibility == 8 && visible || visibility == 0 && !visible) {
            AlphaAnimation fadeAnimation = visible ? new AlphaAnimation(0.0f, 1.0f) : new AlphaAnimation(1.0f, 0.0f);
            fadeAnimation.setDuration(400L);
            fadeAnimation.setAnimationListener(new Animation.AnimationListener(){

                public void onAnimationStart(Animation animation) {
                }

                public void onAnimationRepeat(Animation animation) {
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void onAnimationEnd(Animation animation) {
                    ViewGroup viewGroup = toolbarContainer;
                    synchronized (viewGroup) {
                        toolbarContainer.setVisibility(RTManager.this.mToolbarIsVisible ? 0 : 8);
                    }
                }
            });
            toolbarContainer.startAnimation((Animation)fadeAnimation);
        } else {
            toolbarContainer.clearAnimation();
        }
    }

    @Override
    public <V, C extends RTSpan<V>> void onEffectSelected(Effect<V, C> effect, V value) {
        RTEditText editor = this.getActiveEditor();
        if (editor != null) {
            editor.applyEffect(effect, value);
        }
    }

    @Override
    public void onClearFormatting() {
        RTEditText editor = this.getActiveEditor();
        if (editor != null) {
            int selStartBefore = editor.getSelectionStart();
            int selEndBefore = editor.getSelectionEnd();
            Spannable oldSpannable = editor.cloneSpannable();
            for (Effect effect : Effects.FORMATTING_EFFECTS) {
                effect.clearFormattingInSelection(editor);
            }
            int selStartAfter = editor.getSelectionStart();
            int selEndAfter = editor.getSelectionEnd();
            Spannable newSpannable = editor.cloneSpannable();
            this.mOPManager.executed(editor, new RTOperationManager.TextChangeOperation(oldSpannable, newSpannable, selStartBefore, selEndBefore, selStartAfter, selEndAfter));
        }
    }

    @Override
    public void onUndo() {
        RTEditText editor = this.getActiveEditor();
        if (editor != null) {
            this.mOPManager.undo(editor);
        }
    }

    @Override
    public void onRedo() {
        RTEditText editor = this.getActiveEditor();
        if (editor != null) {
            this.mOPManager.redo(editor);
        }
    }

    @Override
    public void onCreateLink() {
        RTEditText editor = this.getActiveEditor();
        if (editor != null) {
            String url = null;
            String linkText = null;
            List<RTSpan<String>> links = Effects.LINK.getSpans((Spannable)editor.getText(), new Selection((EditText)editor), SpanCollectMode.EXACT);
            if (links.isEmpty()) {
                linkText = editor.getSelectedText();
                try {
                    new URL(linkText);
                    url = linkText;
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
                this.mLinkSelection = editor.getSelection();
            } else {
                RTSpan<String> linkSpan = links.get(0);
                url = linkSpan.getValue();
                linkText = this.getLinkText(editor, linkSpan);
            }
            this.mRTApi.openDialogFragment(ID_01_LINK_FRAGMENT, LinkFragment.newInstance(linkText, url));
        }
    }

    @Override
    public void onPickImage() {
        this.onPickCaptureImage(Constants.MediaAction.PICK_PICTURE);
    }

    @Override
    public void onCaptureImage() {
        this.onPickCaptureImage(Constants.MediaAction.CAPTURE_PICTURE);
    }

    private void onPickCaptureImage(Constants.MediaAction mediaAction) {
        RTEditText editor = this.getActiveEditor();
        if (editor != null && this.mRTApi != null) {
            this.mActiveEditor = editor.getId();
            Intent intent = new Intent(RTApi.getApplicationContext(), MediaChooserActivity.class).putExtra(MediaChooserActivity.EXTRA_MEDIA_ACTION, mediaAction.name()).putExtra(MediaChooserActivity.EXTRA_MEDIA_FACTORY, (Serializable)this.mRTApi);
            this.mRTApi.startActivityForResult(intent, mediaAction.requestCode());
        }
    }

    private void insertImage(RTEditText editor, RTImage image) {
        if (image != null && editor != null) {
            Selection selection = new Selection((EditText)editor);
            Editable str = editor.getText();
            str.insert(selection.start(), (CharSequence)"\ufffc");
            try {
                Spannable oldSpannable = editor.cloneSpannable();
                ImageSpan imageSpan = new ImageSpan(image, false);
                str.setSpan((Object)imageSpan, selection.start(), selection.end() + 1, 33);
                int selStartAfter = editor.getSelectionStart();
                int selEndAfter = editor.getSelectionEnd();
                editor.onAddMedia(image);
                Spannable newSpannable = editor.cloneSpannable();
                this.mOPManager.executed(editor, new RTOperationManager.TextChangeOperation(oldSpannable, newSpannable, selection.start(), selection.end(), selStartAfter, selEndAfter));
            }
            catch (OutOfMemoryError e) {
                str.delete(selection.start(), selection.end() + 1);
                this.mRTApi.makeText(R.string.rte_add_image_error, 1).show();
            }
        }
    }

    private RTEditText getActiveEditor() {
        for (RTEditText editor : this.mEditors.values()) {
            if (!editor.hasFocus()) continue;
            return editor;
        }
        return null;
    }

    @Override
    public void onRestoredInstanceState(RTEditText editor) {
        MediaEvent event = (MediaEvent)EventBus.getDefault().getStickyEvent(MediaEvent.class);
        if (event != null) {
            this.onEventMainThread(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFocusChanged(RTEditText editor, boolean focused) {
        if (editor.usesRTFormatting()) {
            RTManager rTManager = this;
            synchronized (rTManager) {
                if (this.mIsPendingFocusLoss) {
                    this.mCancelPendingFocusLoss = true;
                }
            }
            if (focused) {
                this.changeFocus();
            } else {
                this.mIsPendingFocusLoss = true;
                this.mHandler.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        RTManager.this.changeFocus();
                    }
                }, 10L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void changeFocus() {
        RTManager rTManager = this;
        synchronized (rTManager) {
            if (!this.mCancelPendingFocusLoss) {
                this.updateToolbarVisibility();
            }
            this.mCancelPendingFocusLoss = false;
            this.mIsPendingFocusLoss = false;
        }
    }

    @Override
    public void onSelectionChanged(RTEditText editor, int start, int end) {
        if (editor == null) {
            return;
        }
        boolean isBold = false;
        boolean isItalic = false;
        boolean isUnderLine = false;
        boolean isStrikethrough = false;
        boolean isSuperscript = false;
        boolean isSubscript = false;
        boolean isBullet = false;
        boolean isNumber = false;
        List alignments = null;
        List<RTTypeface> typefaces = null;
        List<Integer> sizes = null;
        List<Integer> fontColors = null;
        List<Integer> bgColors = null;
        for (Effect effect : Effects.ALL_EFFECTS) {
            if (!effect.existsInSelection(editor)) continue;
            if (effect instanceof BoldEffect) {
                isBold = true;
                continue;
            }
            if (effect instanceof ItalicEffect) {
                isItalic = true;
                continue;
            }
            if (effect instanceof UnderlineEffect) {
                isUnderLine = true;
                continue;
            }
            if (effect instanceof StrikethroughEffect) {
                isStrikethrough = true;
                continue;
            }
            if (effect instanceof SuperscriptEffect) {
                isSuperscript = true;
                continue;
            }
            if (effect instanceof SubscriptEffect) {
                isSubscript = true;
                continue;
            }
            if (effect instanceof BulletEffect) {
                isBullet = true;
                continue;
            }
            if (effect instanceof NumberEffect) {
                isNumber = true;
                continue;
            }
            if (effect instanceof AlignmentEffect) {
                alignments = Effects.ALIGNMENT.valuesInSelection(editor);
                continue;
            }
            if (effect instanceof TypefaceEffect) {
                typefaces = Effects.TYPEFACE.valuesInSelection(editor);
                continue;
            }
            if (effect instanceof AbsoluteSizeEffect) {
                sizes = Effects.FONTSIZE.valuesInSelection(editor);
                continue;
            }
            if (effect instanceof ForegroundColorEffect) {
                fontColors = Effects.FONTCOLOR.valuesInSelection(editor);
                continue;
            }
            if (!(effect instanceof BackgroundColorEffect)) continue;
            bgColors = Effects.BGCOLOR.valuesInSelection(editor);
        }
        for (RTToolbar toolbar : this.mToolbars.values()) {
            toolbar.setBold(isBold);
            toolbar.setItalic(isItalic);
            toolbar.setUnderline(isUnderLine);
            toolbar.setStrikethrough(isStrikethrough);
            toolbar.setSuperscript(isSuperscript);
            toolbar.setSubscript(isSubscript);
            toolbar.setBullet(isBullet);
            toolbar.setNumber(isNumber);
            if (alignments != null && alignments.size() == 1) {
                toolbar.setAlignment((Layout.Alignment)alignments.get(0));
            } else {
                boolean isRTL = Helper.isRTL((CharSequence)editor.getText(), start, end);
                toolbar.setAlignment(isRTL ? Layout.Alignment.ALIGN_OPPOSITE : Layout.Alignment.ALIGN_NORMAL);
            }
            if (typefaces != null && typefaces.size() == 1) {
                toolbar.setFont(typefaces.get(0));
            } else {
                toolbar.setFont(null);
            }
            if (sizes == null) {
                toolbar.setFontSize(Math.round(editor.getTextSize()));
            } else if (sizes.size() == 1) {
                toolbar.setFontSize(sizes.get(0));
            } else {
                toolbar.setFontSize(-1);
            }
            if (fontColors != null && fontColors.size() == 1) {
                toolbar.setFontColor(fontColors.get(0));
            } else {
                toolbar.removeFontColor();
            }
            if (bgColors != null && bgColors.size() == 1) {
                toolbar.setBGColor(bgColors.get(0));
                continue;
            }
            toolbar.removeBGColor();
        }
    }

    @Override
    public void onTextChanged(RTEditText editor, Spannable before, Spannable after, int selStartBefore, int selEndBefore, int selStartAfter, int selEndAfter) {
        RTOperationManager.TextChangeOperation op = new RTOperationManager.TextChangeOperation(before, after, selStartBefore, selEndBefore, selStartAfter, selEndAfter);
        this.mOPManager.executed(editor, op);
    }

    @Override
    public void onClick(RTEditText editor, LinkSpan span) {
        if (editor != null) {
            String linkText = this.getLinkText(editor, span);
            this.mRTApi.openDialogFragment(ID_01_LINK_FRAGMENT, LinkFragment.newInstance(linkText, span.getURL()));
        }
    }

    private String getLinkText(RTEditText editor, RTSpan<String> span) {
        Editable text = editor.getText();
        int spanStart = text.getSpanStart(span);
        int spanEnd = text.getSpanEnd(span);
        String linkText = null;
        if (spanStart >= 0 && spanEnd >= 0 && spanEnd <= text.length()) {
            linkText = text.subSequence(spanStart, spanEnd).toString();
            this.mLinkSelection = new Selection(spanStart, spanEnd);
        } else {
            this.mLinkSelection = editor.getSelection();
        }
        return linkText;
    }

    @Subscribe(sticky=true, threadMode=ThreadMode.MAIN)
    public void onEventMainThread(MediaEvent event) {
        RTEditText editor = this.mEditors.get(this.mActiveEditor);
        RTMedia media = event.getMedia();
        if (editor != null && media instanceof RTImage) {
            this.insertImage(editor, (RTImage)media);
            EventBus.getDefault().removeStickyEvent((Object)event);
            this.mActiveEditor = Integer.MAX_VALUE;
        }
    }

    @Subscribe(threadMode=ThreadMode.MAIN)
    public void onEventMainThread(LinkFragment.LinkEvent event) {
        RTEditText editor;
        String fragmentTag = event.getFragmentTag();
        this.mRTApi.removeFragment(fragmentTag);
        if (!event.wasCancelled() && ID_01_LINK_FRAGMENT.equals(fragmentTag) && (editor = this.getActiveEditor()) != null) {
            LinkFragment.Link link = event.getLink();
            String url = null;
            if (link != null && link.isValid()) {
                Selection selection = this.mLinkSelection != null && this.mLinkSelection.end() <= editor.length() ? this.mLinkSelection : new Selection((EditText)editor);
                String linkText = link.getLinkText();
                Editable str = editor.getText();
                str.replace(selection.start(), selection.end(), (CharSequence)linkText);
                editor.setSelection(selection.start(), selection.start() + linkText.length());
                url = link.getUrl();
            }
            editor.applyEffect(Effects.LINK, url);
        }
    }

    @Override
    public void onRichTextEditingChanged(RTEditText editor, boolean useRichText) {
        this.updateToolbarVisibility();
    }

    public static enum ToolbarVisibility {
        AUTOMATIC,
        SHOW,
        HIDE;

    }
}

