/*
 * Decompiled with CFR 0.152.
 */
package com.onegravity.rteditor;

import android.text.SpannableString;
import android.text.Spanned;
import android.text.style.CharacterStyle;
import android.text.style.ParagraphStyle;
import java.lang.reflect.Array;

public class ClonedSpannableString
extends SpannableString {
    private Object[] mSpans;
    private int[] mSpanData;
    private int mSpanCount;
    private static final int START = 0;
    private static final int END = 1;
    private static final int FLAGS = 2;
    private static final int COLUMNS = 3;

    public ClonedSpannableString(Spanned source) {
        this((CharSequence)source);
    }

    public ClonedSpannableString(CharSequence source) {
        super((CharSequence)source.toString());
        this.init(source, 0, source.length());
    }

    private void init(CharSequence source, int start, int end) {
        int initial = 20;
        this.mSpans = new Object[initial];
        this.mSpanData = new int[initial * 3];
        if (source instanceof Spanned) {
            Spanned sp = (Spanned)source;
            for (Object span : sp.getSpans(start, end, Object.class)) {
                if (!(span instanceof CharacterStyle) && !(span instanceof ParagraphStyle)) continue;
                int st = sp.getSpanStart(span);
                int en = sp.getSpanEnd(span);
                int fl = sp.getSpanFlags(span);
                if (st < start) {
                    st = start;
                }
                if (en > end) {
                    en = end;
                }
                this.setSpan(span, st - start, en - start, fl);
            }
        }
    }

    public void setSpan(Object what, int start, int end, int flags) {
        if (this.mSpanCount + 1 >= this.mSpans.length) {
            int newsize = this.mSpanCount + 10;
            Object[] newtags = new Object[newsize];
            int[] newdata = new int[newsize * 3];
            System.arraycopy(this.mSpans, 0, newtags, 0, this.mSpanCount);
            System.arraycopy(this.mSpanData, 0, newdata, 0, this.mSpanCount * 3);
            this.mSpans = newtags;
            this.mSpanData = newdata;
        }
        this.mSpans[this.mSpanCount] = what;
        this.mSpanData[this.mSpanCount * 3 + 0] = start;
        this.mSpanData[this.mSpanCount * 3 + 1] = end;
        this.mSpanData[this.mSpanCount * 3 + 2] = flags;
        ++this.mSpanCount;
    }

    public void removeSpan(Object what) {
        int count = this.mSpanCount;
        Object[] spans = this.mSpans;
        int[] data = this.mSpanData;
        for (int i = count - 1; i >= 0; --i) {
            if (spans[i] != what) continue;
            int c = count - (i + 1);
            System.arraycopy(spans, i + 1, spans, i, c);
            System.arraycopy(data, (i + 1) * 3, data, i * 3, c * 3);
            --this.mSpanCount;
            return;
        }
    }

    public int getSpanStart(Object what) {
        int count = this.mSpanCount;
        Object[] spans = this.mSpans;
        int[] data = this.mSpanData;
        for (int i = count - 1; i >= 0; --i) {
            if (spans[i] != what) continue;
            return data[i * 3 + 0];
        }
        return -1;
    }

    public int getSpanEnd(Object what) {
        int count = this.mSpanCount;
        Object[] spans = this.mSpans;
        int[] data = this.mSpanData;
        for (int i = count - 1; i >= 0; --i) {
            if (spans[i] != what) continue;
            return data[i * 3 + 1];
        }
        return -1;
    }

    public int getSpanFlags(Object what) {
        int count = this.mSpanCount;
        Object[] spans = this.mSpans;
        int[] data = this.mSpanData;
        for (int i = count - 1; i >= 0; --i) {
            if (spans[i] != what) continue;
            return data[i * 3 + 2];
        }
        return 0;
    }

    public <T> T[] getSpans(int queryStart, int queryEnd, Class<T> kind) {
        int count = 0;
        int spanCount = this.mSpanCount;
        Object[] spans = this.mSpans;
        int[] data = this.mSpanData;
        Object[] ret = null;
        Object ret1 = null;
        for (int i = 0; i < spanCount; ++i) {
            int prio;
            if (kind != null && !kind.isInstance(spans[i])) continue;
            int spanStart = data[i * 3 + 0];
            int spanEnd = data[i * 3 + 1];
            if (spanStart > queryEnd || spanEnd < queryStart || spanStart != spanEnd && queryStart != queryEnd && (spanStart == queryEnd || spanEnd == queryStart)) continue;
            if (count == 0) {
                ret1 = spans[i];
                ++count;
                continue;
            }
            if (count == 1) {
                ret = (Object[])Array.newInstance(kind, spanCount - i + 1);
                ret[0] = ret1;
            }
            if ((prio = data[i * 3 + 2] & 0xFF0000) != 0) {
                int p;
                int j;
                for (j = 0; j < count && prio <= (p = this.getSpanFlags(ret[j]) & 0xFF0000); ++j) {
                }
                System.arraycopy(ret, j, ret, j + 1, count - j);
                ret[j] = spans[i];
                ++count;
                continue;
            }
            ret[count++] = spans[i];
        }
        if (count == 0) {
            return (Object[])Array.newInstance(kind, 0);
        }
        if (count == 1) {
            ret = (Object[])Array.newInstance(kind, 1);
            ret[0] = ret1;
            return ret;
        }
        if (count == ret.length) {
            return ret;
        }
        Object[] nret = (Object[])Array.newInstance(kind, count);
        System.arraycopy(ret, 0, nret, 0, count);
        return nret;
    }

    public int nextSpanTransition(int start, int limit, Class kind) {
        int count = this.mSpanCount;
        Object[] spans = this.mSpans;
        int[] data = this.mSpanData;
        if (kind == null) {
            kind = Object.class;
        }
        for (int i = 0; i < count; ++i) {
            int st = data[i * 3 + 0];
            int en = data[i * 3 + 1];
            if (st > start && st < limit && kind.isInstance(spans[i])) {
                limit = st;
            }
            if (en <= start || en >= limit || !kind.isInstance(spans[i])) continue;
            limit = en;
        }
        return limit;
    }
}

