/*
 * Decompiled with CFR 0.152.
 */
package droidninja.filepicker.views;

import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Point;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.LinearInterpolator;
import android.widget.Checkable;
import droidninja.filepicker.R;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0014\n\u0002\u0018\u0002\n\u0002\b\r\u0018\u0000 N2\u00020\u00012\u00020\u0002:\u0002NOB%\b\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tB'\b\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\b\u00a2\u0006\u0002\u0010\u000bJ\u0016\u0010)\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010*\u001a\u00020\u0013J\u0010\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0002J\u0010\u0010/\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0002J\u0010\u00100\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0002J\b\u00101\u001a\u00020,H\u0002J\u0010\u00102\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0002J\u0012\u00103\u001a\u00020,2\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u0002J\b\u00104\u001a\u00020\u0010H\u0016J\u0010\u00105\u001a\u00020\b2\u0006\u00106\u001a\u00020\bH\u0002J\u0010\u00107\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0014J0\u00108\u001a\u00020,2\u0006\u00109\u001a\u00020\u00102\u0006\u0010:\u001a\u00020\b2\u0006\u0010;\u001a\u00020\b2\u0006\u0010<\u001a\u00020\b2\u0006\u0010=\u001a\u00020\bH\u0014J\u0018\u0010>\u001a\u00020,2\u0006\u0010?\u001a\u00020\b2\u0006\u0010@\u001a\u00020\bH\u0014J\u0010\u0010A\u001a\u00020,2\u0006\u0010B\u001a\u00020CH\u0014J\n\u0010D\u001a\u0004\u0018\u00010CH\u0014J\b\u0010E\u001a\u00020,H\u0002J\u0010\u0010F\u001a\u00020,2\u0006\u0010G\u001a\u00020\u0010H\u0016J\u0016\u0010F\u001a\u00020,2\u0006\u0010G\u001a\u00020\u00102\u0006\u0010H\u001a\u00020\u0010J\u0010\u0010I\u001a\u00020,2\b\u0010J\u001a\u0004\u0018\u00010\u001bJ\b\u0010K\u001a\u00020,H\u0002J\b\u0010L\u001a\u00020,H\u0002J\b\u0010M\u001a\u00020,H\u0016R\u000e\u0010\f\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010!\u001a\u0004\u0018\u00010\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\"\u001a\u0004\u0018\u00010#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010$\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010%X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010&R\u000e\u0010'\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006P"}, d2={"Ldroidninja/filepicker/views/SmoothCheckBox;", "Landroid/view/View;", "Landroid/widget/Checkable;", "context", "Landroid/content/Context;", "attrs", "Landroid/util/AttributeSet;", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "defStyleRes", "(Landroid/content/Context;Landroid/util/AttributeSet;II)V", "mAnimDuration", "mCenterPoint", "Landroid/graphics/Point;", "mChecked", "", "mCheckedColor", "mDrewDistance", "", "mFloorColor", "mFloorPaint", "Landroid/graphics/Paint;", "mFloorScale", "mFloorUnCheckedColor", "mLeftLineDistance", "mListener", "Ldroidninja/filepicker/views/SmoothCheckBox$OnCheckedChangeListener;", "mPaint", "mRightLineDistance", "mScaleVal", "mStrokeWidth", "mTickDrawing", "mTickPaint", "mTickPath", "Landroid/graphics/Path;", "mTickPoints", "", "[Landroid/graphics/Point;", "mUnCheckedColor", "mWidth", "dp2px", "dipValue", "drawBorder", "", "canvas", "Landroid/graphics/Canvas;", "drawCenter", "drawTick", "drawTickDelayed", "drawTickPath", "init", "isChecked", "measureSize", "measureSpec", "onDraw", "onLayout", "changed", "left", "top", "right", "bottom", "onMeasure", "widthMeasureSpec", "heightMeasureSpec", "onRestoreInstanceState", "state", "Landroid/os/Parcelable;", "onSaveInstanceState", "reset", "setChecked", "checked", "animate", "setOnCheckedChangeListener", "l", "startCheckedAnimation", "startUnCheckedAnimation", "toggle", "Companion", "OnCheckedChangeListener", "filepicker_release"})
public final class SmoothCheckBox
extends View
implements Checkable {
    private Paint mPaint;
    private Paint mTickPaint;
    private Paint mFloorPaint;
    private Point[] mTickPoints;
    private Point mCenterPoint;
    private Path mTickPath;
    private float mLeftLineDistance;
    private float mRightLineDistance;
    private float mDrewDistance;
    private float mScaleVal;
    private float mFloorScale;
    private int mWidth;
    private int mAnimDuration;
    private int mStrokeWidth;
    private int mCheckedColor;
    private int mUnCheckedColor;
    private int mFloorColor;
    private int mFloorUnCheckedColor;
    private boolean mChecked;
    private boolean mTickDrawing;
    private OnCheckedChangeListener mListener;
    private static final String KEY_INSTANCE_STATE;
    private static final int COLOR_TICK;
    private static final int COLOR_UNCHECKED;
    private static final int COLOR_CHECKED;
    private static final int COLOR_FLOOR_UNCHECKED;
    private static final int DEF_DRAW_SIZE;
    private static final int DEF_ANIM_DURATION;
    public static final Companion Companion;
    private HashMap _$_findViewCache;

    private final void init(AttributeSet attrs) {
        TypedArray typedArray = this.getContext().obtainStyledAttributes(attrs, R.styleable.SmoothCheckBox);
        Intrinsics.checkNotNullExpressionValue((Object)typedArray, (String)"context.obtainStyledAttr\u2026styleable.SmoothCheckBox)");
        TypedArray ta = typedArray;
        int tickColor = ta.getColor(R.styleable.SmoothCheckBox_color_tick, COLOR_TICK);
        this.mAnimDuration = ta.getInt(R.styleable.SmoothCheckBox_duration, DEF_ANIM_DURATION);
        this.mFloorColor = ta.getColor(R.styleable.SmoothCheckBox_color_unchecked_stroke, COLOR_FLOOR_UNCHECKED);
        this.mCheckedColor = ta.getColor(R.styleable.SmoothCheckBox_color_checked, COLOR_CHECKED);
        this.mUnCheckedColor = ta.getColor(R.styleable.SmoothCheckBox_color_unchecked, COLOR_UNCHECKED);
        Context context = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
        this.mStrokeWidth = ta.getDimensionPixelSize(R.styleable.SmoothCheckBox_stroke_width, this.dp2px(context, 0.0f));
        ta.recycle();
        this.mFloorUnCheckedColor = this.mFloorColor;
        Paint paint = this.mTickPaint = new Paint(1);
        Intrinsics.checkNotNull((Object)paint);
        paint.setStyle(Paint.Style.STROKE);
        Paint paint2 = this.mTickPaint;
        Intrinsics.checkNotNull((Object)paint2);
        paint2.setStrokeCap(Paint.Cap.ROUND);
        Paint paint3 = this.mTickPaint;
        Intrinsics.checkNotNull((Object)paint3);
        paint3.setColor(tickColor);
        Paint paint4 = this.mFloorPaint = new Paint(1);
        Intrinsics.checkNotNull((Object)paint4);
        paint4.setStyle(Paint.Style.FILL);
        Paint paint5 = this.mFloorPaint;
        Intrinsics.checkNotNull((Object)paint5);
        paint5.setColor(this.mFloorColor);
        Paint paint6 = this.mPaint = new Paint(1);
        Intrinsics.checkNotNull((Object)paint6);
        paint6.setStyle(Paint.Style.FILL);
        Paint paint7 = this.mPaint;
        Intrinsics.checkNotNull((Object)paint7);
        paint7.setColor(this.mCheckedColor);
        this.mTickPath = new Path();
        this.mCenterPoint = new Point();
        this.mTickPoints = new Point[]{new Point(), new Point(), new Point()};
        this.setOnClickListener(new View.OnClickListener(this){
            final /* synthetic */ SmoothCheckBox this$0;

            public final void onClick(View it) {
                this.this$0.toggle();
                SmoothCheckBox.access$setMTickDrawing$p(this.this$0, false);
                SmoothCheckBox.access$setMDrewDistance$p(this.this$0, 0.0f);
                if (this.this$0.isChecked()) {
                    SmoothCheckBox.access$startCheckedAnimation(this.this$0);
                } else {
                    SmoothCheckBox.access$startUnCheckedAnimation(this.this$0);
                }
            }
            {
                this.this$0 = smoothCheckBox;
            }
        });
    }

    @Nullable
    protected Parcelable onSaveInstanceState() {
        Bundle bundle = new Bundle();
        bundle.putParcelable(KEY_INSTANCE_STATE, super.onSaveInstanceState());
        bundle.putBoolean(KEY_INSTANCE_STATE, this.isChecked());
        return (Parcelable)bundle;
    }

    protected void onRestoreInstanceState(@NotNull Parcelable state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (state instanceof Bundle) {
            boolean isChecked = ((Bundle)state).getBoolean(KEY_INSTANCE_STATE);
            this.setChecked(isChecked);
            super.onRestoreInstanceState(((Bundle)state).getParcelable(KEY_INSTANCE_STATE));
            return;
        }
        super.onRestoreInstanceState(state);
    }

    public boolean isChecked() {
        return this.mChecked;
    }

    public void toggle() {
        this.setChecked(!this.isChecked());
    }

    public void setChecked(boolean checked) {
        this.mChecked = checked;
        this.reset();
        this.invalidate();
        if (this.mListener != null) {
            OnCheckedChangeListener onCheckedChangeListener = this.mListener;
            Intrinsics.checkNotNull((Object)onCheckedChangeListener);
            onCheckedChangeListener.onCheckedChanged(this, this.mChecked);
        }
    }

    public final void setChecked(boolean checked, boolean animate) {
        if (animate) {
            this.mTickDrawing = false;
            this.mChecked = checked;
            this.mDrewDistance = 0.0f;
            if (checked) {
                this.startCheckedAnimation();
            } else {
                this.startUnCheckedAnimation();
            }
            if (this.mListener != null) {
                OnCheckedChangeListener onCheckedChangeListener = this.mListener;
                Intrinsics.checkNotNull((Object)onCheckedChangeListener);
                onCheckedChangeListener.onCheckedChanged(this, this.mChecked);
            }
        } else {
            this.setChecked(checked);
        }
    }

    private final void reset() {
        this.mTickDrawing = true;
        this.mFloorScale = 1.0f;
        this.mScaleVal = this.isChecked() ? 0.0f : 1.0f;
        this.mFloorColor = this.isChecked() ? this.mCheckedColor : this.mFloorUnCheckedColor;
        this.mDrewDistance = this.isChecked() ? this.mLeftLineDistance + this.mRightLineDistance : 0.0f;
    }

    private final int measureSize(int measureSpec) {
        Context context = this.getContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"context");
        int defSize = this.dp2px(context, DEF_DRAW_SIZE);
        int specSize = View.MeasureSpec.getSize((int)measureSpec);
        int specMode = View.MeasureSpec.getMode((int)measureSpec);
        int result = 0;
        switch (specMode) {
            case -2147483648: 
            case 0: {
                result = Math.min(defSize, specSize);
                break;
            }
            case 0x40000000: {
                result = specSize;
                break;
            }
        }
        return result;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.setMeasuredDimension(this.measureSize(widthMeasureSpec), this.measureSize(heightMeasureSpec));
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        this.mWidth = this.getMeasuredWidth();
        this.mStrokeWidth = this.mStrokeWidth == 0 ? this.getMeasuredWidth() / 10 : this.mStrokeWidth;
        this.mStrokeWidth = this.mStrokeWidth > this.getMeasuredWidth() / 5 ? this.getMeasuredWidth() / 5 : this.mStrokeWidth;
        this.mStrokeWidth = this.mStrokeWidth < 3 ? 3 : this.mStrokeWidth;
        Intrinsics.checkNotNull((Object)this.mCenterPoint);
        this.mCenterPoint.x = this.mWidth / 2;
        Intrinsics.checkNotNull((Object)this.mCenterPoint);
        this.mCenterPoint.y = this.getMeasuredHeight() / 2;
        Intrinsics.checkNotNull((Object)this.mTickPoints);
        this.mTickPoints[0].x = Math.round((float)this.getMeasuredWidth() / (float)30 * (float)7);
        Intrinsics.checkNotNull((Object)this.mTickPoints);
        this.mTickPoints[0].y = Math.round((float)this.getMeasuredHeight() / (float)30 * (float)14);
        Intrinsics.checkNotNull((Object)this.mTickPoints);
        this.mTickPoints[1].x = Math.round((float)this.getMeasuredWidth() / (float)30 * (float)13);
        Intrinsics.checkNotNull((Object)this.mTickPoints);
        this.mTickPoints[1].y = Math.round((float)this.getMeasuredHeight() / (float)30 * (float)20);
        Intrinsics.checkNotNull((Object)this.mTickPoints);
        this.mTickPoints[2].x = Math.round((float)this.getMeasuredWidth() / (float)30 * (float)22);
        Intrinsics.checkNotNull((Object)this.mTickPoints);
        this.mTickPoints[2].y = Math.round((float)this.getMeasuredHeight() / (float)30 * (float)10);
        Intrinsics.checkNotNull((Object)this.mTickPoints);
        int n = this.mTickPoints[1].x;
        Intrinsics.checkNotNull((Object)this.mTickPoints);
        double d = Math.pow(n - this.mTickPoints[0].x, 2.0);
        Intrinsics.checkNotNull((Object)this.mTickPoints);
        int n2 = this.mTickPoints[1].y;
        Intrinsics.checkNotNull((Object)this.mTickPoints);
        this.mLeftLineDistance = (float)Math.sqrt(d + Math.pow(n2 - this.mTickPoints[0].y, 2.0));
        Intrinsics.checkNotNull((Object)this.mTickPoints);
        int n3 = this.mTickPoints[2].x;
        Intrinsics.checkNotNull((Object)this.mTickPoints);
        double d2 = Math.pow(n3 - this.mTickPoints[1].x, 2.0);
        Intrinsics.checkNotNull((Object)this.mTickPoints);
        int n4 = this.mTickPoints[2].y;
        Intrinsics.checkNotNull((Object)this.mTickPoints);
        this.mRightLineDistance = (float)Math.sqrt(d2 + Math.pow(n4 - this.mTickPoints[1].y, 2.0));
        Paint paint = this.mTickPaint;
        Intrinsics.checkNotNull((Object)paint);
        paint.setStrokeWidth((float)this.mStrokeWidth);
    }

    protected void onDraw(@NotNull Canvas canvas) {
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        this.drawBorder(canvas);
        this.drawCenter(canvas);
        this.drawTick(canvas);
    }

    private final void drawCenter(Canvas canvas) {
        Paint paint = this.mPaint;
        Intrinsics.checkNotNull((Object)paint);
        paint.setColor(this.mUnCheckedColor);
        Point point = this.mCenterPoint;
        Intrinsics.checkNotNull((Object)point);
        float radius = (float)(point.x - this.mStrokeWidth) * this.mScaleVal;
        Point point2 = this.mCenterPoint;
        Intrinsics.checkNotNull((Object)point2);
        float f = point2.x;
        Point point3 = this.mCenterPoint;
        Intrinsics.checkNotNull((Object)point3);
        float f2 = point3.y;
        Paint paint2 = this.mPaint;
        Intrinsics.checkNotNull((Object)paint2);
        canvas.drawCircle(f, f2, radius, paint2);
    }

    private final void drawBorder(Canvas canvas) {
        Paint paint = this.mFloorPaint;
        Intrinsics.checkNotNull((Object)paint);
        paint.setColor(this.mFloorColor);
        Point point = this.mCenterPoint;
        Intrinsics.checkNotNull((Object)point);
        int radius = point.x;
        Point point2 = this.mCenterPoint;
        Intrinsics.checkNotNull((Object)point2);
        float f = point2.x;
        Point point3 = this.mCenterPoint;
        Intrinsics.checkNotNull((Object)point3);
        float f2 = point3.y;
        float f3 = (float)radius * this.mFloorScale;
        Paint paint2 = this.mFloorPaint;
        Intrinsics.checkNotNull((Object)paint2);
        canvas.drawCircle(f, f2, f3, paint2);
    }

    private final void drawTick(Canvas canvas) {
        if (this.mTickDrawing && this.isChecked()) {
            this.drawTickPath(canvas);
        }
    }

    private final void drawTickPath(Canvas canvas) {
        Path path = this.mTickPath;
        Intrinsics.checkNotNull((Object)path);
        path.reset();
        if (this.mDrewDistance < this.mLeftLineDistance) {
            float step = (float)this.mWidth / 20.0f < (float)3 ? 3.0f : (float)this.mWidth / 20.0f;
            this.mDrewDistance += step;
            Intrinsics.checkNotNull((Object)this.mTickPoints);
            float f = this.mTickPoints[0].x;
            Intrinsics.checkNotNull((Object)this.mTickPoints);
            int n = this.mTickPoints[1].x;
            Intrinsics.checkNotNull((Object)this.mTickPoints);
            float stopX = f + (float)(n - this.mTickPoints[0].x) * this.mDrewDistance / this.mLeftLineDistance;
            Intrinsics.checkNotNull((Object)this.mTickPoints);
            float f2 = this.mTickPoints[0].y;
            Intrinsics.checkNotNull((Object)this.mTickPoints);
            int n2 = this.mTickPoints[1].y;
            Intrinsics.checkNotNull((Object)this.mTickPoints);
            float stopY = f2 + (float)(n2 - this.mTickPoints[0].y) * this.mDrewDistance / this.mLeftLineDistance;
            Path path2 = this.mTickPath;
            Intrinsics.checkNotNull((Object)path2);
            Intrinsics.checkNotNull((Object)this.mTickPoints);
            float f3 = this.mTickPoints[0].x;
            Intrinsics.checkNotNull((Object)this.mTickPoints);
            path2.moveTo(f3, (float)this.mTickPoints[0].y);
            Path path3 = this.mTickPath;
            Intrinsics.checkNotNull((Object)path3);
            path3.lineTo(stopX, stopY);
            Path path4 = this.mTickPath;
            Intrinsics.checkNotNull((Object)path4);
            Paint paint = this.mTickPaint;
            Intrinsics.checkNotNull((Object)paint);
            canvas.drawPath(path4, paint);
            if (this.mDrewDistance > this.mLeftLineDistance) {
                this.mDrewDistance = this.mLeftLineDistance;
            }
        } else {
            Path path5 = this.mTickPath;
            Intrinsics.checkNotNull((Object)path5);
            Intrinsics.checkNotNull((Object)this.mTickPoints);
            float f = this.mTickPoints[0].x;
            Intrinsics.checkNotNull((Object)this.mTickPoints);
            path5.moveTo(f, (float)this.mTickPoints[0].y);
            Path path6 = this.mTickPath;
            Intrinsics.checkNotNull((Object)path6);
            Intrinsics.checkNotNull((Object)this.mTickPoints);
            float f4 = this.mTickPoints[1].x;
            Intrinsics.checkNotNull((Object)this.mTickPoints);
            path6.lineTo(f4, (float)this.mTickPoints[1].y);
            Path path7 = this.mTickPath;
            Intrinsics.checkNotNull((Object)path7);
            Paint paint = this.mTickPaint;
            Intrinsics.checkNotNull((Object)paint);
            canvas.drawPath(path7, paint);
            if (this.mDrewDistance < this.mLeftLineDistance + this.mRightLineDistance) {
                Intrinsics.checkNotNull((Object)this.mTickPoints);
                float f5 = this.mTickPoints[1].x;
                Intrinsics.checkNotNull((Object)this.mTickPoints);
                int n = this.mTickPoints[2].x;
                Intrinsics.checkNotNull((Object)this.mTickPoints);
                float stopX = f5 + (float)(n - this.mTickPoints[1].x) * (this.mDrewDistance - this.mLeftLineDistance) / this.mRightLineDistance;
                Intrinsics.checkNotNull((Object)this.mTickPoints);
                float f6 = this.mTickPoints[1].y;
                Intrinsics.checkNotNull((Object)this.mTickPoints);
                int n3 = this.mTickPoints[1].y;
                Intrinsics.checkNotNull((Object)this.mTickPoints);
                float stopY = f6 - (float)(n3 - this.mTickPoints[2].y) * (this.mDrewDistance - this.mLeftLineDistance) / this.mRightLineDistance;
                Path path8 = this.mTickPath;
                Intrinsics.checkNotNull((Object)path8);
                path8.reset();
                Path path9 = this.mTickPath;
                Intrinsics.checkNotNull((Object)path9);
                Intrinsics.checkNotNull((Object)this.mTickPoints);
                float f7 = this.mTickPoints[1].x;
                Intrinsics.checkNotNull((Object)this.mTickPoints);
                path9.moveTo(f7, (float)this.mTickPoints[1].y);
                Path path10 = this.mTickPath;
                Intrinsics.checkNotNull((Object)path10);
                path10.lineTo(stopX, stopY);
                Path path11 = this.mTickPath;
                Intrinsics.checkNotNull((Object)path11);
                Paint paint2 = this.mTickPaint;
                Intrinsics.checkNotNull((Object)paint2);
                canvas.drawPath(path11, paint2);
                float step = this.mWidth / 20 < 3 ? 3 : this.mWidth / 20;
                this.mDrewDistance += step;
            } else {
                Path path12 = this.mTickPath;
                Intrinsics.checkNotNull((Object)path12);
                path12.reset();
                Path path13 = this.mTickPath;
                Intrinsics.checkNotNull((Object)path13);
                Intrinsics.checkNotNull((Object)this.mTickPoints);
                float f8 = this.mTickPoints[1].x;
                Intrinsics.checkNotNull((Object)this.mTickPoints);
                path13.moveTo(f8, (float)this.mTickPoints[1].y);
                Path path14 = this.mTickPath;
                Intrinsics.checkNotNull((Object)path14);
                Intrinsics.checkNotNull((Object)this.mTickPoints);
                float f9 = this.mTickPoints[2].x;
                Intrinsics.checkNotNull((Object)this.mTickPoints);
                path14.lineTo(f9, (float)this.mTickPoints[2].y);
                Path path15 = this.mTickPath;
                Intrinsics.checkNotNull((Object)path15);
                Paint paint3 = this.mTickPaint;
                Intrinsics.checkNotNull((Object)paint3);
                canvas.drawPath(path15, paint3);
            }
        }
        if (this.mDrewDistance < this.mLeftLineDistance + this.mRightLineDistance) {
            this.postDelayed(new Runnable(this){
                final /* synthetic */ SmoothCheckBox this$0;

                public final void run() {
                    this.this$0.postInvalidate();
                }
                {
                    this.this$0 = smoothCheckBox;
                }
            }, 10L);
        }
    }

    private final void startCheckedAnimation() {
        ValueAnimator floorAnimator;
        ValueAnimator animator;
        ValueAnimator valueAnimator = animator = ValueAnimator.ofFloat((float[])new float[]{1.0f, 0.0f});
        Intrinsics.checkNotNullExpressionValue((Object)valueAnimator, (String)"animator");
        valueAnimator.setDuration((long)(this.mAnimDuration / 3 * 2));
        animator.setInterpolator((TimeInterpolator)new LinearInterpolator());
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(this){
            final /* synthetic */ SmoothCheckBox this$0;

            public final void onAnimationUpdate(ValueAnimator animation) {
                ValueAnimator valueAnimator = animation;
                Intrinsics.checkNotNullExpressionValue((Object)valueAnimator, (String)"animation");
                Object object = valueAnimator.getAnimatedValue();
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
                }
                SmoothCheckBox.access$setMScaleVal$p(this.this$0, ((Float)object).floatValue());
                SmoothCheckBox.access$setMFloorColor$p(this.this$0, droidninja.filepicker.views.SmoothCheckBox$Companion.access$getGradientColor(SmoothCheckBox.Companion, SmoothCheckBox.access$getMUnCheckedColor$p(this.this$0), SmoothCheckBox.access$getMCheckedColor$p(this.this$0), 1.0f - SmoothCheckBox.access$getMScaleVal$p(this.this$0)));
                this.this$0.postInvalidate();
            }
            {
                this.this$0 = smoothCheckBox;
            }
        });
        animator.start();
        ValueAnimator valueAnimator2 = floorAnimator = ValueAnimator.ofFloat((float[])new float[]{1.0f, 0.8f, 1.0f});
        Intrinsics.checkNotNullExpressionValue((Object)valueAnimator2, (String)"floorAnimator");
        valueAnimator2.setDuration((long)this.mAnimDuration);
        floorAnimator.setInterpolator((TimeInterpolator)new LinearInterpolator());
        floorAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(this){
            final /* synthetic */ SmoothCheckBox this$0;

            public final void onAnimationUpdate(ValueAnimator animation) {
                ValueAnimator valueAnimator = animation;
                Intrinsics.checkNotNullExpressionValue((Object)valueAnimator, (String)"animation");
                Object object = valueAnimator.getAnimatedValue();
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
                }
                SmoothCheckBox.access$setMFloorScale$p(this.this$0, ((Float)object).floatValue());
                this.this$0.postInvalidate();
            }
            {
                this.this$0 = smoothCheckBox;
            }
        });
        floorAnimator.start();
        this.drawTickDelayed();
    }

    private final void startUnCheckedAnimation() {
        ValueAnimator floorAnimator;
        ValueAnimator animator;
        ValueAnimator valueAnimator = animator = ValueAnimator.ofFloat((float[])new float[]{0.0f, 1.0f});
        Intrinsics.checkNotNullExpressionValue((Object)valueAnimator, (String)"animator");
        valueAnimator.setDuration((long)this.mAnimDuration);
        animator.setInterpolator((TimeInterpolator)new LinearInterpolator());
        animator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(this){
            final /* synthetic */ SmoothCheckBox this$0;

            public final void onAnimationUpdate(ValueAnimator animation) {
                ValueAnimator valueAnimator = animation;
                Intrinsics.checkNotNullExpressionValue((Object)valueAnimator, (String)"animation");
                Object object = valueAnimator.getAnimatedValue();
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
                }
                SmoothCheckBox.access$setMScaleVal$p(this.this$0, ((Float)object).floatValue());
                SmoothCheckBox.access$setMFloorColor$p(this.this$0, droidninja.filepicker.views.SmoothCheckBox$Companion.access$getGradientColor(SmoothCheckBox.Companion, SmoothCheckBox.access$getMCheckedColor$p(this.this$0), SmoothCheckBox.access$getCOLOR_FLOOR_UNCHECKED$cp(), SmoothCheckBox.access$getMScaleVal$p(this.this$0)));
                this.this$0.postInvalidate();
            }
            {
                this.this$0 = smoothCheckBox;
            }
        });
        animator.start();
        ValueAnimator valueAnimator2 = floorAnimator = ValueAnimator.ofFloat((float[])new float[]{1.0f, 0.8f, 1.0f});
        Intrinsics.checkNotNullExpressionValue((Object)valueAnimator2, (String)"floorAnimator");
        valueAnimator2.setDuration((long)this.mAnimDuration);
        floorAnimator.setInterpolator((TimeInterpolator)new LinearInterpolator());
        floorAnimator.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(this){
            final /* synthetic */ SmoothCheckBox this$0;

            public final void onAnimationUpdate(ValueAnimator animation) {
                ValueAnimator valueAnimator = animation;
                Intrinsics.checkNotNullExpressionValue((Object)valueAnimator, (String)"animation");
                Object object = valueAnimator.getAnimatedValue();
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Float");
                }
                SmoothCheckBox.access$setMFloorScale$p(this.this$0, ((Float)object).floatValue());
                this.this$0.postInvalidate();
            }
            {
                this.this$0 = smoothCheckBox;
            }
        });
        floorAnimator.start();
    }

    private final void drawTickDelayed() {
        this.postDelayed(new Runnable(this){
            final /* synthetic */ SmoothCheckBox this$0;

            public final void run() {
                SmoothCheckBox.access$setMTickDrawing$p(this.this$0, true);
                this.this$0.postInvalidate();
            }
            {
                this.this$0 = smoothCheckBox;
            }
        }, this.mAnimDuration);
    }

    public final void setOnCheckedChangeListener(@Nullable OnCheckedChangeListener l) {
        this.mListener = l;
    }

    public final int dp2px(@NotNull Context context, float dipValue) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Resources resources = context.getResources();
        Intrinsics.checkNotNullExpressionValue((Object)resources, (String)"context.resources");
        float scale = resources.getDisplayMetrics().density;
        return (int)(dipValue * scale + 0.5f);
    }

    @JvmOverloads
    public SmoothCheckBox(@NotNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context, attrs, defStyleAttr);
        this.mScaleVal = 1.0f;
        this.mFloorScale = 1.0f;
        this.init(attrs);
    }

    public /* synthetic */ SmoothCheckBox(Context context, AttributeSet attributeSet, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            attributeSet = null;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        this(context, attributeSet, n);
    }

    @JvmOverloads
    public SmoothCheckBox(@NotNull Context context, @Nullable AttributeSet attrs) {
        this(context, attrs, 0, 4, null);
    }

    @JvmOverloads
    public SmoothCheckBox(@NotNull Context context) {
        this(context, null, 0, 6, null);
    }

    @TargetApi(value=21)
    public SmoothCheckBox(@NotNull Context context, @NotNull AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
        super(context, attrs, defStyleAttr, defStyleRes);
        this.mScaleVal = 1.0f;
        this.mFloorScale = 1.0f;
        this.init(attrs);
    }

    static {
        Companion = new Companion(null);
        KEY_INSTANCE_STATE = "InstanceState";
        COLOR_TICK = -1;
        COLOR_UNCHECKED = -1;
        COLOR_CHECKED = Color.parseColor((String)"#FB4846");
        COLOR_FLOOR_UNCHECKED = Color.parseColor((String)"#DFDFDF");
        DEF_DRAW_SIZE = 25;
        DEF_ANIM_DURATION = 300;
    }

    public static final /* synthetic */ boolean access$getMTickDrawing$p(SmoothCheckBox $this) {
        return $this.mTickDrawing;
    }

    public static final /* synthetic */ void access$setMTickDrawing$p(SmoothCheckBox $this, boolean bl) {
        $this.mTickDrawing = bl;
    }

    public static final /* synthetic */ float access$getMDrewDistance$p(SmoothCheckBox $this) {
        return $this.mDrewDistance;
    }

    public static final /* synthetic */ void access$setMDrewDistance$p(SmoothCheckBox $this, float f) {
        $this.mDrewDistance = f;
    }

    public static final /* synthetic */ void access$startCheckedAnimation(SmoothCheckBox $this) {
        $this.startCheckedAnimation();
    }

    public static final /* synthetic */ void access$startUnCheckedAnimation(SmoothCheckBox $this) {
        $this.startUnCheckedAnimation();
    }

    public static final /* synthetic */ float access$getMScaleVal$p(SmoothCheckBox $this) {
        return $this.mScaleVal;
    }

    public static final /* synthetic */ void access$setMScaleVal$p(SmoothCheckBox $this, float f) {
        $this.mScaleVal = f;
    }

    public static final /* synthetic */ int access$getMFloorColor$p(SmoothCheckBox $this) {
        return $this.mFloorColor;
    }

    public static final /* synthetic */ void access$setMFloorColor$p(SmoothCheckBox $this, int n) {
        $this.mFloorColor = n;
    }

    public static final /* synthetic */ int access$getMUnCheckedColor$p(SmoothCheckBox $this) {
        return $this.mUnCheckedColor;
    }

    public static final /* synthetic */ void access$setMUnCheckedColor$p(SmoothCheckBox $this, int n) {
        $this.mUnCheckedColor = n;
    }

    public static final /* synthetic */ int access$getMCheckedColor$p(SmoothCheckBox $this) {
        return $this.mCheckedColor;
    }

    public static final /* synthetic */ void access$setMCheckedColor$p(SmoothCheckBox $this, int n) {
        $this.mCheckedColor = n;
    }

    public static final /* synthetic */ float access$getMFloorScale$p(SmoothCheckBox $this) {
        return $this.mFloorScale;
    }

    public static final /* synthetic */ void access$setMFloorScale$p(SmoothCheckBox $this, float f) {
        $this.mFloorScale = f;
    }

    public static final /* synthetic */ int access$getCOLOR_FLOOR_UNCHECKED$cp() {
        return COLOR_FLOOR_UNCHECKED;
    }

    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\bf\u0018\u00002\u00020\u0001J\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&\u00a8\u0006\b"}, d2={"Ldroidninja/filepicker/views/SmoothCheckBox$OnCheckedChangeListener;", "", "onCheckedChanged", "", "checkBox", "Ldroidninja/filepicker/views/SmoothCheckBox;", "isChecked", "", "filepicker_release"})
    public static interface OnCheckedChangeListener {
        public void onCheckedChanged(@NotNull SmoothCheckBox var1, boolean var2);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Ldroidninja/filepicker/views/SmoothCheckBox$Companion;", "", "()V", "COLOR_CHECKED", "", "COLOR_FLOOR_UNCHECKED", "COLOR_TICK", "COLOR_UNCHECKED", "DEF_ANIM_DURATION", "DEF_DRAW_SIZE", "KEY_INSTANCE_STATE", "", "getGradientColor", "startColor", "endColor", "percent", "", "filepicker_release"})
    public static final class Companion {
        private final int getGradientColor(int startColor, int endColor, float percent) {
            int sr = (startColor & 0xFF0000) >> 16;
            int sg = (startColor & 0xFF00) >> 8;
            int sb = startColor & 0xFF;
            int er = (endColor & 0xFF0000) >> 16;
            int eg = (endColor & 0xFF00) >> 8;
            int eb = endColor & 0xFF;
            int cr = (int)((float)sr * (1.0f - percent) + (float)er * percent);
            int cg = (int)((float)sg * (1.0f - percent) + (float)eg * percent);
            int cb = (int)((float)sb * (1.0f - percent) + (float)eb * percent);
            return Color.argb((int)255, (int)cr, (int)cg, (int)cb);
        }

        private Companion() {
        }

        public static final /* synthetic */ int access$getGradientColor(Companion $this, int startColor, int endColor, float percent) {
            return $this.getGradientColor(startColor, endColor, percent);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

