/*
 * Decompiled with CFR 0.152.
 */
package droidninja.filepicker;

import android.annotation.SuppressLint;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import androidx.appcompat.app.ActionBar;
import droidninja.filepicker.BaseFilePickerActivity;
import droidninja.filepicker.PickerManager;
import droidninja.filepicker.R;
import droidninja.filepicker.fragments.DocFragment;
import droidninja.filepicker.fragments.DocPickerFragment;
import droidninja.filepicker.fragments.MediaPickerFragment;
import droidninja.filepicker.fragments.PhotoPickerFragmentListener;
import droidninja.filepicker.utils.FragmentUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 $2\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u00042\u00020\u0005:\u0001$B\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\t\u001a\u00020\nH\u0014J\"\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0014J\b\u0010\u0010\u001a\u00020\nH\u0016J\u0012\u0010\u0011\u001a\u00020\n2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0015J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\b\u0010\u0018\u001a\u00020\nH\u0014J\b\u0010\u0019\u001a\u00020\nH\u0016J\u0010\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010\u001d\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0016\u0010\u001e\u001a\u00020\n2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 H\u0002J\u0010\u0010\"\u001a\u00020\n2\u0006\u0010#\u001a\u00020\bH\u0016R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Ldroidninja/filepicker/FilePickerActivity;", "Ldroidninja/filepicker/BaseFilePickerActivity;", "Ldroidninja/filepicker/fragments/PhotoPickerFragmentListener;", "Ldroidninja/filepicker/fragments/DocFragment$DocFragmentListener;", "Ldroidninja/filepicker/fragments/DocPickerFragment$DocPickerFragmentListener;", "Ldroidninja/filepicker/fragments/MediaPickerFragment$MediaPickerFragmentListener;", "()V", "type", "", "initView", "", "onActivityResult", "requestCode", "resultCode", "data", "Landroid/content/Intent;", "onBackPressed", "onCreate", "savedInstanceState", "Landroid/os/Bundle;", "onCreateOptionsMenu", "", "menu", "Landroid/view/Menu;", "onDestroy", "onItemSelected", "onOptionsItemSelected", "item", "Landroid/view/MenuItem;", "openSpecificFragment", "returnData", "paths", "Ljava/util/ArrayList;", "Landroid/net/Uri;", "setToolbarTitle", "count", "Companion", "filepicker_release"})
public final class FilePickerActivity
extends BaseFilePickerActivity
implements PhotoPickerFragmentListener,
DocFragment.DocFragmentListener,
DocPickerFragment.DocPickerFragmentListener,
MediaPickerFragment.MediaPickerFragmentListener {
    private int type;
    private static final String TAG;
    public static final Companion Companion;
    private HashMap _$_findViewCache;

    @SuppressLint(value={"MissingSuperCall"})
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState, R.layout.activity_file_picker);
    }

    @Override
    protected void initView() {
        Intent intent2 = this.getIntent();
        if (intent2 != null) {
            ArrayList selectedPaths = intent2.getParcelableArrayListExtra("SELECTED_PHOTOS");
            this.type = intent2.getIntExtra("EXTRA_PICKER_TYPE", 17);
            if (selectedPaths != null) {
                if (PickerManager.INSTANCE.getMaxCount() == 1) {
                    selectedPaths.clear();
                }
                PickerManager.INSTANCE.clearSelections();
                if (this.type == 17) {
                    PickerManager.INSTANCE.add(selectedPaths, 1);
                } else {
                    PickerManager.INSTANCE.add(selectedPaths, 2);
                }
            }
            this.setToolbarTitle(PickerManager.INSTANCE.getCurrentCount());
            this.openSpecificFragment(this.type);
        }
    }

    @Override
    public void setToolbarTitle(int count) {
        ActionBar actionBar = this.getSupportActionBar();
        if (actionBar != null) {
            int maxCount = PickerManager.INSTANCE.getMaxCount();
            if (maxCount == -1 && count > 0) {
                StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                String string2 = this.getString(R.string.attachments_num);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(R.string.attachments_num)");
                String string3 = string2;
                Object[] objectArray = new Object[]{count};
                boolean bl = false;
                String string4 = String.format(string3, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"java.lang.String.format(format, *args)");
                actionBar.setTitle((CharSequence)string4);
            } else if (maxCount > 0 && count > 0) {
                StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                String string5 = this.getString(R.string.attachments_title_text);
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getString(R.string.attachments_title_text)");
                String string6 = string5;
                Object[] objectArray = new Object[]{count, maxCount};
                boolean bl = false;
                String string7 = String.format(string6, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"java.lang.String.format(format, *args)");
                actionBar.setTitle((CharSequence)string7);
            } else if (!TextUtils.isEmpty((CharSequence)PickerManager.INSTANCE.getTitle())) {
                actionBar.setTitle((CharSequence)PickerManager.INSTANCE.getTitle());
            } else if (this.type == 17) {
                actionBar.setTitle(R.string.select_photo_text);
            } else {
                actionBar.setTitle(R.string.select_doc_text);
            }
        }
    }

    private final void openSpecificFragment(int type) {
        if (type == 17) {
            MediaPickerFragment photoFragment = MediaPickerFragment.Companion.newInstance();
            FragmentUtil.INSTANCE.replaceFragment(this, R.id.container, photoFragment);
        } else {
            if (PickerManager.INSTANCE.isDocSupport()) {
                PickerManager.INSTANCE.addDocTypes();
            }
            DocPickerFragment photoFragment = DocPickerFragment.Companion.newInstance();
            FragmentUtil.INSTANCE.replaceFragment(this, R.id.container, photoFragment);
        }
    }

    public boolean onCreateOptionsMenu(@NotNull Menu menu2) {
        Intrinsics.checkNotNullParameter((Object)menu2, (String)"menu");
        this.getMenuInflater().inflate(R.menu.picker_menu, menu2);
        MenuItem menuItem = menu2.findItem(R.id.action_done);
        if (menuItem != null) {
            menuItem.setVisible(PickerManager.INSTANCE.getMaxCount() != 1);
        }
        return super.onCreateOptionsMenu(menu2);
    }

    public boolean onOptionsItemSelected(@NotNull MenuItem item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        int i = item.getItemId();
        if (i == R.id.action_done) {
            if (this.type == 17) {
                this.returnData(PickerManager.INSTANCE.getSelectedPhotos());
            } else {
                this.returnData(PickerManager.INSTANCE.getSelectedFiles());
            }
            return true;
        }
        if (i == 16908332) {
            this.onBackPressed();
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    public void onBackPressed() {
        super.onBackPressed();
        this.setResult(0);
        this.finish();
    }

    protected void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        switch (requestCode) {
            case 235: {
                if (resultCode == -1) {
                    if (this.type == 17) {
                        this.returnData(PickerManager.INSTANCE.getSelectedPhotos());
                        break;
                    }
                    this.returnData(PickerManager.INSTANCE.getSelectedFiles());
                    break;
                }
                this.setToolbarTitle(PickerManager.INSTANCE.getCurrentCount());
                break;
            }
        }
    }

    private final void returnData(ArrayList<Uri> paths) {
        Intent intent2 = new Intent();
        if (this.type == 17) {
            intent2.putParcelableArrayListExtra("SELECTED_PHOTOS", paths);
        } else {
            intent2.putParcelableArrayListExtra("SELECTED_DOCS", paths);
        }
        this.setResult(-1, intent2);
        this.finish();
    }

    protected void onDestroy() {
        PickerManager.INSTANCE.reset();
        super.onDestroy();
    }

    @Override
    public void onItemSelected() {
        int currentCount = PickerManager.INSTANCE.getCurrentCount();
        this.setToolbarTitle(currentCount);
        if (PickerManager.INSTANCE.getMaxCount() == 1 && currentCount == 1) {
            this.returnData(this.type == 17 ? PickerManager.INSTANCE.getSelectedPhotos() : PickerManager.INSTANCE.getSelectedFiles());
        }
    }

    static {
        Companion = new Companion(null);
        TAG = FilePickerActivity.class.getSimpleName();
    }

    @Override
    public View _$_findCachedViewById(int n) {
        View view;
        if (this._$_findViewCache == null) {
            this._$_findViewCache = new HashMap();
        }
        if ((view = (View)this._$_findViewCache.get(n)) == null) {
            view = this.findViewById(n);
            this._$_findViewCache.put(n, view);
        }
        return view;
    }

    @Override
    public void _$_clearFindViewByIdCache() {
        if (this._$_findViewCache != null) {
            this._$_findViewCache.clear();
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Ldroidninja/filepicker/FilePickerActivity$Companion;", "", "()V", "TAG", "", "kotlin.jvm.PlatformType", "filepicker_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

