/*
 * Decompiled with CFR 0.152.
 */
package droidninja.filepicker;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.view.Menu;
import android.view.MenuItem;
import android.widget.TextView;
import androidx.appcompat.app.ActionBar;
import androidx.fragment.app.FragmentActivity;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.ViewModel;
import androidx.lifecycle.ViewModelProvider;
import androidx.lifecycle.ViewModelStoreOwner;
import androidx.recyclerview.widget.DefaultItemAnimator;
import androidx.recyclerview.widget.RecyclerView;
import androidx.recyclerview.widget.StaggeredGridLayoutManager;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestManager;
import droidninja.filepicker.BaseFilePickerActivity;
import droidninja.filepicker.FilePickerConst;
import droidninja.filepicker.PickerManager;
import droidninja.filepicker.R;
import droidninja.filepicker.adapters.FileAdapterListener;
import droidninja.filepicker.adapters.PhotoGridAdapter;
import droidninja.filepicker.adapters.SelectableAdapter;
import droidninja.filepicker.models.Media;
import droidninja.filepicker.models.PhotoDirectory;
import droidninja.filepicker.utils.AndroidLifecycleUtils;
import droidninja.filepicker.viewmodels.VMMediaPicker;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 /2\u00020\u00012\u00020\u0002:\u0001/B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u001a\u001a\u00020\u001bH\u0014J\b\u0010\u001c\u001a\u00020\u001bH\u0016J\u0012\u0010\u001d\u001a\u00020\u001b2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0015J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020\u001bH\u0016J\u0010\u0010%\u001a\u00020!2\u0006\u0010&\u001a\u00020\u0012H\u0016J\b\u0010'\u001a\u00020\u001bH\u0002J\u0010\u0010(\u001a\u00020\u001b2\u0006\u0010)\u001a\u00020\u0007H\u0016J\b\u0010*\u001a\u00020\u001bH\u0002J\u0016\u0010+\u001a\u00020\u001b2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020.0-H\u0002R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u00020\u0015X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019\u00a8\u00060"}, d2={"Ldroidninja/filepicker/MediaDetailsActivity;", "Ldroidninja/filepicker/BaseFilePickerActivity;", "Ldroidninja/filepicker/adapters/FileAdapterListener;", "()V", "emptyView", "Landroid/widget/TextView;", "fileType", "", "imageFileSize", "mGlideRequestManager", "Lcom/bumptech/glide/RequestManager;", "photoDirectory", "Ldroidninja/filepicker/models/PhotoDirectory;", "photoGridAdapter", "Ldroidninja/filepicker/adapters/PhotoGridAdapter;", "recyclerView", "Landroidx/recyclerview/widget/RecyclerView;", "selectAllItem", "Landroid/view/MenuItem;", "videoFileSize", "viewModel", "Ldroidninja/filepicker/viewmodels/VMMediaPicker;", "getViewModel", "()Ldroidninja/filepicker/viewmodels/VMMediaPicker;", "setViewModel", "(Ldroidninja/filepicker/viewmodels/VMMediaPicker;)V", "initView", "", "onBackPressed", "onCreate", "savedInstanceState", "Landroid/os/Bundle;", "onCreateOptionsMenu", "", "menu", "Landroid/view/Menu;", "onItemSelected", "onOptionsItemSelected", "item", "resumeRequestsIfNotDestroyed", "setTitle", "count", "setUpView", "updateList", "medias", "", "Ldroidninja/filepicker/models/Media;", "Companion", "filepicker_release"})
public final class MediaDetailsActivity
extends BaseFilePickerActivity
implements FileAdapterListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private RecyclerView recyclerView;
    @Nullable
    private TextView emptyView;
    private RequestManager mGlideRequestManager;
    @Nullable
    private PhotoGridAdapter photoGridAdapter;
    private int fileType;
    private int imageFileSize = Integer.MAX_VALUE;
    private int videoFileSize = Integer.MAX_VALUE;
    @Nullable
    private MenuItem selectAllItem;
    @Nullable
    private PhotoDirectory photoDirectory;
    public VMMediaPicker viewModel;
    private static final int SCROLL_THRESHOLD = 30;

    @NotNull
    public final VMMediaPicker getViewModel() {
        VMMediaPicker vMMediaPicker = this.viewModel;
        if (vMMediaPicker != null) {
            return vMMediaPicker;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"viewModel");
        throw null;
    }

    public final void setViewModel(@NotNull VMMediaPicker vMMediaPicker) {
        Intrinsics.checkNotNullParameter((Object)((Object)vMMediaPicker), (String)"<set-?>");
        this.viewModel = vMMediaPicker;
    }

    @SuppressLint(value={"MissingSuperCall"})
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState, R.layout.activity_media_details);
    }

    @Override
    protected void initView() {
        ViewModel viewModel = new ViewModelProvider((ViewModelStoreOwner)this, (ViewModelProvider.Factory)new ViewModelProvider.AndroidViewModelFactory(this.getApplication())).get(VMMediaPicker.class);
        Intrinsics.checkNotNullExpressionValue((Object)viewModel, (String)"ViewModelProvider(this, ViewModelProvider.AndroidViewModelFactory(application)).get(VMMediaPicker::class.java)");
        this.setViewModel((VMMediaPicker)viewModel);
        viewModel = Glide.with((FragmentActivity)((FragmentActivity)this));
        Intrinsics.checkNotNullExpressionValue((Object)viewModel, (String)"with(this)");
        this.mGlideRequestManager = viewModel;
        Intent intent2 = this.getIntent();
        if (intent2 != null) {
            this.fileType = intent2.getIntExtra("EXTRA_FILE_TYPE", 1);
            this.imageFileSize = intent2.getIntExtra("EXTRA_IMAGE_FILE_SIZE", Integer.MAX_VALUE);
            this.videoFileSize = intent2.getIntExtra("EXTRA__VIDEO_FILE_SIZE", Integer.MAX_VALUE);
            this.photoDirectory = (PhotoDirectory)intent2.getParcelableExtra(PhotoDirectory.class.getSimpleName());
            if (this.photoDirectory != null) {
                this.setUpView();
                this.setTitle(0);
            }
        }
    }

    public void setTitle(int count) {
        ActionBar actionBar = this.getSupportActionBar();
        if (actionBar != null) {
            actionBar.setDisplayHomeAsUpEnabled(true);
            int maxCount = PickerManager.INSTANCE.getMaxCount();
            if (maxCount == -1 && count > 0) {
                StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                String string2 = this.getString(R.string.attachments_num);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(R.string.attachments_num)");
                Object[] objectArray = new Object[]{count};
                boolean bl = false;
                String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"java.lang.String.format(format, *args)");
                actionBar.setTitle((CharSequence)string3);
            } else if (maxCount > 0 && count > 0) {
                StringCompanionObject stringCompanionObject = StringCompanionObject.INSTANCE;
                String string4 = this.getString(R.string.attachments_title_text);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getString(R.string.attachments_title_text)");
                Object[] objectArray = new Object[]{count, maxCount};
                boolean bl = false;
                String string5 = String.format(string4, Arrays.copyOf(objectArray, objectArray.length));
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"java.lang.String.format(format, *args)");
                actionBar.setTitle((CharSequence)string5);
            } else {
                PhotoDirectory photoDirectory = this.photoDirectory;
                actionBar.setTitle((CharSequence)(photoDirectory == null ? null : photoDirectory.getName()));
            }
        }
    }

    private final void setUpView() {
        this.recyclerView = (RecyclerView)this.findViewById(R.id.recyclerview);
        this.emptyView = (TextView)this.findViewById(R.id.empty_view);
        Integer n = PickerManager.INSTANCE.getSpanTypes().get((Object)FilePickerConst.SPAN_TYPE.DETAIL_SPAN);
        int spanCount = n == null ? 3 : n;
        StaggeredGridLayoutManager layoutManager = new StaggeredGridLayoutManager(spanCount, 1);
        layoutManager.setGapStrategy(2);
        Object object = this.recyclerView;
        if (object != null) {
            object.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
        }
        object = this.recyclerView;
        if (object != null) {
            object.setItemAnimator((RecyclerView.ItemAnimator)new DefaultItemAnimator());
        }
        object = this.recyclerView;
        if (object != null) {
            object.addOnScrollListener(new RecyclerView.OnScrollListener(this){
                final /* synthetic */ MediaDetailsActivity this$0;
                {
                    this.this$0 = $receiver;
                }

                public void onScrolled(@NotNull RecyclerView recyclerView, int dx, int dy) {
                    Intrinsics.checkNotNullParameter((Object)recyclerView, (String)"recyclerView");
                    super.onScrolled(recyclerView, dx, dy);
                    if (Math.abs(dy) > MediaDetailsActivity.access$getSCROLL_THRESHOLD$cp()) {
                        RequestManager requestManager = MediaDetailsActivity.access$getMGlideRequestManager$p(this.this$0);
                        if (requestManager == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"mGlideRequestManager");
                            throw null;
                        }
                        requestManager.pauseRequests();
                    } else {
                        MediaDetailsActivity.access$resumeRequestsIfNotDestroyed(this.this$0);
                    }
                }

                public void onScrollStateChanged(@NotNull RecyclerView recyclerView, int newState) {
                    Intrinsics.checkNotNullParameter((Object)recyclerView, (String)"recyclerView");
                    if (newState == 0) {
                        MediaDetailsActivity.access$resumeRequestsIfNotDestroyed(this.this$0);
                    }
                }
            });
        }
        this.getViewModel().getLvMediaData().observe((LifecycleOwner)this, arg_0 -> MediaDetailsActivity.setUpView$lambda-0(this, arg_0));
        object = this.photoDirectory;
        this.getViewModel().getMedia(object == null ? null : ((PhotoDirectory)object).getBucketId(), this.fileType, this.imageFileSize, this.videoFileSize);
    }

    private final void updateList(List<Media> medias) {
        Object object = medias;
        boolean bl = false;
        if (!object.isEmpty()) {
            object = this.emptyView;
            if (object != null) {
                object.setVisibility(8);
            }
            object = this.recyclerView;
            if (object != null) {
                object.setVisibility(0);
            }
        } else {
            object = this.emptyView;
            if (object != null) {
                object.setVisibility(0);
            }
            object = this.recyclerView;
            if (object != null) {
                object.setVisibility(8);
            }
            return;
        }
        if (this.photoGridAdapter != null) {
            object = this.photoGridAdapter;
            if (object != null) {
                ((SelectableAdapter)object).setData(medias, (List<Uri>)PickerManager.INSTANCE.getSelectedPhotos());
            }
        } else {
            object = this.mGlideRequestManager;
            if (object == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mGlideRequestManager");
                throw null;
            }
            this.photoGridAdapter = new PhotoGridAdapter((Context)this, (RequestManager)object, medias, (List<Uri>)PickerManager.INSTANCE.getSelectedPhotos(), false, this);
            object = this.recyclerView;
            if (object != null) {
                object.setAdapter((RecyclerView.Adapter)this.photoGridAdapter);
            }
        }
        if (PickerManager.INSTANCE.getMaxCount() == -1) {
            if (this.photoGridAdapter != null && this.selectAllItem != null) {
                object = this.photoGridAdapter;
                Integer n = object == null ? null : Integer.valueOf(((PhotoGridAdapter)object).getItemCount());
                object = this.photoGridAdapter;
                if (Intrinsics.areEqual((Object)n, object == null ? null : Integer.valueOf(((SelectableAdapter)object).getSelectedItemCount()))) {
                    object = this.selectAllItem;
                    if (object != null) {
                        object.setIcon(R.drawable.ic_select_all);
                    }
                    object = this.selectAllItem;
                    if (object != null) {
                        object.setChecked(true);
                    }
                }
            }
            this.setTitle(PickerManager.INSTANCE.getCurrentCount());
        }
    }

    private final void resumeRequestsIfNotDestroyed() {
        if (!AndroidLifecycleUtils.INSTANCE.canLoadImage((Activity)this)) {
            return;
        }
        RequestManager requestManager = this.mGlideRequestManager;
        if (requestManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mGlideRequestManager");
            throw null;
        }
        requestManager.resumeRequests();
    }

    public boolean onCreateOptionsMenu(@NotNull Menu menu2) {
        Intrinsics.checkNotNullParameter((Object)menu2, (String)"menu");
        this.getMenuInflater().inflate(R.menu.media_detail_menu, menu2);
        MenuItem menuItem = this.selectAllItem = menu2.findItem(R.id.action_select);
        if (menuItem != null) {
            menuItem.setVisible(PickerManager.INSTANCE.hasSelectAll());
        }
        menuItem = menu2.findItem(R.id.action_done);
        if (menuItem != null) {
            menuItem.setVisible(PickerManager.INSTANCE.getMaxCount() > 1);
        }
        return super.onCreateOptionsMenu(menu2);
    }

    public boolean onOptionsItemSelected(@NotNull MenuItem item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        int itemId = item.getItemId();
        if (itemId == R.id.action_done) {
            this.setResult(-1, null);
            this.finish();
            return true;
        }
        if (itemId == R.id.action_select) {
            MenuItem menuItem = this.selectAllItem;
            if (menuItem != null) {
                MenuItem menuItem2 = menuItem;
                boolean bl = false;
                boolean bl2 = false;
                MenuItem it = menuItem2;
                boolean bl3 = false;
                PhotoGridAdapter photoGridAdapter = this.photoGridAdapter;
                if (photoGridAdapter != null) {
                    PhotoGridAdapter photoGridAdapter2 = photoGridAdapter;
                    boolean bl4 = false;
                    boolean bl5 = false;
                    PhotoGridAdapter adapter = photoGridAdapter2;
                    boolean bl6 = false;
                    if (it.isChecked()) {
                        PickerManager.INSTANCE.deleteMedia(adapter.getSelectedPaths());
                        adapter.clearSelection();
                        it.setIcon(R.drawable.ic_deselect_all);
                    } else {
                        adapter.selectAll();
                        PickerManager.INSTANCE.add(adapter.getSelectedPaths(), 1);
                        it.setIcon(R.drawable.ic_select_all);
                    }
                    it.setChecked(!it.isChecked());
                    this.setTitle(PickerManager.INSTANCE.getCurrentCount());
                }
            }
            return true;
        }
        if (itemId == 16908332) {
            this.onBackPressed();
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    @Override
    public void onItemSelected() {
        int maxCount = PickerManager.INSTANCE.getMaxCount();
        if (maxCount == 1) {
            this.setResult(-1, null);
            this.finish();
        }
        this.setTitle(PickerManager.INSTANCE.getCurrentCount());
    }

    public void onBackPressed() {
        this.setResult(0, null);
        this.finish();
    }

    @Override
    public void _$_clearFindViewByIdCache() {
    }

    private static final void setUpView$lambda-0(MediaDetailsActivity this$0, List data) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullExpressionValue((Object)data, (String)"data");
        this$0.updateList(data);
    }

    public static final /* synthetic */ int access$getSCROLL_THRESHOLD$cp() {
        return SCROLL_THRESHOLD;
    }

    public static final /* synthetic */ RequestManager access$getMGlideRequestManager$p(MediaDetailsActivity $this) {
        return $this.mGlideRequestManager;
    }

    public static final /* synthetic */ void access$resumeRequestsIfNotDestroyed(MediaDetailsActivity $this) {
        $this.resumeRequestsIfNotDestroyed();
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Ldroidninja/filepicker/MediaDetailsActivity$Companion;", "", "()V", "SCROLL_THRESHOLD", "", "filepicker_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

