/*
 * Decompiled with CFR 0.152.
 */
package com.tugos.dst.admin.utils;

import com.tugos.dst.admin.utils.DstConstant;
import com.tugos.dst.admin.utils.ShellUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;

/*
 * Exception performing whole class analysis ignored.
 */
public class FileUtils {
    private static final Logger log = LoggerFactory.getLogger(FileUtils.class);

    public static List<String> getFiles(String path) {
        ArrayList<String> files = new ArrayList<String>();
        File file = new File(path);
        File[] children = file.listFiles();
        if (children != null) {
            for (File child : children) {
                if (!child.isFile()) continue;
                files.add(child.toString());
            }
        }
        return files;
    }

    public static List<String> getFileNames(String path) {
        ArrayList<String> fileNames = new ArrayList<String>();
        File dir = new File(path);
        String[] children = dir.list();
        if (children != null) {
            fileNames.addAll(Arrays.asList(children));
        }
        return fileNames;
    }

    public static boolean mkdirs(String path) {
        File file = new File(path);
        if (!file.exists()) {
            return file.mkdirs();
        }
        return true;
    }

    public static String readFile(String filePath) throws Exception {
        int len;
        File file = new File(filePath);
        if (!file.exists()) {
            return null;
        }
        FileInputStream inputStream = new FileInputStream(file);
        byte[] buf = new byte[1024];
        StringBuilder sb = new StringBuilder();
        while ((len = ((InputStream)inputStream).read(buf)) != -1) {
            sb.append(new String(buf, 0, len));
        }
        ((InputStream)inputStream).close();
        return sb.toString();
    }

    public static void writeFile(String filePath, String context) throws Exception {
        File file = new File(filePath);
        FileOutputStream outputStream = new FileOutputStream(file);
        ((OutputStream)outputStream).write(context.getBytes());
        outputStream.flush();
        ((OutputStream)outputStream).close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<String> readLastNLine(File file, long numRead) {
        ArrayList<String> result = new ArrayList<String>();
        long count = 0L;
        if (!file.exists()) return result;
        if (file.isDirectory()) return result;
        if (!file.canRead()) {
            return result;
        }
        try (RandomAccessFile fileRead = new RandomAccessFile(file, "r");){
            long length = fileRead.length();
            if (length == 0L) {
                ArrayList<String> arrayList = result;
                return arrayList;
            }
            long pos = length - 1L;
            while (pos > 0L) {
                fileRead.seek(--pos);
                if (fileRead.readByte() != 10) continue;
                String line = fileRead.readLine();
                result.add(new String(line.getBytes(StandardCharsets.ISO_8859_1), StandardCharsets.UTF_8));
                if (++count != numRead) continue;
            }
            if (pos == 0L) {
                fileRead.seek(0L);
                result.add(new String(fileRead.readLine().getBytes(StandardCharsets.ISO_8859_1), StandardCharsets.UTF_8));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Collections.reverse(result);
        return result;
    }

    public static boolean fileShellCopy(String fileName) throws Exception {
        int len;
        File file = new File(fileName);
        if (file.exists()) {
            log.info("\u811a\u672c\u5df2\u7ecf\u5b58\u5728,{}", (Object)fileName);
            return false;
        }
        ClassPathResource classPathResource = new ClassPathResource("shell/" + fileName);
        InputStream inputStream = classPathResource.getInputStream();
        FileOutputStream outputStream = new FileOutputStream(file);
        byte[] buf = new byte[1024];
        StringBuffer sb = new StringBuffer();
        while ((len = inputStream.read(buf)) != -1) {
            sb.append(new String(buf, 0, len));
        }
        ((OutputStream)outputStream).write(sb.toString().getBytes());
        outputStream.flush();
        inputStream.close();
        ((OutputStream)outputStream).close();
        log.info("\u62f7\u8d1d\u811a\u672c{}\u6210\u529f.....", (Object)fileName);
        return true;
    }

    public static void chmod(String fileName) {
        StringBuffer sb = new StringBuffer();
        String shellFilePath = DstConstant.SHELL_FILE_PATH;
        sb.append("cd ").append(shellFilePath).append(" ;");
        sb.append("chmod +x ./").append(fileName);
        ShellUtil.runShell((String)sb.toString());
        log.info("\u7ed9{}\u76ee\u5f55\u4e0b\u7684{}\u6587\u4ef6\u6388\u6743\u6210\u529f", (Object)DstConstant.SHELL_FILE_PATH, (Object)fileName);
    }

    public static void writeLineFile(String path, List<String> data) throws Exception {
        if (CollectionUtils.isEmpty(data)) {
            data = new ArrayList<String>();
        }
        StringBuilder content = new StringBuilder();
        data.forEach(e -> content.append((String)e).append("\n"));
        FileUtils.writeFile((String)path, (String)content.toString());
    }

    public static List<String> readLineFile(String path) {
        ArrayList<String> result = new ArrayList<String>();
        File file = new File(path);
        if (!file.exists()) {
            return result;
        }
        try (FileInputStream fis = new FileInputStream(path);
             InputStreamReader isr = new InputStreamReader(fis);
             BufferedReader br = new BufferedReader(isr);){
            String str;
            while ((str = br.readLine()) != null) {
                result.add(str);
            }
        }
        catch (Exception e) {
            log.error("\u4e00\u884c\u884c\u7684\u8bfb\u53d6\u6587\u4ef6\u5931\u8d25\uff1a", (Throwable)e);
        }
        return result;
    }

    public static String findMasterPath(File file) {
        if (file == null) {
            return null;
        }
        String resultPath = null;
        if (file.listFiles() != null && file.listFiles().length > 0) {
            block0: for (File listFile : file.listFiles()) {
                if (listFile.getAbsolutePath().contains("__MACOSX")) continue;
                if (listFile.isDirectory() && listFile.getAbsolutePath().contains("Master")) {
                    resultPath = listFile.getParent();
                    break;
                }
                if (listFile.listFiles() == null || listFile.listFiles().length <= 0) continue;
                block1: for (File file1 : listFile.listFiles()) {
                    if (file1.isDirectory() && file1.getAbsolutePath().contains("Master")) {
                        resultPath = file1.getParent();
                        continue block0;
                    }
                    if (file1.listFiles() == null || file1.listFiles().length <= 0) continue;
                    block2: for (File file2 : file1.listFiles()) {
                        if (file2.isDirectory() && file2.getAbsolutePath().contains("Master")) {
                            resultPath = file2.getParent();
                            continue block1;
                        }
                        if (file2.listFiles() == null || file2.listFiles().length <= 0) continue;
                        for (File file3 : file2.listFiles()) {
                            if (!file3.isDirectory() || !file3.getAbsolutePath().contains("Master")) continue;
                            resultPath = file3.getParent();
                            continue block2;
                        }
                    }
                }
            }
        }
        return resultPath;
    }
}

