/*
 * Decompiled with CFR 0.152.
 */
package com.tugos.dst.admin.service;

import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import com.google.common.collect.Lists;
import com.tugos.dst.admin.config.I18nResourcesConfig;
import com.tugos.dst.admin.enums.DstLogTypeEnum;
import com.tugos.dst.admin.service.SystemService;
import com.tugos.dst.admin.utils.DBUtils;
import com.tugos.dst.admin.utils.DstConfigData;
import com.tugos.dst.admin.utils.DstConstant;
import com.tugos.dst.admin.utils.DstVersionUtils;
import com.tugos.dst.admin.utils.FileUtils;
import com.tugos.dst.admin.vo.GamePortVO;
import com.tugos.dst.admin.vo.ScheduleVO;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class SystemService {
    public List<String> getDstLog(Integer type, Integer rowNum) {
        String path;
        switch (1.$SwitchMap$com$tugos$dst$admin$enums$DstLogTypeEnum[Objects.requireNonNull(DstLogTypeEnum.get((Integer)type)).ordinal()]) {
            case 1: {
                path = DstConstant.ROOT_PATH + "/" + ".klei/DoNotStarveTogether/MyDediServer/Caves/server_log.txt";
                break;
            }
            case 2: {
                path = DstConstant.ROOT_PATH + "/" + ".klei/DoNotStarveTogether/MyDediServer/Master/server_chat_log.txt";
                break;
            }
            default: {
                path = DstConstant.ROOT_PATH + "/" + ".klei/DoNotStarveTogether/MyDediServer/Master/server_log.txt";
            }
        }
        File file = new File(path);
        List result = FileUtils.readLastNLine((File)file, (long)rowNum.intValue());
        if (CollectionUtils.isEmpty((Collection)result)) {
            result = Lists.newArrayList((Object[])new String[]{I18nResourcesConfig.getMessage((String)"tip.log.not.exist") + ":" + path});
        }
        return result;
    }

    public ScheduleVO getScheduleList() {
        Set backupSet;
        ScheduleVO data = new ScheduleVO();
        Set updateSet = DstConfigData.SCHEDULE_UPDATE_MAP.keySet();
        if (CollectionUtils.isNotEmpty(updateSet)) {
            ArrayList updateTimeList = new ArrayList();
            updateSet.forEach(e -> {
                ScheduleVO.InnerData innerData = new ScheduleVO.InnerData();
                innerData.setTime(e);
                innerData.setCount(((Integer)DstConfigData.SCHEDULE_UPDATE_MAP.get(e)).intValue());
                updateTimeList.add(innerData);
            });
            data.setUpdateTimeList(updateTimeList);
        }
        if (CollectionUtils.isNotEmpty(backupSet = DstConfigData.SCHEDULE_BACKUP_MAP.keySet())) {
            ArrayList backupTimeList = new ArrayList();
            backupSet.forEach(e -> {
                ScheduleVO.InnerData innerData = new ScheduleVO.InnerData();
                innerData.setTime(e);
                innerData.setCount(((Integer)DstConfigData.SCHEDULE_BACKUP_MAP.get(e)).intValue());
                backupTimeList.add(innerData);
            });
            data.setBackupTimeList(backupTimeList);
        }
        data.setNotStartMaster(DstConfigData.notStartMaster);
        data.setNotStartCaves(DstConfigData.notStartCaves);
        data.setSmartUpdate(DstConfigData.smartUpdate);
        return data;
    }

    public void saveSchedule(ScheduleVO vo) {
        DstConfigData.clearAllData();
        if (CollectionUtils.isNotEmpty((Collection)vo.getBackupTimeList())) {
            vo.getBackupTimeList().forEach(e -> {
                if (StringUtils.isNotBlank((CharSequence)e.getTime())) {
                    DateTime parse = DateUtil.parse((CharSequence)e.getTime(), (String)"yyyy-MM-dd HH:mm");
                    String format = DateUtil.format((Date)parse, (String)"HH:mm:ss");
                    DstConfigData.SCHEDULE_BACKUP_MAP.put(format, e.getCount());
                }
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)vo.getUpdateTimeList())) {
            vo.getUpdateTimeList().forEach(e -> {
                if (StringUtils.isNotBlank((CharSequence)e.getTime())) {
                    DateTime parse = DateUtil.parse((CharSequence)e.getTime(), (String)"yyyy-MM-dd HH:mm");
                    String format = DateUtil.format((Date)parse, (String)"HH:mm:ss");
                    DstConfigData.SCHEDULE_UPDATE_MAP.put(format, e.getCount());
                }
            });
        }
        DstConfigData.notStartMaster = vo.getNotStartCaves() != null ? vo.getNotStartMaster() : Boolean.valueOf(false);
        DstConfigData.notStartCaves = vo.getNotStartCaves() != null ? vo.getNotStartCaves() : Boolean.valueOf(false);
        DstConfigData.smartUpdate = vo.getSmartUpdate() != null ? vo.getSmartUpdate() : Boolean.valueOf(false);
    }

    public Map<String, String> getVersion() {
        String steamVersion = DstVersionUtils.getSteamVersionV3();
        String localVersion = DstVersionUtils.getLocalVersion();
        HashMap<String, String> map = new HashMap<String, String>(16);
        map.put("steamVersion", steamVersion);
        map.put("localVersion", localVersion);
        return map;
    }

    public GamePortVO getGamePort() {
        GamePortVO gamePortVO = new GamePortVO();
        gamePortVO.setMasterPort(DstConfigData.masterPort);
        gamePortVO.setGroundPort(DstConfigData.groundPort);
        gamePortVO.setCavesPort(DstConfigData.cavesPort);
        return gamePortVO;
    }

    public void saveGamePort(GamePortVO gamePortVO) {
        DstConfigData.masterPort = gamePortVO.getMasterPort();
        DstConfigData.groundPort = gamePortVO.getGroundPort();
        DstConfigData.cavesPort = gamePortVO.getCavesPort();
        DBUtils.saveDataToFile();
    }
}

