/*
 * Decompiled with CFR 0.152.
 */
package com.tugos.dst.admin.exception;

import com.tugos.dst.admin.common.ResultCodeEnum;
import com.tugos.dst.admin.common.ResultVO;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.web.servlet.error.ErrorController;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class CustomExceptionHandler
implements ErrorController {
    private static final Logger log = LoggerFactory.getLogger(CustomExceptionHandler.class);
    private static final String ERROR_PATH = "/error";
    private static final Integer ERROR_START_404 = 404;
    private static final Integer ERROR_START_405 = 405;
    private static final Integer ERROR_START_500 = 500;

    public String getErrorPath() {
        return ERROR_PATH;
    }

    @RequestMapping(value={"/error"}, produces={"text/html"})
    public String errorPageHandler(Model model, HttpServletResponse response) {
        int status = response.getStatus();
        String errorMsg = ResultCodeEnum.SYSTEM_ERR.getMessage();
        if (status == ERROR_START_404) {
            errorMsg = ResultCodeEnum.REQUEST_NOT_FOUND.getMessage();
        }
        model.addAttribute("statusCode", (Object)status);
        model.addAttribute("msg", (Object)errorMsg);
        return "system/main/error";
    }

    @RequestMapping(value={"/error"})
    @ResponseBody
    public ResultVO<String> errorApiHandler(HttpServletRequest request, HttpServletResponse response) {
        int status = response.getStatus();
        log.debug("\u5904\u7406\u7528\u6237\u8bf7\u6c42\u5f02\u5e38\u72b6\u6001\u7801\uff1a{}", (Object)status);
        response.setStatus(200);
        if (status == ERROR_START_404) {
            return ResultVO.fail((ResultCodeEnum)ResultCodeEnum.REQUEST_NOT_FOUND);
        }
        if (status == ERROR_START_405) {
            return ResultVO.fail((ResultCodeEnum)ResultCodeEnum.METHOD_NOT_ALLOWED);
        }
        if (status == ERROR_START_500) {
            return ResultVO.fail((ResultCodeEnum)ResultCodeEnum.SYSTEM_ERR);
        }
        return ResultVO.fail((ResultCodeEnum)ResultCodeEnum.FAILURE);
    }
}

