/*
 * Decompiled with CFR 0.152.
 */
package com.zqc.opencc.android.lib;

import android.content.Context;
import android.content.res.AssetManager;
import android.util.Log;
import com.zqc.opencc.android.lib.ConversionType;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ChineseConverter {
    public static String convert(String text, ConversionType conversionType, Context context) {
        File lastDataFile = new File(context.getFilesDir() + "/openccdata/zFinished2");
        if (!lastDataFile.exists()) {
            ChineseConverter.initialize(context);
        }
        File dataFolder = new File(context.getFilesDir() + "/openccdata");
        return ChineseConverter.convert(text, conversionType.getValue(), dataFolder.getAbsolutePath());
    }

    public static void clearDictDataFolder(Context context) {
        File dataFolder = new File(context.getFilesDir() + "/openccdata");
        ChineseConverter.deleteRecursive(dataFolder);
    }

    private static void deleteRecursive(File fileOrDirectory) {
        if (fileOrDirectory.isDirectory()) {
            for (File child : fileOrDirectory.listFiles()) {
                ChineseConverter.deleteRecursive(child);
            }
        }
        fileOrDirectory.delete();
    }

    private static native String convert(String var0, String var1, String var2);

    private static void initialize(Context context) {
        ChineseConverter.copyFolder("openccdata", context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyFolder(String folderName, Context context) {
        File fileFolderOnDisk = new File(context.getFilesDir() + "/" + folderName);
        AssetManager assetManager = context.getAssets();
        String[] files = null;
        try {
            files = assetManager.list(folderName);
        }
        catch (IOException e) {
            Log.e((String)"tag", (String)"Failed to get asset file list.", (Throwable)e);
        }
        if (files != null) {
            for (String filename : files) {
                InputStream in = null;
                OutputStream out = null;
                try {
                    File outFile;
                    in = assetManager.open(folderName + "/" + filename);
                    if (!fileFolderOnDisk.exists()) {
                        fileFolderOnDisk.mkdirs();
                    }
                    if (!(outFile = new File(fileFolderOnDisk.getAbsolutePath(), filename)).exists()) {
                        outFile.createNewFile();
                    }
                    out = new FileOutputStream(outFile);
                    ChineseConverter.copyFile(in, out);
                }
                catch (IOException e) {
                    Log.e((String)"tag", (String)("Failed to copy asset file: " + filename), (Throwable)e);
                }
                finally {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        }
    }

    private static void copyFile(InputStream in, OutputStream out) throws IOException {
        int read;
        byte[] buffer = new byte[1024];
        while ((read = in.read(buffer)) != -1) {
            out.write(buffer, 0, read);
        }
    }

    static {
        System.loadLibrary("ChineseConverter");
    }
}

