/*
 * Decompiled with CFR 0.152.
 */
package com.github.pyknic.bigarray.internal.util;

public final class BitUtil {
    public static final int BITMASK_SIZE = 16;

    public static boolean isSet(short bitmask, long index) {
        switch ((short)(index & 0xFFL)) {
            case 0: {
                return 1 == (bitmask & 1);
            }
            case 1: {
                return 2 == (bitmask & 2);
            }
            case 2: {
                return 4 == (bitmask & 4);
            }
            case 3: {
                return 8 == (bitmask & 8);
            }
            case 4: {
                return 16 == (bitmask & 0x10);
            }
            case 5: {
                return 32 == (bitmask & 0x20);
            }
            case 6: {
                return 64 == (bitmask & 0x40);
            }
            case 7: {
                return 128 == (bitmask & 0x80);
            }
            case 8: {
                return 256 == (bitmask & 0x100);
            }
            case 9: {
                return 512 == (bitmask & 0x200);
            }
            case 10: {
                return 1024 == (bitmask & 0x400);
            }
            case 11: {
                return 2048 == (bitmask & 0x800);
            }
            case 12: {
                return 4096 == (bitmask & 0x1000);
            }
            case 13: {
                return 8192 == (bitmask & 0x2000);
            }
            case 14: {
                return 16384 == (bitmask & 0x4000);
            }
            case 15: {
                return 32768 == (bitmask & 0x8000);
            }
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public static boolean isLongToBytePossible(long value) {
        return 0L == (value & 0x7FFFFFFFFFFFFF80L);
    }

    public static boolean isLongToShortPossible(long value) {
        return 0L == (value & 0x7FFFFFFFFFFF8000L);
    }

    public static boolean isLongToIntPossible(long value) {
        return 0L == (value & 0x7FFFFFFF80000000L);
    }

    public static boolean isIntToBytePossible(int value) {
        return 0 == (value & 0x7FFFFF80);
    }

    public static boolean isIntToShortPossible(int value) {
        return 0 == (value & 0x7FFF8000);
    }

    public static boolean isShortToBytePossible(short value) {
        return 0 == (value & 0x7F80);
    }

    public static byte longToByte(long value) {
        return BitUtil.isLongNegative(value) ? (byte)(0x7FL & value | 0x80L) : (byte)(0x7FL & value);
    }

    public static short longToShort(long value) {
        return BitUtil.isLongNegative(value) ? (short)(0x7FFFL & value | 0x8000L) : (short)(0x7FFFL & value);
    }

    public static short longToInt(long value) {
        return BitUtil.isLongNegative(value) ? (short)(Integer.MAX_VALUE & value | Integer.MIN_VALUE) : (short)(Integer.MAX_VALUE & value);
    }

    public static byte intToByte(int value) {
        return BitUtil.isIntNegative(value) ? (byte)(0x7F & value | 0x80) : (byte)(0x7F & value);
    }

    public static short intToShort(int value) {
        return BitUtil.isIntNegative(value) ? (short)(Short.MAX_VALUE & value | 0x8000) : (short)(Short.MAX_VALUE & value);
    }

    public static byte shortToByte(short value) {
        return BitUtil.isShortNegative(value) ? (byte)(0x7F & value | 0x80) : (byte)(0x7F & value);
    }

    public static boolean isLongNegative(long value) {
        return Long.MIN_VALUE == (value & Long.MIN_VALUE);
    }

    public static boolean isIntNegative(int value) {
        return Integer.MIN_VALUE == (value & Integer.MIN_VALUE);
    }

    public static boolean isShortNegative(short value) {
        return 32768 == (value & 0x8000);
    }

    private BitUtil() {
    }
}

