/*
 * Decompiled with CFR 0.152.
 */
package com.github.pyknic.bigarray.internal.shorts;

import com.github.pyknic.bigarray.IntImmutableArray;
import com.github.pyknic.bigarray.LongImmutableArray;
import com.github.pyknic.bigarray.ShortImmutableArray;
import com.github.pyknic.bigarray.internal.util.IndexUtil;
import java.nio.ShortBuffer;

final class ShortMultiBufferImmutableArrayImpl
implements ShortImmutableArray,
IntImmutableArray,
LongImmutableArray {
    private final ShortBuffer[] buffers;
    private final long length;

    ShortMultiBufferImmutableArrayImpl(ShortBuffer[] buffers, long length) {
        this.buffers = buffers;
        this.length = length;
    }

    @Override
    public long getAsLong(long index) {
        return this.getAsShort(index);
    }

    @Override
    public int getAsInt(long index) {
        return this.getAsShort(index);
    }

    @Override
    public short getAsShort(long index) {
        return this.buffers[IndexUtil.outerIndex(index)].get(IndexUtil.innerIndex(index));
    }

    @Override
    public long length() {
        return this.length;
    }
}

