/*
 * Decompiled with CFR 0.152.
 */
package com.github.pyknic.bigarray.internal;

import com.github.pyknic.bigarray.ByteImmutableArray;
import com.github.pyknic.bigarray.ShortImmutableArray;
import com.github.pyknic.bigarray.internal.EmptyImmutableArray;
import com.github.pyknic.bigarray.internal.ShortImmutableArrayImpl;
import com.github.pyknic.bigarray.internal.ShortMultiBufferImmutableArrayImpl;
import com.github.pyknic.bigarray.internal.ShortSingleBufferImmutableArrayImpl;
import com.github.pyknic.bigarray.internal.util.BitUtil;
import com.github.pyknic.bigarray.internal.util.IndexUtil;
import com.github.pyknic.bigarray.internal.util.MemoryUtil;
import java.nio.ByteBuffer;
import java.nio.ShortBuffer;
import java.util.LinkedList;

public final class ShortImmutableArrayBuilder
implements ShortImmutableArray.Builder {
    private final LinkedList<ShortBuffer> buffers = new LinkedList();
    private short bitmask;
    private int outer = 0;
    private int inner = 0;

    @Override
    public ShortImmutableArray.Builder append(short value) {
        ShortBuffer current;
        if (this.outer == this.buffers.size()) {
            current = ByteBuffer.allocateDirect(0x8000000).asShortBuffer();
            this.buffers.add(current);
        } else {
            current = this.buffers.getLast();
        }
        current.put(this.inner, value);
        this.bitmask = (short)(this.bitmask | value);
        if (0x4000000 == ++this.inner) {
            this.inner = 0;
            ++this.outer;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ShortImmutableArray build() {
        if (this.buffers.isEmpty()) {
            return new EmptyImmutableArray();
        }
        if (BitUtil.isLongToBytePossible(this.bitmask)) {
            ByteImmutableArray.Builder builder = ByteImmutableArray.builder();
            this.forEachThenClear(value -> builder.append(BitUtil.shortToByte(value)));
            this.buffers.forEach(MemoryUtil::clear);
            return (ShortImmutableArray)((Object)builder.build());
        }
        if (this.outer == 0) {
            ShortBuffer current = this.buffers.getFirst();
            if (this.inner < Short.MAX_VALUE) {
                try {
                    short[] array = new short[this.inner];
                    for (int i = 0; i < this.inner; ++i) {
                        array[i] = current.get(i);
                    }
                    ShortImmutableArrayImpl shortImmutableArrayImpl = new ShortImmutableArrayImpl(array);
                    return shortImmutableArrayImpl;
                }
                finally {
                    MemoryUtil.clear(current);
                }
            }
            return new ShortSingleBufferImmutableArrayImpl(current, this.inner);
        }
        return new ShortMultiBufferImmutableArrayImpl(this.bufferArray(), this.length());
    }

    private long length() {
        return this.outer * 0x4000000 + this.inner;
    }

    private ShortBuffer[] bufferArray() {
        return this.buffers.toArray(new ShortBuffer[this.outer + 1]);
    }

    private void forEachThenClear(ShortConsumer action) {
        long length = this.length();
        ShortBuffer[] bufferArray = this.bufferArray();
        for (long l = 0L; l < length; ++l) {
            int o = IndexUtil.outerIndex(l);
            int i = IndexUtil.innerIndex(l);
            action.accept(bufferArray[o].get(i));
            if (i + 1 != 0x4000000) continue;
            MemoryUtil.clear(bufferArray[o]);
        }
    }

    @FunctionalInterface
    private static interface ShortConsumer {
        public void accept(short var1);
    }
}

